/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.regexp.Regexp;
import com.caucho.server.http.Application;
import com.caucho.server.http.ClassLoaderContext;
import com.caucho.server.http.VirtualHost;
import com.caucho.util.BeanUtil;
import com.caucho.util.CauchoSystem;
import com.caucho.util.L10N;
import com.caucho.util.RegistryNode;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.WriteStream;
import java.util.ArrayList;
import java.util.HashMap;

public class WebAppMap {
    static L10N L = new L10N(class$com$caucho$server$http$VirtualHost == null ? (class$com$caucho$server$http$VirtualHost = WebAppMap.class$("com.caucho.server.http.VirtualHost")) : class$com$caucho$server$http$VirtualHost);
    static WriteStream dbg = LogStream.open("/caucho.com/http/host/app");
    private VirtualHost host;
    private ArrayList webApps = new ArrayList();
    private ArrayList regexpApps = new ArrayList();
    static /* synthetic */ Class class$com$caucho$server$http$VirtualHost;

    WebAppMap(VirtualHost host) {
        this.host = host;
    }

    public VirtualHost getHost() {
        return this.host;
    }

    boolean isCaseInsensitive() {
        return this.host.isCaseInsensitive();
    }

    Entry add(String contextPath, RegistryNode node) {
        Entry entry = this.add(contextPath);
        entry.setRegistryNode(node);
        return entry;
    }

    Entry add(String contextPath) {
        boolean isCaseInsensitive = this.isCaseInsensitive();
        for (int i = 0; i < this.webApps.size(); ++i) {
            Entry entry = (Entry)this.webApps.get(i);
            if (isCaseInsensitive && contextPath.equalsIgnoreCase(entry.getContextPath())) {
                return entry;
            }
            if (!contextPath.equals(entry.getContextPath())) continue;
            return entry;
        }
        Entry entry = new Entry(this.host, contextPath);
        this.webApps.add(entry);
        return entry;
    }

    Entry addRegexp(Regexp regexp, RegistryNode node) {
        Entry entry = new Entry(this.host, "");
        entry.setRegexp(regexp);
        entry.setRegistryNode(node);
        this.regexpApps.add(entry);
        return entry;
    }

    public Entry findByWebName(String webName) {
        boolean isCaseInsensitive = this.isCaseInsensitive();
        for (int i = this.webApps.size() - 1; i >= 0; --i) {
            Entry entry = (Entry)this.webApps.get(i);
            if (webName.equals(entry.getWebName())) {
                return entry;
            }
            if (!isCaseInsensitive || !webName.equalsIgnoreCase(entry.getWebName())) continue;
            return entry;
        }
        return null;
    }

    public Entry findByContextPath(String contextPath) {
        boolean isCaseInsensitive = this.isCaseInsensitive();
        for (int i = this.webApps.size() - 1; i >= 0; --i) {
            Entry entry = (Entry)this.webApps.get(i);
            if (contextPath.equals(entry.getContextPath())) {
                return entry;
            }
            if (!isCaseInsensitive || !contextPath.equalsIgnoreCase(entry.getContextPath())) continue;
            return entry;
        }
        return null;
    }

    synchronized Entry findByURI(String uri) {
        Entry entry;
        int i;
        Entry bestEntry = null;
        int bestLength = -1;
        if (this.isCaseInsensitive()) {
            uri = uri.toLowerCase();
        }
        int uriLength = uri.length();
        for (i = this.webApps.size() - 1; i >= 0; --i) {
            entry = (Entry)this.webApps.get(i);
            String contextPath = entry.getContextPath();
            int length = contextPath.length();
            if (!uri.startsWith(contextPath) || uriLength != length && uri.charAt(length) != '/' || length <= bestLength) continue;
            bestEntry = entry;
            bestLength = length;
        }
        for (i = 0; i < this.regexpApps.size(); ++i) {
            entry = (Entry)this.regexpApps.get(i);
            Regexp regexp = entry.getRegexp();
            if (regexp.exec(uri, 0) < 0) continue;
            int begin = 0;
            int end = regexp.getEnd(0);
            int length = end - begin;
            if (length != uriLength && (length >= uriLength || uri.charAt(length) != '/') || length <= bestLength) continue;
            String contextPath = uri.substring(begin, length);
            Entry newEntry = new Entry(this.host, contextPath);
            newEntry.setRegistryNode(entry.getRegistryNode());
            HashMap pathVariableMap = (HashMap)this.host.getPathVariableMap().clone();
            ArrayList<String> vars = new ArrayList<String>();
            for (int j = 0; j < regexp.length(); ++j) {
                int varBegin = regexp.getBegin(j);
                int varEnd = regexp.getEnd(j);
                String value = uri.substring(varBegin, varEnd);
                vars.add(value);
                pathVariableMap.put(String.valueOf(j), value);
                pathVariableMap.put("app" + j, value);
            }
            pathVariableMap.put("regexp", vars);
            newEntry.setPathVariableMap(pathVariableMap);
            String appDir = newEntry.getRegistryNode().getString("app-dir", null);
            if (appDir == null) {
                appDir = "./" + contextPath;
            } else {
                Path rawPath = BeanUtil.lookupPath(appDir, pathVariableMap, this.host.getDocPath());
                appDir = rawPath.getURL();
            }
            Path path = VirtualHost.getAppDir(this.host.getDocPath(), this.host.getWarExpandDir(), appDir);
            if (!path.canRead()) continue;
            newEntry.setCfgAppDir(path);
            this.webApps.add(newEntry);
            bestEntry = newEntry;
            bestLength = length;
        }
        return bestEntry;
    }

    public ArrayList getWebAppList() {
        return this.webApps;
    }

    public ArrayList getApplications() {
        ArrayList<Application> list = new ArrayList<Application>();
        for (int i = 0; i < this.webApps.size(); ++i) {
            Entry entry = (Entry)this.webApps.get(i);
            Application app = entry.getApplication();
            if (app == null) continue;
            list.add(app);
        }
        return list;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class Entry {
        private VirtualHost host;
        private String contextPath;
        private Regexp regexp;
        private String webName;
        private RegistryNode registryNode;
        private String mode = "web-app";
        private HashMap pathVariableMap;
        private Path cfgAppDir;
        private Path warAppDir;
        private Path warPath;
        private ClassLoaderContext parent;
        private Application app;
        private ArrayList dependList = new ArrayList();

        Entry(VirtualHost host, String contextPath) {
            this.host = host;
            this.parent = host;
            this.webName = contextPath;
            if (contextPath.equals("/ROOT") || CauchoSystem.isCaseInsensitive() && contextPath.equals("/root")) {
                contextPath = "";
            }
            this.contextPath = contextPath;
            if (contextPath.equals("")) {
                this.webName = CauchoSystem.isCaseInsensitive() ? "/root" : "/ROOT";
            }
        }

        public String getContextPath() {
            return this.contextPath;
        }

        public void setContextPath(String contextPath) {
            this.contextPath = contextPath;
        }

        public Regexp getRegexp() {
            return this.regexp;
        }

        public void setRegexp(Regexp regexp) {
            this.regexp = regexp;
        }

        public HashMap getPathVariableMap() {
            return this.pathVariableMap;
        }

        public void setPathVariableMap(HashMap pathVariableMap) {
            this.pathVariableMap = pathVariableMap;
        }

        public String getWebName() {
            return this.webName;
        }

        public void setWebName(String webName) {
            this.webName = webName;
        }

        public ClassLoaderContext getParent() {
            return this.parent;
        }

        public void setParent(ClassLoaderContext parent) {
            this.parent = parent;
        }

        public RegistryNode getRegistryNode() {
            return this.registryNode;
        }

        public void setRegistryNode(RegistryNode node) {
            this.registryNode = node;
        }

        public String getMode() {
            return this.mode;
        }

        public void setMode(String mode) {
            this.mode = mode;
        }

        public Application getApplication() {
            return this.app;
        }

        public void setApplication(Application application) {
            this.app = application;
        }

        public Path getCfgAppDir() {
            return this.cfgAppDir;
        }

        public void setCfgAppDir(Path appDir) {
            this.cfgAppDir = appDir;
        }

        public Path getWarAppDir() {
            return this.warAppDir;
        }

        public void setWarAppDir(Path appDir) {
            this.warAppDir = appDir;
        }

        public Path getWarPath() {
            return this.warPath;
        }

        public void setWarPath(Path warPath) {
            this.warPath = warPath;
        }

        public void addDepend(Path depend) {
            if (!this.dependList.contains(depend)) {
                this.dependList.add(depend);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void closeApplication() {
            Application app;
            Entry entry = this;
            synchronized (entry) {
                app = this.app;
                this.app = null;
            }
            if (app != null) {
                app.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Application createApplication() throws Exception {
            Application app = this.app;
            Path appDir = this.warAppDir;
            if (appDir == null) {
                appDir = this.cfgAppDir;
            }
            if (appDir == null) {
                throw new NullPointerException();
            }
            if (app != null) {
                return app;
            }
            HashMap pathVariableMap = this.pathVariableMap;
            if (pathVariableMap == null) {
                pathVariableMap = (HashMap)this.parent.getPathVariableMap().clone();
            }
            app = new Application(this.parent, this.host, this.contextPath, this.registryNode, appDir, pathVariableMap, this.mode);
            for (int i = this.dependList.size() - 1; i >= 0; --i) {
                app.addDepend((Path)this.dependList.get(i));
            }
            Entry entry = this;
            synchronized (entry) {
                if (this.app != null) {
                    return this.app;
                }
                this.app = app;
            }
            return app;
        }

        public String toString() {
            return "[WebAppMap " + this.webName + " context-path:" + this.contextPath + "]";
        }
    }
}

