/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql;

import com.caucho.sql.DBPool;
import com.caucho.sql.XAConnectionAdapter;
import com.caucho.util.L10N;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.WriteStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.Xid;

class XADataSourceAdapter
implements XADataSource,
ConnectionPoolDataSource {
    private static WriteStream dbg = LogStream.open("/caucho.com/sql/pool/new");
    private static L10N L = new L10N(class$com$caucho$sql$XADataSourceAdapter == null ? (class$com$caucho$sql$XADataSourceAdapter = XADataSourceAdapter.class$("com.caucho.sql.XADataSourceAdapter")) : class$com$caucho$sql$XADataSourceAdapter);
    private DBPool _pool;
    private ArrayList _connections = new ArrayList();
    static /* synthetic */ Class class$com$caucho$sql$XADataSourceAdapter;

    XADataSourceAdapter(DBPool pool) {
        this._pool = pool;
    }

    public XAConnection getXAConnection() throws SQLException {
        return this.getXAConnection(this._pool.getUser(), this._pool.getPassword());
    }

    public DBPool getPool() {
        return this._pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XAConnection getXAConnection(String user, String password) throws SQLException {
        Driver driver = this._pool.getDriver();
        String url = this._pool.getURL();
        if (url == null) {
            throw new SQLException(L.l("can't create connection with null url"));
        }
        Properties properties = this._pool.getInfo();
        if (user != null) {
            properties.put("user", user);
        } else {
            properties.put("user", "");
        }
        if (password != null) {
            properties.put("password", password);
        } else {
            properties.put("password", "");
        }
        Connection conn = driver != null ? driver.connect(url, properties) : DriverManager.getConnection(url, properties);
        if (conn == null) {
            throw new SQLException(L.l("can't create connection for `{0}'", url));
        }
        XAConnectionAdapter xaConn = new XAConnectionAdapter(this, conn);
        ArrayList arrayList = this._connections;
        synchronized (arrayList) {
            this._connections.add(xaConn);
        }
        return xaConn;
    }

    public PooledConnection getPooledConnection(String user, String password) throws SQLException {
        return this.getXAConnection(user, password);
    }

    public PooledConnection getPooledConnection() throws SQLException {
        return this.getXAConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XAConnectionAdapter getXADelegate(Xid xid) {
        ArrayList arrayList = this._connections;
        synchronized (arrayList) {
            for (int i = this._connections.size() - 1; i >= 0; --i) {
                XAConnectionAdapter xaConn = (XAConnectionAdapter)this._connections.get(i);
                if (!xid.equals(xaConn.getXid())) continue;
                return xaConn;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(XAConnectionAdapter conn) {
        ArrayList arrayList = this._connections;
        synchronized (arrayList) {
            for (int i = this._connections.size() - 1; i >= 0; --i) {
                XAConnectionAdapter xaConn = (XAConnectionAdapter)this._connections.get(i);
                if (xaConn != conn) continue;
                this._connections.remove(i);
            }
        }
    }

    public int getLoginTimeout() {
        return 0;
    }

    public PrintWriter getLogWriter() {
        return null;
    }

    public void setLoginTimeout(int foo) {
    }

    public void setLogWriter(PrintWriter log) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

