/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

public class CharSegment {
    protected char[] buffer;
    protected int offset;
    protected int length;

    public CharSegment() {
    }

    public CharSegment(char[] buffer, int offset, int length) {
        this.buffer = buffer;
        this.offset = offset;
        this.length = length;
    }

    public void init(char[] buffer, int offset, int length) {
        this.buffer = buffer;
        this.offset = offset;
        this.length = length;
    }

    public int length() {
        return this.length;
    }

    public int getLength() {
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public char charAt(int i) {
        if (i < 0 || i >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.buffer[i + this.offset];
    }

    public char getLastChar() {
        if (this.length == 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.buffer[this.offset + this.length - 1];
    }

    public char[] getBuffer() {
        return this.buffer;
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        srcBegin += this.offset;
        srcEnd += this.offset;
        while (srcBegin < srcEnd) {
            dst[dstBegin++] = this.buffer[srcBegin];
        }
    }

    public String substring(int start) {
        if (start > this.length || start < 0) {
            throw new StringIndexOutOfBoundsException();
        }
        return new String(this.buffer, this.offset + start, this.length - start);
    }

    public String substring(int start, int end) {
        if (start > this.length || start < 0 || start > end) {
            throw new StringIndexOutOfBoundsException();
        }
        return new String(this.buffer, this.offset + start, end - start);
    }

    public int indexOf(char ch) {
        return this.indexOf(ch, 0);
    }

    public int indexOf(char ch, int start) {
        if (start < 0) {
            start = 0;
        }
        int end = this.offset + this.length;
        start += this.offset;
        while (start < end) {
            if (this.buffer[start] == ch) {
                return start - this.offset;
            }
            ++start;
        }
        return -1;
    }

    public int lastIndexOf(char ch) {
        return this.lastIndexOf(ch, this.length - 1);
    }

    public int lastIndexOf(char ch, int start) {
        if (start >= this.length) {
            start = this.length - 1;
        }
        while (start >= 0) {
            if (this.buffer[start + this.offset] == ch) {
                return start;
            }
            --start;
        }
        return -1;
    }

    public int hashCode() {
        int begin;
        int hash = 0;
        char[] buffer = this.buffer;
        int end = begin + this.length;
        for (begin = this.offset; begin < end; ++begin) {
            hash = 65521 * hash + buffer[begin] * 251 + 1021;
        }
        return hash;
    }

    public final boolean equals(Object a) {
        if (this == a) {
            return true;
        }
        if (a instanceof CharSegment) {
            CharSegment cb = (CharSegment)a;
            int length = this.length;
            if (length != cb.length) {
                return false;
            }
            char[] buffer = this.buffer;
            char[] aBuffer = cb.buffer;
            int offset = this.offset;
            int aOffset = cb.offset;
            for (int i = length - 1; i >= 0; --i) {
                if (buffer[offset + i] == aBuffer[aOffset + i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public final boolean equals(CharSegment cb) {
        int length = this.length;
        if (length != cb.length) {
            return false;
        }
        char[] buffer = this.buffer;
        char[] aBuffer = cb.buffer;
        int offset = this.offset;
        int aOffset = cb.offset;
        for (int i = length - 1; i >= 0; --i) {
            if (buffer[offset + i] == aBuffer[aOffset + i]) continue;
            return false;
        }
        return true;
    }

    public final boolean equals(char[] cb, int length) {
        if (length != this.length) {
            return false;
        }
        int offset = this.offset;
        char[] buffer = this.buffer;
        for (int i = length - 1; i >= 0; --i) {
            if (buffer[offset + i] == cb[i]) continue;
            return false;
        }
        return true;
    }

    public final boolean equalsIgnoreCase(String a) {
        int len = a.length();
        if (this.length != len) {
            return false;
        }
        int offset = this.offset;
        char[] buffer = this.buffer;
        for (int i = 0; i < len; ++i) {
            char ca = buffer[offset + i];
            char cb = a.charAt(i);
            if (ca == cb || Character.toLowerCase(ca) == Character.toLowerCase(cb)) continue;
            return false;
        }
        return true;
    }

    public final boolean equalsIgnoreCase(CharSegment b) {
        int length = this.length;
        if (length != b.length) {
            return false;
        }
        char[] buffer = this.buffer;
        char[] bBuffer = b.buffer;
        int offset = this.offset;
        int bOffset = b.offset;
        for (int i = length - 1; i >= 0; --i) {
            char ca = buffer[offset + i];
            char cb = bBuffer[bOffset + i];
            if (ca == cb || Character.toLowerCase(ca) == Character.toLowerCase(cb)) continue;
            return false;
        }
        return true;
    }

    public boolean matches(Object a) {
        if (a instanceof CharSegment) {
            CharSegment cb = (CharSegment)a;
            if (this.length != cb.length) {
                return false;
            }
            int offset = this.offset;
            int bOffset = cb.offset;
            for (int i = this.length - 1; i >= 0; --i) {
                if (this.buffer[offset + i] == cb.buffer[bOffset + i]) continue;
                return false;
            }
            return true;
        }
        if (a instanceof String) {
            String sa = (String)a;
            if (this.length != sa.length()) {
                return false;
            }
            int offset = this.offset;
            for (int i = this.length - 1; i >= 0; --i) {
                if (this.buffer[i + offset] == sa.charAt(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean matches(String sa) {
        if (this.length != sa.length()) {
            return false;
        }
        char[] buffer = this.buffer;
        int offset = this.offset;
        for (int i = this.length - 1; i >= 0; --i) {
            if (buffer[offset + i] == sa.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean matchesIgnoreCase(String sa) {
        if (this.length != sa.length()) {
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            char ca = this.buffer[this.offset + i];
            char cb = sa.charAt(i);
            if (ca == cb || Character.toLowerCase(ca) == Character.toLowerCase(cb)) continue;
            return false;
        }
        return true;
    }

    public boolean regionMatches(int off1, CharSegment buf, int off2, int len) {
        if (off1 + len > this.length || off2 + len > buf.length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (this.buffer[off1 + i] == buf.buffer[off2 + i]) continue;
            return false;
        }
        return true;
    }

    public boolean regionMatches(int off1, String buf, int off2, int len) {
        if (off1 + len > this.length || off2 + len > buf.length()) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (this.buffer[off1 + i] == buf.charAt(off2 + i)) continue;
            return false;
        }
        return true;
    }

    public boolean regionMatchesIgnoreCase(int off1, CharSegment buf, int off2, int len) {
        if (off1 + len > this.length || off2 + len > buf.length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (Character.toLowerCase(this.buffer[off1 + i]) == Character.toLowerCase(buf.buffer[off2 + i])) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(String string) {
        if (string == null) {
            return false;
        }
        int strlen = string.length();
        if (this.length < strlen) {
            return false;
        }
        char[] buffer = this.buffer;
        int offset = this.offset;
        while (--strlen >= 0) {
            if (buffer[offset + strlen] == string.charAt(strlen)) continue;
            return false;
        }
        return true;
    }

    public boolean endsWith(String string) {
        if (string == null) {
            return false;
        }
        int strlen = string.length();
        if (this.length < strlen) {
            return false;
        }
        char[] buffer = this.buffer;
        int offset = this.offset + this.length - strlen;
        while (--strlen >= 0) {
            if (buffer[offset + strlen] == string.charAt(strlen)) continue;
            return false;
        }
        return true;
    }

    public boolean endsWith(CharSegment cb) {
        if (cb == null) {
            return false;
        }
        int strlen = cb.length;
        if (this.length < strlen) {
            return false;
        }
        char[] buffer = this.buffer;
        int offset = this.offset + this.length - strlen;
        char[] cbBuffer = cb.buffer;
        int cbOffset = cb.offset;
        while (--strlen >= 0) {
            if (buffer[offset + strlen] == cbBuffer[cbOffset + strlen]) continue;
            return false;
        }
        return true;
    }

    public CharSegment toLowerCase() {
        char[] buffer = this.buffer;
        int len = this.length;
        int offset = this.offset;
        while (--len >= 0) {
            buffer[offset + len] = Character.toLowerCase(buffer[offset + len]);
        }
        return this;
    }

    public String toString() {
        return new String(this.buffer, this.offset, this.length);
    }
}

