/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

public class IntArray {
    private int[] data = new int[16];
    private int size = 0;

    public void clear() {
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public void add(int i) {
        if (this.size >= this.data.length) {
            this.expand(this.size + 1);
        }
        this.data[this.size++] = i;
    }

    public void add(IntArray array) {
        if (this.size >= this.data.length) {
            this.expand(this.size + array.size);
        }
        for (int i = 0; i < array.size; ++i) {
            this.data[this.size++] = array.data[i];
        }
    }

    public void add(int i, int value) {
        this.expand(this.size + 1);
        System.arraycopy(this.data, i, this.data, i + 1, this.size - i);
        this.data[i] = value;
        ++this.size;
    }

    public int pop() {
        return this.data[--this.size];
    }

    public void setLength(int size) {
        this.expand(size);
        for (int i = this.size; i < size; ++i) {
            this.data[i] = 0;
        }
        this.size = size;
    }

    private void expand(int max) {
        while (max > this.data.length) {
            int[] next = new int[this.data.length * 2];
            for (int i = 0; i < this.data.length; ++i) {
                next[i] = this.data[i];
            }
            this.data = next;
        }
    }

    public int get(int i) {
        return this.data[i];
    }

    public int last() {
        return this.data[this.size - 1];
    }

    public void set(int i, int value) {
        if (i >= this.size) {
            throw new IndexOutOfBoundsException(i + " >= " + this.size);
        }
        this.data[i] = value;
    }

    public boolean contains(int test) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != test) continue;
            return true;
        }
        return false;
    }

    public boolean isSubset(IntArray subset) {
        for (int i = 0; i < subset.size; ++i) {
            if (this.contains(subset.data[i])) continue;
            return false;
        }
        return true;
    }

    public void union(IntArray newArray) {
        for (int i = 0; i < newArray.size; ++i) {
            if (this.contains(newArray.data[i])) continue;
            this.add(newArray.data[i]);
        }
    }

    public int[] toArray() {
        int[] value = new int[this.size];
        System.arraycopy(this.data, 0, value, 0, this.size);
        return value;
    }
}

