/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.CharBuffer;
import com.caucho.vfs.Encoding;
import com.caucho.vfs.Path;
import com.caucho.vfs.StreamFilter;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Iterator;

public final class ReadStream
extends InputStream {
    private TempBuffer tempRead;
    private byte[] read_buffer;
    private int read_offset;
    private int read_length;
    private WriteStream sibling;
    private StreamImpl source;
    private Reader readEncoding;
    private String readEncodingName;
    private int specialEncoding;
    private boolean disableClose;
    private boolean reuseBuffer;
    private Reader reader;

    public ReadStream() {
    }

    public ReadStream(StreamImpl source) {
        this.init(source, null);
    }

    public ReadStream(StreamImpl source, WriteStream sibling) {
        this.init(source, sibling);
    }

    public void init(StreamImpl source, WriteStream sibling) {
        this.disableClose = false;
        if (this.source != null && this.source != source) {
            try {
                this.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (source == null) {
            throw new IllegalArgumentException();
        }
        this.source = source;
        this.sibling = sibling;
        if (source.canRead() && this.tempRead == null) {
            this.tempRead = TempBuffer.allocate();
            this.read_buffer = this.tempRead.buf;
        }
        this.read_offset = 0;
        this.read_length = 0;
        this.readEncoding = null;
        this.readEncodingName = "ISO-8859-1";
    }

    public void setSibling(WriteStream sibling) {
        this.sibling = sibling;
    }

    public WriteStream getSibling() {
        return this.sibling;
    }

    public StreamImpl getSource() {
        return this.source;
    }

    public void setReuseBuffer(boolean reuse) {
        this.reuseBuffer = reuse;
    }

    public void pushFilter(StreamFilter filter) {
        filter.init(this.source);
        this.source = filter;
    }

    public byte[] getBuffer() {
        return this.read_buffer;
    }

    public int getOffset() {
        return this.read_offset;
    }

    public int getLength() {
        return this.read_length;
    }

    public void setOffset(int offset) {
        this.read_offset = offset;
    }

    public boolean canRead() {
        return this.source.canRead();
    }

    public void clearRead() {
        this.read_offset = 0;
        this.read_length = 0;
    }

    public int getAvailable() throws IOException {
        if (this.read_length > this.read_offset) {
            return this.read_length - this.read_offset;
        }
        if (this.sibling != null) {
            this.sibling.flush();
        }
        return this.source.getAvailable();
    }

    public int available() throws IOException {
        return this.getAvailable();
    }

    public long getPosition() {
        long pos = this.source.getReadPosition();
        if (pos < 0L) {
            return -1L;
        }
        return pos - (long)(this.read_length - this.read_offset);
    }

    public void setPosition(int pos) {
    }

    public final int read() throws IOException {
        if (this.read_offset >= this.read_length && !this.readBuffer()) {
            return -1;
        }
        return this.read_buffer[this.read_offset++] & 0xFF;
    }

    public final void unread() {
        if (this.read_offset <= 0) {
            throw new RuntimeException();
        }
        --this.read_offset;
    }

    public long skip(long n) throws IOException {
        if (n < (long)(this.read_length - this.read_offset)) {
            this.read_offset = (int)((long)this.read_offset + n);
            return n;
        }
        long count = this.read_length - this.read_offset;
        this.read_length = 0;
        this.read_offset = 0;
        if (this.source.hasSkip()) {
            long skipped = this.source.skip(n - count);
            if (skipped < 0L) {
                return count;
            }
            return skipped + count;
        }
        while ((long)this.read_offset + n - count > (long)this.read_length) {
            count += (long)(this.read_length - this.read_offset);
            this.read_offset = 0;
            this.read_length = 0;
            if (this.readBuffer()) continue;
            return count;
        }
        this.read_offset += (int)(n - count);
        return n;
    }

    public final int read(byte[] buf, int offset, int length) throws IOException {
        if (this.read_offset >= this.read_length && !this.readBuffer()) {
            return -1;
        }
        int sublen = this.read_length - this.read_offset;
        if (length < sublen) {
            sublen = length;
        }
        System.arraycopy(this.read_buffer, this.read_offset, buf, offset, sublen);
        this.read_offset += sublen;
        return sublen;
    }

    public int readAll(byte[] buf, int offset, int length) throws IOException {
        int read_length = 0;
        while (length > 0) {
            int sublen = this.read(buf, offset, length);
            if (sublen < 0) {
                return read_length == 0 ? -1 : read_length;
            }
            offset += sublen;
            read_length += sublen;
            length -= sublen;
        }
        return read_length;
    }

    public void setEncoding(String encoding) throws UnsupportedEncodingException {
        String mimeName = Encoding.getMimeName(encoding);
        if (mimeName != null && mimeName.equals(this.readEncodingName)) {
            return;
        }
        this.readEncoding = Encoding.getReadEncoding(this, encoding);
        this.readEncodingName = mimeName;
    }

    public String getEncoding() {
        return this.readEncodingName;
    }

    public final int readChar() throws IOException {
        if (this.readEncoding != null) {
            return this.readEncoding.read();
        }
        if (this.read_offset >= this.read_length && !this.readBuffer()) {
            return -1;
        }
        return this.read_buffer[this.read_offset++] & 0xFF;
    }

    public final int read(char[] buf, int offset, int length) throws IOException {
        if (this.readEncoding != null) {
            return this.readEncoding.read(buf, offset, length);
        }
        byte[] readBuffer = this.read_buffer;
        if (readBuffer == null) {
            return -1;
        }
        int readLength = this.read_length;
        int readOffset = this.read_offset;
        int sublen = readLength - readOffset;
        if (sublen <= 0) {
            if (!this.readBuffer()) {
                return -1;
            }
            readLength = this.read_length;
            readOffset = this.read_offset;
            sublen = readLength - readOffset;
        }
        if (length < sublen) {
            sublen = length;
        }
        for (int i = 0; i < sublen; ++i) {
            buf[offset + i] = (char)(readBuffer[readOffset + i] & 0xFF);
        }
        this.read_offset += sublen;
        return sublen;
    }

    public int readAll(char[] buf, int offset, int length) throws IOException {
        int readLength = 0;
        while (length > 0) {
            int sublen = this.read(buf, offset, length);
            if (sublen <= 0) {
                return this.read_length;
            }
            offset += sublen;
            readLength += sublen;
            length -= sublen;
        }
        return readLength;
    }

    public int read(CharBuffer buf, int length) throws IOException {
        int len = buf.getLength();
        buf.setLength(len + length);
        int readLength = this.read(buf.getBuffer(), len, length);
        if (readLength < 0) {
            buf.setLength(len);
        } else if (readLength < length) {
            buf.setLength(len + readLength);
        }
        return length;
    }

    public int readAll(CharBuffer buf, int length) throws IOException {
        int len = buf.getLength();
        buf.setLength(len + length);
        int readLength = this.readAll(buf.getBuffer(), len, length);
        if (readLength < 0) {
            buf.setLength(len);
        } else if (readLength < length) {
            buf.setLength(len + readLength);
        }
        return length;
    }

    public final boolean readln(CharBuffer cb) throws IOException {
        return this.readLine(cb);
    }

    public final boolean readLine(CharBuffer cb) throws IOException {
        if (this.readEncoding != null) {
            return this.readlnEncoded(cb);
        }
        int capacity = cb.getCapacity();
        int offset = cb.getLength();
        char[] buf = cb.getBuffer();
        byte[] read_buffer = this.read_buffer;
        while (true) {
            int sublen;
            if ((sublen = this.read_length - this.read_offset) > capacity - offset) {
                sublen = capacity - offset;
            }
            int read_offset = this.read_offset;
            while (sublen > 0) {
                int ch;
                if ((ch = read_buffer[read_offset++] & 0xFF) == 10) {
                    if (offset > 0 && buf[offset - 1] == '\r') {
                        cb.setLength(offset - 1);
                    } else {
                        cb.setLength(offset);
                    }
                    this.read_offset = read_offset;
                    return true;
                }
                buf[offset++] = (char)ch;
                --sublen;
            }
            this.read_offset = read_offset;
            if (read_offset >= this.read_length && !this.readBuffer()) {
                cb.setLength(offset);
                return offset > 0;
            }
            if (offset < capacity) continue;
            cb.setLength(offset + 1);
            capacity = cb.getCapacity();
            buf = cb.getBuffer();
        }
    }

    public final int readLine(char[] buf, int length) throws IOException {
        byte[] read_buffer = this.read_buffer;
        int offset = 0;
        do {
            int sublen;
            if ((sublen = this.read_length - this.read_offset) < length) {
                sublen = length;
            }
            int read_offset = this.read_offset;
            while (sublen > 0) {
                int ch;
                if ((ch = read_buffer[read_offset++] & 0xFF) == 10) {
                    this.read_offset = read_offset;
                    if (offset > 0 && buf[offset - 1] == '\r') {
                        return offset - 1;
                    }
                    return offset;
                }
                buf[offset++] = (char)ch;
                --sublen;
            }
            this.read_offset = read_offset;
            if (read_offset < this.read_length || this.readBuffer()) continue;
            return offset;
        } while (offset < length);
        return length + 1;
    }

    private boolean readlnEncoded(CharBuffer cb) throws IOException {
        int ch;
        while ((ch = this.readChar()) >= 0) {
            if (ch == 10) {
                if (cb.length() > 0 && cb.getLastChar() == '\r') {
                    cb.setLength(cb.getLength() - 1);
                }
                return true;
            }
            cb.append((char)ch);
        }
        return cb.length() > 0;
    }

    public final String readln() throws IOException {
        return this.readLine();
    }

    public String readLine() throws IOException {
        CharBuffer cb = new CharBuffer();
        if (this.readln(cb)) {
            return cb.toString();
        }
        if (cb.length() == 0) {
            return null;
        }
        return cb.toString();
    }

    public void writeToStream(OutputStream os) throws IOException {
        if (this.read_offset >= this.read_length) {
            this.readBuffer();
        }
        while (this.read_offset < this.read_length) {
            os.write(this.read_buffer, this.read_offset, this.read_length - this.read_offset);
            this.readBuffer();
        }
    }

    public void writeToStream(OutputStream os, int len) throws IOException {
        while (len > 0) {
            if (this.read_offset >= this.read_length && !this.readBuffer()) {
                return;
            }
            int sublen = this.read_length - this.read_offset;
            if (len < sublen) {
                sublen = len;
            }
            os.write(this.read_buffer, this.read_offset, sublen);
            this.read_offset += sublen;
            len -= sublen;
        }
    }

    public void writeToWriter(Writer out) throws IOException {
        int ch;
        while ((ch = this.readChar()) >= 0) {
            out.write((char)ch);
        }
    }

    public int fillBuffer() throws IOException {
        if (!this.readBuffer()) {
            return -1;
        }
        return this.read_length;
    }

    private boolean readBuffer() throws IOException {
        if (this.read_buffer == null) {
            this.read_offset = 0;
            this.read_length = 0;
            return false;
        }
        if (this.sibling != null) {
            this.sibling.flush();
        }
        this.read_offset = 0;
        this.read_length = this.source.read(this.read_buffer, 0, this.read_buffer.length);
        if (this.read_length > 0) {
            return true;
        }
        this.read_length = 0;
        return false;
    }

    private boolean readBuffer(int off) throws IOException {
        if (this.read_buffer == null) {
            return false;
        }
        if (this.sibling != null) {
            this.sibling.flush();
        }
        this.read_offset = 0;
        this.read_length = this.source.read(this.read_buffer, off, this.read_buffer.length - off);
        if (this.read_length > 0) {
            return true;
        }
        this.read_length = 0;
        return false;
    }

    public void setDisableClose(boolean disableClose) {
        this.disableClose = disableClose;
    }

    public final void close() throws IOException {
        if (this.disableClose) {
            return;
        }
        if (!this.reuseBuffer) {
            if (this.tempRead != null) {
                TempBuffer.free(this.tempRead);
            }
            this.tempRead = null;
            this.read_buffer = null;
        }
        if (this.readEncoding != null) {
            Reader reader = this.readEncoding;
            this.readEncoding = null;
            reader.close();
        }
        if (this.source != null) {
            StreamImpl s = this.source;
            this.source = null;
            s.close();
        }
    }

    public Object getAttribute(String name) throws IOException {
        if (this.sibling != null) {
            this.sibling.flush();
        }
        return this.source.getAttribute(name);
    }

    public Iterator getAttributeNames() throws IOException {
        if (this.sibling != null) {
            this.sibling.flush();
        }
        return this.source.getAttributeNames();
    }

    public void setAttribute(String name, Object value) throws IOException {
        this.source.setAttribute(name, value);
    }

    public void removeAttribute(String name) throws IOException {
        this.source.removeAttribute(name);
    }

    public Path getPath() {
        return this.source == null ? null : this.source.getPath();
    }

    public String getUserPath() {
        if (this.source == null || this.source.getPath() == null) {
            return "stream";
        }
        return this.source.getPath().getUserPath();
    }

    public void setPath(Path path) {
        this.source.setPath(path);
    }

    public Reader getReader() {
        if (this.reader == null) {
            this.reader = new StreamReader();
        }
        return this.reader;
    }

    public String toString() {
        return "[ReadStream " + this.source + "]";
    }

    class StreamReader
    extends Reader {
        StreamReader() {
        }

        public final int read() throws IOException {
            return ReadStream.this.readChar();
        }

        public final int read(char[] cbuf, int off, int len) throws IOException {
            return ReadStream.this.read(cbuf, off, len);
        }

        public boolean ready() throws IOException {
            return ReadStream.this.available() > 0;
        }

        public final void close() throws IOException {
        }

        ReadStream getStream() {
            return ReadStream.this;
        }
    }
}

