/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs.i18n;

import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.WriteStream;
import com.caucho.vfs.i18n.EncodingWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class UTF8Writer
extends EncodingWriter {
    private OutputStream os;

    public UTF8Writer() {
    }

    private UTF8Writer(OutputStream os) {
        this.os = os;
    }

    public Writer create(OutputStream os, String javaEncoding) {
        return new UTF8Writer(os);
    }

    public void write(char ch) throws IOException {
        if (ch < '\u0080') {
            this.os.write(ch);
        } else if (ch < '\u0800') {
            this.os.write(192 + (ch >> 6));
            this.os.write(128 + (ch & 0x3F));
        } else {
            this.os.write(224 + (ch >> 12));
            this.os.write(128 + (ch >> 6 & 0x3F));
            this.os.write(128 + (ch & 0x3F));
        }
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (len < 4 || !(this.os instanceof WriteStream)) {
            for (int i = 0; i < len; ++i) {
                this.write(cbuf[off + i]);
            }
        } else {
            WriteStream ws = (WriteStream)this.os;
            byte[] buffer = ws.getBuffer();
            int length = ws.getBufferOffset();
            int capacity = buffer.length;
            for (int i = 0; i < len; ++i) {
                char ch;
                if (length + 2 >= capacity) {
                    StreamImpl source = ws.getSource();
                    source.write(buffer, 0, length, false);
                    length = 0;
                }
                if ((ch = cbuf[off + i]) < '\u0080') {
                    buffer[length++] = (byte)ch;
                    continue;
                }
                if (ch < '\u0800') {
                    buffer[length++] = (byte)(192 + (ch >> 6));
                    buffer[length++] = (byte)(128 + (ch & 0x3F));
                    continue;
                }
                buffer[length++] = (byte)(224 + (ch >> 12));
                buffer[length++] = (byte)(128 + (ch >> 6 & 0x3F));
                buffer[length++] = (byte)(128 + (ch & 0x3F));
            }
            ws.setBufferOffset(length);
        }
    }
}

