/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.jsp.jstl.core;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.jstl.core.LoopTag;
import javax.servlet.jsp.jstl.core.LoopTagStatus;
import javax.servlet.jsp.tagext.IterationTag;
import javax.servlet.jsp.tagext.TagSupport;
import javax.servlet.jsp.tagext.TryCatchFinally;

public abstract class LoopTagSupport
extends TagSupport
implements LoopTag,
IterationTag,
TryCatchFinally {
    protected int begin;
    protected boolean beginSpecified;
    protected int end = -1;
    protected boolean endSpecified;
    protected int step = 1;
    protected boolean stepSpecified;
    protected String itemId;
    protected String statusId;
    private Object _current;
    private LoopTagStatus _status;
    private int _index;
    private int _count;

    public void setVar(String id) {
        this.itemId = id;
    }

    public void setVarStatus(String id) {
        this.statusId = id;
    }

    protected void validateBegin() throws JspTagException {
        if (this.begin < 0) {
            throw new JspTagException("Invalid loop tag, 'begin' < 0.");
        }
    }

    protected void validateEnd() throws JspTagException {
        if (this.end < 0) {
            throw new JspTagException("Invalid loop tag, 'end' < 0.");
        }
    }

    protected void validateStep() throws JspTagException {
        if (this.step <= 0) {
            throw new JspTagException("Invalid loop tag, 'step' <= 0.");
        }
    }

    protected abstract void prepare() throws JspTagException;

    protected abstract Object next() throws JspTagException;

    protected abstract boolean hasNext() throws JspTagException;

    public Object getCurrent() {
        return this._current;
    }

    public LoopTagStatus getLoopStatus() {
        return this._status;
    }

    public int doStartTag() throws JspException {
        this._index = 0;
        this._count = 0;
        this.prepare();
        if (this._status == null) {
            this._status = new Status();
        }
        while (this._index < this.begin && this.hasNext()) {
            ++this._index;
            this.next();
        }
        if (this.hasNext() && (!this.endSpecified || this._index <= this.end)) {
            ++this._count;
            this._current = this.next();
            if (this.itemId != null) {
                this.pageContext.setAttribute(this.itemId, this._current);
            }
            if (this.statusId != null) {
                this.pageContext.setAttribute(this.statusId, (Object)this._status);
            }
            return 1;
        }
        return 0;
    }

    public int doAfterBody() throws JspException {
        for (int stepCount = !this.stepSpecified ? 1 : this.step; stepCount > 0; --stepCount) {
            if (!this.hasNext()) {
                return 0;
            }
            ++this._index;
            this._current = this.next();
        }
        ++this._count;
        if (!this.endSpecified || this._index <= this.end) {
            if (this.itemId != null) {
                this.pageContext.setAttribute(this.itemId, this._current);
            }
            if (this.statusId != null) {
                this.pageContext.setAttribute(this.statusId, (Object)this._status);
            }
            return 2;
        }
        return 0;
    }

    public void doCatch(Throwable t) throws Throwable {
        throw t;
    }

    public void doFinally() {
        if (this.itemId != null) {
            this.pageContext.removeAttribute(this.itemId);
        }
        if (this.statusId != null) {
            this.pageContext.removeAttribute(this.statusId);
        }
    }

    public class Status
    implements LoopTagStatus {
        public Object getCurrent() {
            return LoopTagSupport.this._current;
        }

        public int getIndex() {
            return LoopTagSupport.this._index;
        }

        public int getCount() {
            return LoopTagSupport.this._count;
        }

        public boolean isFirst() {
            return LoopTagSupport.this._count == 1;
        }

        public boolean isLast() {
            try {
                if (!LoopTagSupport.this.hasNext()) {
                    return true;
                }
                return LoopTagSupport.this.endSpecified && LoopTagSupport.this.step + LoopTagSupport.this._index > LoopTagSupport.this.end;
            }
            catch (Exception e) {
                return false;
            }
        }

        public Integer getBegin() {
            if (LoopTagSupport.this.beginSpecified) {
                return new Integer(LoopTagSupport.this.begin);
            }
            return null;
        }

        public Integer getEnd() {
            if (LoopTagSupport.this.endSpecified) {
                return new Integer(LoopTagSupport.this.end);
            }
            return null;
        }

        public Integer getStep() {
            if (LoopTagSupport.this.stepSpecified) {
                return new Integer(LoopTagSupport.this.step);
            }
            return null;
        }
    }
}

