/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.spring;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.broker.BrokerContainer;
import org.codehaus.activemq.broker.BrokerContainerFactory;
import org.codehaus.activemq.broker.BrokerContext;
import org.codehaus.activemq.spring.ActiveMQBeanFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceEditor;

public class SpringBrokerContainerFactory
implements BrokerContainerFactory {
    private static final Log log = LogFactory.getLog((Class)SpringBrokerContainerFactory.class);
    private Resource resource;

    public static BrokerContainer newInstance(Resource resource, String brokerName) {
        SpringBrokerContainerFactory factory = new SpringBrokerContainerFactory(resource);
        return factory.createBrokerContainer(brokerName, BrokerContext.getInstance());
    }

    public static SpringBrokerContainerFactory newFactory(String resourceName) {
        ResourceEditor editor = new ResourceEditor();
        editor.setAsText(resourceName);
        Resource resource = (Resource)editor.getValue();
        if (resource == null) {
            throw new IllegalArgumentException("Could not convert '" + resourceName + "' into a Spring Resource");
        }
        return new SpringBrokerContainerFactory(resource);
    }

    public SpringBrokerContainerFactory() {
    }

    public SpringBrokerContainerFactory(Resource resource) {
        this.resource = resource;
    }

    public BrokerContainer createBrokerContainer(String brokerName, BrokerContext context) {
        log.info((Object)("Loading ActiveMQ broker from configuration: " + this.resource));
        ActiveMQBeanFactory beanFactory = new ActiveMQBeanFactory(brokerName, this.resource);
        return (BrokerContainer)beanFactory.getBean("broker");
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }
}

