/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.store.bdb;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import java.io.IOException;
import java.util.ArrayList;
import javax.jms.JMSException;
import javax.transaction.xa.XAException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.message.ActiveMQXid;
import org.codehaus.activemq.service.Transaction;
import org.codehaus.activemq.service.TransactionManager;
import org.codehaus.activemq.service.impl.XATransactionCommand;
import org.codehaus.activemq.store.PreparedTransactionStore;
import org.codehaus.activemq.store.bdb.BDbHelper;
import org.codehaus.activemq.store.bdb.BDbMessageStore;
import org.codehaus.activemq.store.bdb.BDbPersistenceAdapter;

public class BDbPreparedTransactionStore
implements PreparedTransactionStore {
    private static final Log log = LogFactory.getLog((Class)BDbMessageStore.class);
    private Database database;
    private CursorConfig cursorConfig;

    public BDbPreparedTransactionStore(Database database) {
        this.database = database;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ActiveMQXid[] getXids() throws XAException {
        ActiveMQXid[] activeMQXidArray;
        this.checkClosed();
        Cursor cursor = null;
        try {
            try {
                cursor = this.database.openCursor(BDbHelper.getTransaction(), this.cursorConfig);
                ArrayList<ActiveMQXid> list = new ArrayList<ActiveMQXid>();
                DatabaseEntry keyEntry = new DatabaseEntry();
                DatabaseEntry valueEntry = new DatabaseEntry();
                OperationStatus status = cursor.getFirst(keyEntry, valueEntry, LockMode.DEFAULT);
                while (status == OperationStatus.SUCCESS) {
                    list.add(this.extractXid(keyEntry));
                }
                if (status != OperationStatus.NOTFOUND) {
                    log.warn((Object)("Unexpected status code while recovering: " + status));
                }
                ActiveMQXid[] answer = new ActiveMQXid[list.size()];
                list.toArray(answer);
                activeMQXidArray = answer;
                Object var9_10 = null;
                if (cursor == null) return activeMQXidArray;
            }
            catch (DatabaseException e) {
                log.error((Object)("Failed to recover prepared transaction log: " + (Object)((Object)e)), (Throwable)e);
                throw new XAException("Failed to recover prepared transaction log. Reason: " + (Object)((Object)e));
            }
            catch (IOException e) {
                log.error((Object)("Failed to recover prepared transaction log: " + e), (Throwable)e);
                throw new XAException("Failed to recover prepared transaction log. Reason: " + e);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (cursor == null) throw throwable;
            try {
                cursor.close();
                throw throwable;
            }
            catch (DatabaseException e) {
                log.warn((Object)("Caught exception closing cursor: " + (Object)((Object)e)), (Throwable)e);
                throw throwable;
            }
        }
        try {}
        catch (DatabaseException e) {
            log.warn((Object)("Caught exception closing cursor: " + (Object)((Object)e)), (Throwable)e);
            return activeMQXidArray;
        }
        cursor.close();
        return activeMQXidArray;
    }

    public void remove(ActiveMQXid xid) throws XAException {
        this.checkClosed();
        try {
            DatabaseEntry key = new DatabaseEntry(this.asBytes(xid));
            OperationStatus status = this.database.delete(BDbHelper.getTransaction(), key);
            if (status != OperationStatus.SUCCESS) {
                log.error((Object)("Could not delete sequenece number for: " + xid + " status: " + status));
            }
        }
        catch (DatabaseException e) {
            throw new XAException("Failed to remove prepared transaction: " + xid + ". Reason: " + (Object)((Object)e));
        }
        catch (IOException e) {
            throw new XAException("Failed to remove prepared transaction: " + xid + ". Reason: " + e);
        }
    }

    public void put(ActiveMQXid xid, Transaction transaction) throws XAException {
        this.checkClosed();
        try {
            DatabaseEntry key = new DatabaseEntry(this.asBytes(xid));
            DatabaseEntry value = new DatabaseEntry(this.asBytes(transaction));
            this.database.put(BDbHelper.getTransaction(), key, value);
        }
        catch (Exception e) {
            throw new XAException("Failed to store prepared transaction: " + xid + ". Reason: " + e);
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadPreparedTransactions(TransactionManager transactionManager) throws XAException {
        Cursor cursor;
        block8: {
            this.checkClosed();
            cursor = null;
            cursor = this.database.openCursor(BDbHelper.getTransaction(), this.cursorConfig);
            DatabaseEntry keyEntry = new DatabaseEntry();
            DatabaseEntry valueEntry = new DatabaseEntry();
            OperationStatus status = cursor.getFirst(keyEntry, valueEntry, LockMode.DEFAULT);
            while (status == OperationStatus.SUCCESS) {
                ActiveMQXid xid = this.extractXid(keyEntry);
                Transaction transaction = this.extractTransaction(valueEntry);
                transactionManager.loadTransaction(xid, transaction);
                status = cursor.getNext(keyEntry, valueEntry, LockMode.DEFAULT);
            }
            if (status == OperationStatus.NOTFOUND) break block8;
            log.warn((Object)("Unexpected status code while recovering: " + status));
        }
        Object var9_9 = null;
        if (cursor == null) return;
        try {
            cursor.close();
            return;
        }
        catch (DatabaseException e) {
            log.warn((Object)("Caught exception closing cursor: " + (Object)((Object)e)), (Throwable)e);
        }
        return;
        {
            catch (Exception e) {
                log.error((Object)("Failed to recover prepared transaction log: " + e), (Throwable)e);
                throw new XAException("Failed to recover prepared transaction log. Reason: " + e);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (cursor == null) throw throwable;
            try {
                cursor.close();
                throw throwable;
            }
            catch (DatabaseException e) {
                log.warn((Object)("Caught exception closing cursor: " + (Object)((Object)e)), (Throwable)e);
            }
            throw throwable;
        }
    }

    public void start() throws JMSException {
    }

    public synchronized void stop() throws JMSException {
        if (this.database != null) {
            JMSException exception = BDbPersistenceAdapter.closeDatabase(this.database, null);
            this.database = null;
            if (exception != null) {
                throw exception;
            }
        }
    }

    protected ActiveMQXid extractXid(DatabaseEntry entry) throws IOException {
        return ActiveMQXid.fromBytes(entry.getData());
    }

    protected Transaction extractTransaction(DatabaseEntry entry) throws IOException, ClassNotFoundException {
        return XATransactionCommand.fromBytes(entry.getData());
    }

    private byte[] asBytes(ActiveMQXid xid) throws IOException {
        return xid.toBytes();
    }

    private byte[] asBytes(Transaction transaction) throws IOException, JMSException {
        if (transaction instanceof XATransactionCommand) {
            XATransactionCommand packetTask = (XATransactionCommand)transaction;
            return packetTask.toBytes();
        }
        throw new IOException("Unsupported transaction type: " + transaction);
    }

    protected void checkClosed() throws XAException {
        if (this.database == null) {
            throw new XAException("Prepared Transaction Store is already closed");
        }
    }
}

