/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.store.journal;

import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.ClockDaemon;
import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import EDU.oswego.cs.dl.util.concurrent.QueuedExecutor;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.io.WireFormat;
import org.codehaus.activemq.io.impl.DefaultWireFormat;
import org.codehaus.activemq.journal.InvalidRecordLocationException;
import org.codehaus.activemq.journal.Journal;
import org.codehaus.activemq.journal.JournalEventListener;
import org.codehaus.activemq.journal.RecordLocation;
import org.codehaus.activemq.journal.howl.HowlJournal;
import org.codehaus.activemq.journal.impl.JournalImpl;
import org.codehaus.activemq.message.ActiveMQMessage;
import org.codehaus.activemq.message.MessageAck;
import org.codehaus.activemq.message.Packet;
import org.codehaus.activemq.service.impl.PersistenceAdapterSupport;
import org.codehaus.activemq.store.MessageStore;
import org.codehaus.activemq.store.PersistenceAdapter;
import org.codehaus.activemq.store.PreparedTransactionStore;
import org.codehaus.activemq.store.TopicMessageStore;
import org.codehaus.activemq.store.journal.JournalMessageStore;
import org.codehaus.activemq.util.JMSExceptionHelper;
import org.codehaus.activemq.util.TransactionTemplate;
import org.objectweb.howl.log.Configuration;

public class JournalPersistenceAdapter
extends PersistenceAdapterSupport
implements JournalEventListener {
    private static final Log log = LogFactory.getLog((Class)JournalPersistenceAdapter.class);
    public static final String DEFAULT_JOURNAL_TYPE = "default";
    public static final String HOWL_JOURNAL_TYPE = "howl";
    private Journal journal;
    private String journalType = "default";
    private PersistenceAdapter longTermPersistence;
    private File directory = new File("logs");
    private WireFormat wireFormat = new DefaultWireFormat();
    private TransactionTemplate transactionTemplate;
    private boolean sync = true;
    private final ConcurrentHashMap messageStores = new ConcurrentHashMap();
    private boolean performingRecovery;
    private static final int PACKET_RECORD_TYPE = 0;
    private static final int COMMAND_RECORD_TYPE = 1;
    private Channel checkpointRequests = new LinkedQueue();
    private QueuedExecutor checkpointExecutor = new QueuedExecutor((Channel)new LinkedQueue());
    ClockDaemon clockDaemon;
    private Object clockTicket;

    public JournalPersistenceAdapter() {
        this.checkpointExecutor.setThreadFactory(new ThreadFactory(){

            public Thread newThread(Runnable runnable) {
                Thread answer = new Thread(runnable, "Checkpoint Worker");
                answer.setDaemon(true);
                answer.setPriority(10);
                return answer;
            }
        });
    }

    public JournalPersistenceAdapter(File directory, PersistenceAdapter longTermPersistence, DefaultWireFormat wireFormat) throws IOException {
        this();
        this.directory = directory;
        this.longTermPersistence = longTermPersistence;
        this.wireFormat = wireFormat;
    }

    public Map getInitialDestinations() {
        return this.longTermPersistence.getInitialDestinations();
    }

    public MessageStore createQueueMessageStore(String destinationName) throws JMSException {
        MessageStore checkpointStore = this.longTermPersistence.createQueueMessageStore(destinationName);
        JournalMessageStore store = new JournalMessageStore(this, checkpointStore, destinationName, this.sync);
        this.messageStores.put((Object)destinationName, (Object)store);
        return store;
    }

    public TopicMessageStore createTopicMessageStore(String destinationName) throws JMSException {
        return this.longTermPersistence.createTopicMessageStore(destinationName);
    }

    public PreparedTransactionStore createPreparedTransactionStore() throws JMSException {
        return this.longTermPersistence.createPreparedTransactionStore();
    }

    public void beginTransaction() throws JMSException {
        this.longTermPersistence.beginTransaction();
    }

    public void commitTransaction() throws JMSException {
        this.longTermPersistence.commitTransaction();
    }

    public void rollbackTransaction() {
        this.longTermPersistence.rollbackTransaction();
    }

    public synchronized void start() throws JMSException {
        this.longTermPersistence.start();
        if (this.journal == null) {
            try {
                log.info((Object)"Opening journal.");
                this.journal = this.createJournal();
                log.info((Object)("Opened journal: " + this.journal));
                this.journal.setJournalEventListener(this);
            }
            catch (Exception e) {
                throw JMSExceptionHelper.newJMSException("Failed to open transaction journal: " + e, e);
            }
            try {
                this.recover();
            }
            catch (Exception e) {
                throw JMSExceptionHelper.newJMSException("Failed to recover transactions from journal: " + e, e);
            }
        }
        this.clockTicket = this.getClockDaemon().executePeriodically(60000L, new Runnable(){

            public void run() {
                JournalPersistenceAdapter.this.checkpoint();
            }
        }, false);
    }

    public synchronized void stop() throws JMSException {
        if (this.clockTicket != null) {
            ClockDaemon.cancel((Object)this.clockTicket);
        }
        this.checkpoint();
        this.checkpointExecutor.shutdownAfterProcessingCurrentlyQueuedTasks();
        JMSException firstException = null;
        if (this.journal != null) {
            try {
                this.journal.close();
                this.journal = null;
            }
            catch (Exception e) {
                firstException = JMSExceptionHelper.newJMSException("Failed to close Howl transaction log due to: " + e, e);
            }
        }
        this.longTermPersistence.stop();
        if (firstException != null) {
            throw firstException;
        }
    }

    public PersistenceAdapter getLongTermPersistence() {
        return this.longTermPersistence;
    }

    public void setLongTermPersistence(PersistenceAdapter longTermPersistence) {
        this.longTermPersistence = longTermPersistence;
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public boolean isSync() {
        return this.sync;
    }

    public void setSync(boolean sync) {
        this.sync = sync;
    }

    public WireFormat getWireFormat() {
        return this.wireFormat;
    }

    public void setWireFormat(WireFormat wireFormat) {
        this.wireFormat = wireFormat;
    }

    public String getJournalType() {
        return this.journalType;
    }

    public void setJournalType(String journalType) {
        this.journalType = journalType;
    }

    protected Journal createJournal() throws IOException {
        if (DEFAULT_JOURNAL_TYPE.equals(this.journalType)) {
            return new JournalImpl(this.directory);
        }
        if (HOWL_JOURNAL_TYPE.equals(this.journalType)) {
            try {
                Configuration config = new Configuration();
                config.setLogFileDir(this.directory.getCanonicalPath());
                return new HowlJournal(config);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw (IOException)new IOException("Could not open HOWL journal: " + e.getMessage()).initCause(e);
            }
        }
        throw new IllegalStateException("Unsupported valued for journalType attribute: " + this.journalType);
    }

    public void overflowNotification(RecordLocation safeLocation) {
        this.checkpoint();
    }

    public void checkpoint() {
        try {
            this.checkpointRequests.put((Object)Boolean.TRUE);
            this.checkpointExecutor.execute(new Runnable(){

                public void run() {
                    try {
                        boolean requested = false;
                        while (JournalPersistenceAdapter.this.checkpointRequests.poll(0L) != null) {
                            requested = true;
                        }
                        if (!requested) {
                            return;
                        }
                    }
                    catch (InterruptedException e1) {
                        return;
                    }
                    log.info((Object)"Checkpoint started.");
                    Iterator iterator = JournalPersistenceAdapter.this.messageStores.values().iterator();
                    RecordLocation newMark = null;
                    while (iterator.hasNext()) {
                        try {
                            JournalMessageStore ms = (JournalMessageStore)iterator.next();
                            RecordLocation mark = ms.checkpoint();
                            if (mark == null || newMark != null && newMark.compareTo(mark) >= 0) continue;
                            newMark = mark;
                        }
                        catch (Exception e) {
                            log.error((Object)("Failed to checkpoint a message store: " + e), (Throwable)e);
                        }
                    }
                    try {
                        if (newMark != null) {
                            JournalPersistenceAdapter.this.journal.setMark(newMark, true);
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)("Failed to mark the Journal: " + e), (Throwable)e);
                    }
                    log.info((Object)"Checkpoint done.");
                }
            });
        }
        catch (InterruptedException e) {
            log.warn((Object)("Request to start checkpoint failed: " + e), (Throwable)e);
        }
    }

    public RecordLocation writePacket(String destination, Packet packet, boolean sync) throws JMSException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream os = new DataOutputStream(baos);
            os.writeByte(0);
            os.writeUTF(destination);
            this.wireFormat.writePacket(packet, os);
            os.close();
            byte[] data = baos.toByteArray();
            return this.journal.write(data, sync);
        }
        catch (IOException e) {
            throw this.createWriteException(packet, (Exception)e);
        }
    }

    public RecordLocation writeCommand(String command, boolean sync) throws JMSException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream os = new DataOutputStream(baos);
            os.writeByte(1);
            os.writeUTF(command);
            os.close();
            byte[] data = baos.toByteArray();
            return this.journal.write(data, sync);
        }
        catch (IOException e) {
            throw this.createWriteException(command, (Exception)e);
        }
    }

    public Packet readPacket(RecordLocation location) throws JMSException {
        try {
            byte[] data = this.journal.read(location);
            DataInputStream is = new DataInputStream(new ByteArrayInputStream(data));
            byte type = is.readByte();
            if (type != 0) {
                throw new IOException("Record is not a packet type.");
            }
            String destination = is.readUTF();
            Packet packet = this.wireFormat.readPacket(is);
            is.close();
            return packet;
        }
        catch (InvalidRecordLocationException e) {
            throw this.createReadException(location, e);
        }
        catch (IOException e) {
            throw this.createReadException(location, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void recover() throws IllegalStateException, InvalidRecordLocationException, IOException, JMSException {
        pos = null;
        transactionCounter = 0;
        JournalPersistenceAdapter.log.info((Object)"Journal Recovery Started.");
lbl4:
        // 9 sources

        block11: while ((pos = this.journal.getNextRecordLocation(pos)) != null) {
            data = this.journal.read(pos);
            destination = null;
            packet = null;
            is = new DataInputStream(new ByteArrayInputStream(data));
            try {
                type = is.readByte();
                switch (type) {
                    case 0: {
                        destination = is.readUTF();
                        packet = this.wireFormat.readPacket(is);
                        store = (JournalMessageStore)this.createQueueMessageStore(destination);
                        if (packet instanceof ActiveMQMessage) {
                            msg = (ActiveMQMessage)packet;
                            try {
                                store.getLongTermStore().addMessage(msg);
                                ++transactionCounter;
                            }
                            catch (Throwable e) {
                                JournalPersistenceAdapter.log.error((Object)("Recovery Failure: Could not add message: " + msg.getJMSMessageIdentity().getMessageID() + ", reason: " + e), e);
                            }
                            continue block11;
                        }
                        if (packet instanceof MessageAck) {
                            ack = (MessageAck)packet;
                            try {
                                store.getLongTermStore().removeMessage(ack.getMessageIdentity(), ack);
                                ++transactionCounter;
                            }
                            catch (Throwable e) {
                                JournalPersistenceAdapter.log.error((Object)("Recovery Failure: Could not remove message: " + ack.getMessageIdentity().getMessageID() + ", reason: " + e), e);
                            }
                            continue block11;
                        }
                        JournalPersistenceAdapter.log.error((Object)("Unknown type of packet in transaction log which will be discarded: " + packet));
                        ** break;
                    }
                    case 1: {
                        ** break;
                    }
                    default: {
                        JournalPersistenceAdapter.log.error((Object)("Unknown type of record in transaction log which will be discarded: " + type));
                        continue block11;
                    }
                }
            }
            finally {
                is.close();
            }
        }
        location = this.writeCommand("RECOVERED", true);
        this.journal.setMark(location, true);
        JournalPersistenceAdapter.log.info((Object)("Journal Recovered: " + transactionCounter + " message(s) in transactions recovered."));
    }

    private JMSException createReadException(RecordLocation location, Exception e) {
        return JMSExceptionHelper.newJMSException("Failed to read to journal for: " + location + ". Reason: " + e, e);
    }

    protected JMSException createWriteException(Packet packet, Exception e) {
        return JMSExceptionHelper.newJMSException("Failed to write to journal for: " + packet + ". Reason: " + e, e);
    }

    protected JMSException createWriteException(String command, Exception e) {
        return JMSExceptionHelper.newJMSException("Failed to write to journal for command: " + command + ". Reason: " + e, e);
    }

    protected JMSException createRecoveryFailedException(Exception e) {
        return JMSExceptionHelper.newJMSException("Failed to recover from journal. Reason: " + e, e);
    }

    public ClockDaemon getClockDaemon() {
        if (this.clockDaemon == null) {
            this.clockDaemon = new ClockDaemon();
            this.clockDaemon.setThreadFactory(new ThreadFactory(){

                public Thread newThread(Runnable runnable) {
                    Thread thread = new Thread(runnable, "Checkpoint Timmer");
                    thread.setDaemon(true);
                    return thread;
                }
            });
        }
        return this.clockDaemon;
    }

    public void setClockDaemon(ClockDaemon clockDaemon) {
        this.clockDaemon = clockDaemon;
    }
}

