/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.transport.gnet;

import EDU.oswego.cs.dl.util.concurrent.Latch;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.network.SelectorManager;
import org.apache.geronimo.network.protocol.AbstractProtocol;
import org.apache.geronimo.network.protocol.DownPacket;
import org.apache.geronimo.network.protocol.PlainDownPacket;
import org.apache.geronimo.network.protocol.Protocol;
import org.apache.geronimo.network.protocol.ProtocolException;
import org.apache.geronimo.network.protocol.SocketProtocol;
import org.apache.geronimo.network.protocol.UpPacket;
import org.apache.geronimo.pool.ClockPool;
import org.apache.geronimo.pool.ThreadPool;
import org.codehaus.activemq.io.WireFormat;
import org.codehaus.activemq.message.Packet;
import org.codehaus.activemq.transport.TransportChannelSupport;

public class GTransportChannel
extends TransportChannelSupport {
    private static final Log log = LogFactory.getLog((Class)GTransportChannel.class);
    private SynchronizedBoolean closed;
    private SynchronizedBoolean started;
    private Protocol protocol;
    private Latch dispatchLatch;
    private ThreadPool threadPool;
    private WireFormat wireFormat;

    protected GTransportChannel(WireFormat wireFormat, ThreadPool tp) {
        this.wireFormat = wireFormat;
        this.closed = new SynchronizedBoolean(false);
        this.started = new SynchronizedBoolean(false);
        this.dispatchLatch = new Latch();
        this.threadPool = tp;
    }

    public GTransportChannel(WireFormat wireFormat, Protocol protocol, ThreadPool tp) {
        this(wireFormat, tp);
        this.init(protocol);
    }

    public GTransportChannel(WireFormat wireFormat, URI remoteLocation, URI localLocation, SelectorManager sm, ThreadPool tp, ClockPool cp) throws UnknownHostException, ProtocolException {
        this(wireFormat, tp);
        SocketProtocol sp = new SocketProtocol();
        sp.setTimeout(30000L);
        if (localLocation != null) {
            sp.setInterface((SocketAddress)new InetSocketAddress(InetAddress.getByName(localLocation.getHost()), localLocation.getPort()));
        }
        sp.setAddress((SocketAddress)new InetSocketAddress(InetAddress.getByName(remoteLocation.getHost()), remoteLocation.getPort()));
        sp.setSelectorManager(sm);
        this.init((Protocol)sp);
        sp.setup();
    }

    private void init(Protocol protocol) {
        this.protocol = protocol;
        protocol.setUpProtocol((Protocol)new AbstractProtocol(){

            public void setup() {
            }

            public void drain() {
            }

            public void teardown() {
            }

            public void sendUp(UpPacket p) {
                try {
                    log.trace((Object)("AQUIRING: " + GTransportChannel.this.dispatchLatch));
                    GTransportChannel.this.dispatchLatch.acquire();
                    log.trace((Object)("AQUIRED: " + GTransportChannel.this.dispatchLatch));
                    GTransportChannel.this.dispatch(p);
                }
                catch (InterruptedException e) {
                    log.warn((Object)("Caught exception dispatching packet: " + p + ". Reason: " + e), (Throwable)e);
                }
            }

            public void sendDown(DownPacket p) throws ProtocolException {
                this.getDownProtocol().sendDown(p);
            }

            public void flush() throws ProtocolException {
                this.getDownProtocol().flush();
            }
        });
    }

    private void dispatch(UpPacket p) {
        try {
            Packet packet = this.toPacket(p);
            log.trace((Object)("<<<< SENDING UP <<<< " + packet));
            if (packet != null) {
                this.doConsumePacket(packet);
            }
        }
        catch (IOException e) {
            log.warn((Object)("Caught exception dispatching packet: " + p + ". Reason: " + e), (Throwable)e);
        }
    }

    public void stop() {
        super.stop();
        if (this.closed.commit(false, true)) {
            try {
                this.protocol.drain();
            }
            catch (Exception e) {
                log.trace((Object)(this.toString() + " now closed"));
            }
        }
    }

    public void start() throws JMSException {
        if (this.started.commit(false, true)) {
            this.dispatchLatch.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncSend(Packet packet) throws JMSException {
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)(">>>> ASYNC SENDING DOWN >>>> " + packet));
            }
            Protocol protocol = this.protocol;
            synchronized (protocol) {
                this.protocol.sendDown((DownPacket)this.toPlainDownPacket(packet));
            }
        }
        catch (IOException e) {
            System.out.println("Caught: " + e);
            e.printStackTrace();
            JMSException jmsEx = new JMSException("asyncSend failed " + e.getMessage());
            jmsEx.setLinkedException((Exception)e);
            throw jmsEx;
        }
        catch (ProtocolException e) {
            System.out.println("Caught: " + (Object)((Object)e));
            e.printStackTrace();
            JMSException jmsEx = new JMSException("asyncSend failed " + e.getMessage());
            jmsEx.setLinkedException((Exception)((Object)e));
            throw jmsEx;
        }
    }

    public boolean isMulticast() {
        return false;
    }

    protected PlainDownPacket toPlainDownPacket(Packet mqpacket) throws IOException, JMSException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        this.wireFormat.writePacket(mqpacket, dos);
        dos.close();
        ArrayList<ByteBuffer> list = new ArrayList<ByteBuffer>(1);
        ByteBuffer buffer = ByteBuffer.wrap(baos.toByteArray());
        buffer.limit(buffer.capacity());
        list.add(buffer);
        PlainDownPacket packet = new PlainDownPacket();
        packet.setBuffers(list);
        return packet;
    }

    protected Packet toPacket(UpPacket packet) throws IOException {
        final ByteBuffer buffer = packet.getBuffer();
        InputStream is = new InputStream(){

            public int read() {
                if (!buffer.hasRemaining()) {
                    return -1;
                }
                int rc = 0xFF & buffer.get();
                return rc;
            }

            public synchronized int read(byte[] bytes, int off, int len) {
                len = Math.min(len, buffer.remaining());
                buffer.get(bytes, off, len);
                return len;
            }
        };
        DataInputStream dis = new DataInputStream(is);
        return this.wireFormat.readPacket(dis);
    }

    public String toString() {
        return "GTransportChannel: " + this.protocol;
    }

    public boolean canProcessWireFormatVersion(int version) {
        return this.wireFormat.canProcessWireFormatVersion(version);
    }

    public int getCurrentWireFormatVersion() {
        return this.wireFormat.getCurrentWireFormatVersion();
    }

    public void forceDisconnect() {
        throw new RuntimeException("Not yet Implemented.");
    }
}

