/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.interceptor;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

public class TransactionInterceptor
extends TransactionAspectSupport
implements MethodInterceptor {
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Class<?> targetClass = invocation.getThis() != null ? invocation.getThis().getClass() : null;
        TransactionAspectSupport.TransactionInfo txInfo = this.createTransactionIfNecessary(invocation.getMethod(), targetClass);
        Object retVal = null;
        try {
            retVal = invocation.proceed();
        }
        catch (Throwable ex) {
            this.doCloseTransactionAfterThrowing(txInfo, ex);
            throw ex;
        }
        finally {
            this.doFinally(txInfo);
        }
        this.doCommitTransactionAfterReturning(txInfo);
        return retVal;
    }
}

