/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.journal.impl;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ByteBufferPool {
    private static final Log log = LogFactory.getLog((Class)ByteBufferPool.class);
    private final ArrayList pool = new ArrayList();
    private final int bufferSize;
    private final int maxBuffers;

    public ByteBufferPool() {
        this(4, 0x400000);
    }

    public ByteBufferPool(int bufferCount, int bufferSize) {
        this.maxBuffers = bufferCount;
        this.bufferSize = bufferSize;
        for (int i = 0; i < bufferCount; ++i) {
            ByteBuffer bb = ByteBuffer.allocateDirect(bufferSize);
            this.pool.add(bb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer getByteBuffer() throws InterruptedException {
        ByteBuffer answer = null;
        ByteBufferPool byteBufferPool = this;
        synchronized (byteBufferPool) {
            while (answer == null) {
                if (this.pool.size() > 0) {
                    answer = (ByteBuffer)this.pool.remove(this.pool.size() - 1);
                }
                if (answer != null) continue;
                log.warn((Object)"Performance Warning: Buffer pool ran out of buffers.  Waiting for buffer to be returned.  System may be uner heavy load or you may need to configure more buffers in the pool.");
                this.wait();
            }
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnByteBuffer(ByteBuffer buffer) {
        buffer.clear();
        ByteBufferPool byteBufferPool = this;
        synchronized (byteBufferPool) {
            this.pool.add(buffer);
            this.notify();
        }
    }
}

