/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.journal.impl;

import java.nio.ByteBuffer;
import org.codehaus.activemq.journal.impl.Mark;
import org.codehaus.activemq.journal.impl.RecordFooter;
import org.codehaus.activemq.journal.impl.RecordHeader;

public class Record {
    public static final int RECORD_BASE_SIZE = 35;
    final RecordHeader header = new RecordHeader();
    final RecordFooter footer = new RecordFooter();
    final ByteBuffer headerBuffer;
    final ByteBuffer dataBuffer;
    final ByteBuffer footerBuffer;
    final Mark mark;

    public Record(RecordHeader header, byte[] data) {
        this(header.sequenceId, header.recordType, data, null);
    }

    public Record(long sequenceId, byte recordType, byte[] data, Mark visitData) {
        this.header.bulkSet(recordType, sequenceId, data);
        this.headerBuffer = this.header.toByteBuffer();
        this.dataBuffer = ByteBuffer.wrap(data);
        this.footer.bulkSet(this.header, data);
        this.footerBuffer = this.footer.toByteBuffer();
        this.mark = visitData;
    }

    public RecordHeader getHeader() {
        return this.header;
    }

    public Mark getMark() {
        return this.mark;
    }

    public int remaining() {
        return this.headerBuffer.remaining() + this.dataBuffer.remaining();
    }

    public void fill(ByteBuffer byteBuffer) {
        this.fill(byteBuffer, this.headerBuffer);
        this.fill(byteBuffer, this.dataBuffer);
        this.fill(byteBuffer, this.footerBuffer);
    }

    private void fill(ByteBuffer dest, ByteBuffer src) {
        int r = dest.remaining();
        if (r == 0) {
            return;
        }
        if (r < src.remaining()) {
            int limit = src.limit();
            src.limit(src.position() + r);
            dest.put(src);
            src.limit(limit);
        } else {
            dest.put(src);
        }
    }
}

