/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.service.boundedvm;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;
import org.codehaus.activemq.broker.BrokerClient;
import org.codehaus.activemq.filter.AndFilter;
import org.codehaus.activemq.filter.DestinationMap;
import org.codehaus.activemq.filter.Filter;
import org.codehaus.activemq.filter.FilterFactory;
import org.codehaus.activemq.filter.FilterFactoryImpl;
import org.codehaus.activemq.filter.NoLocalFilter;
import org.codehaus.activemq.message.ActiveMQDestination;
import org.codehaus.activemq.message.ActiveMQMessage;
import org.codehaus.activemq.message.ConsumerInfo;
import org.codehaus.activemq.message.MessageAck;
import org.codehaus.activemq.message.util.MemoryBoundedQueue;
import org.codehaus.activemq.message.util.MemoryBoundedQueueManager;
import org.codehaus.activemq.service.DeadLetterPolicy;
import org.codehaus.activemq.service.MessageContainer;
import org.codehaus.activemq.service.MessageContainerManager;
import org.codehaus.activemq.service.boundedvm.TransientTopicBoundedMessageContainer;

public class TransientTopicBoundedMessageManager
implements MessageContainerManager {
    private MemoryBoundedQueueManager queueManager;
    private ConcurrentHashMap containers;
    private DestinationMap destinationMap;
    private FilterFactory filterFactory;
    private SynchronizedBoolean started;
    private Map destinations;
    private DeadLetterPolicy deadLetterPolicy;

    public TransientTopicBoundedMessageManager(MemoryBoundedQueueManager mgr) {
        this.queueManager = mgr;
        this.containers = new ConcurrentHashMap();
        this.destinationMap = new DestinationMap();
        this.destinations = new ConcurrentHashMap();
        this.filterFactory = new FilterFactoryImpl();
        this.started = new SynchronizedBoolean(false);
    }

    public void start() throws JMSException {
        if (this.started.commit(false, true)) {
            Iterator i = this.containers.values().iterator();
            while (i.hasNext()) {
                TransientTopicBoundedMessageContainer container = (TransientTopicBoundedMessageContainer)i.next();
                container.start();
            }
        }
    }

    public void stop() throws JMSException {
        if (this.started.commit(true, false)) {
            Iterator i = this.containers.values().iterator();
            while (i.hasNext()) {
                TransientTopicBoundedMessageContainer container = (TransientTopicBoundedMessageContainer)i.next();
                container.stop();
            }
        }
    }

    public synchronized void addMessageConsumer(BrokerClient client, ConsumerInfo info) throws JMSException {
        ActiveMQDestination destination = info.getDestination();
        if (destination.isTopic()) {
            TransientTopicBoundedMessageContainer container = (TransientTopicBoundedMessageContainer)this.containers.get((Object)client);
            if (container == null) {
                MemoryBoundedQueue queue = this.queueManager.getMemoryBoundedQueue(client.toString());
                container = new TransientTopicBoundedMessageContainer(this, client, queue);
                this.containers.put((Object)client, (Object)container);
                if (this.started.get()) {
                    container.start();
                }
            }
            container.addConsumer(this.createFilter(info), info);
            this.destinationMap.put(destination, container);
            String name = destination.getPhysicalName();
            if (!info.isDurableTopic() && !this.destinations.containsKey(name)) {
                this.destinations.put(name, destination);
            }
        }
    }

    public synchronized void removeMessageConsumer(BrokerClient client, ConsumerInfo info) throws JMSException {
        TransientTopicBoundedMessageContainer container;
        ActiveMQDestination destination = info.getDestination();
        if (destination.isTopic() && (container = (TransientTopicBoundedMessageContainer)this.containers.get((Object)client)) != null) {
            container.removeConsumer(info);
            if (container.isInactive()) {
                this.containers.remove((Object)client);
                container.close();
                this.destinationMap.remove(destination, container);
            }
            if (!info.isDurableTopic() && !this.hasConsumerFor(destination)) {
                this.destinations.remove(destination.getPhysicalName());
            }
        }
    }

    public void deleteSubscription(String clientId, String subscriberName) throws JMSException {
    }

    public void sendMessage(BrokerClient client, ActiveMQMessage message) throws JMSException {
        if (message != null && message.getJMSActiveMQDestination().isTopic()) {
            Set set = this.destinationMap.get(message.getJMSActiveMQDestination());
            Iterator i = set.iterator();
            while (i.hasNext()) {
                TransientTopicBoundedMessageContainer container = (TransientTopicBoundedMessageContainer)i.next();
                container.targetAndDispatch(client, message);
            }
        }
    }

    public void acknowledgeMessage(BrokerClient client, MessageAck ack) throws JMSException {
    }

    public void acknowledgeTransactedMessage(BrokerClient client, String transactionId, MessageAck ack) throws JMSException {
    }

    public void redeliverMessage(BrokerClient client, MessageAck ack) throws JMSException {
    }

    public void poll() throws JMSException {
    }

    public void commitTransaction(BrokerClient client, String transactionId) throws JMSException {
    }

    public void rollbackTransaction(BrokerClient client, String transactionId) {
    }

    public MessageContainer getContainer(String physicalName) throws JMSException {
        return null;
    }

    public Map getDestinations() {
        return Collections.unmodifiableMap(this.destinations);
    }

    public DeadLetterPolicy getDeadLetterPolicy() {
        return this.deadLetterPolicy;
    }

    public void setDeadLetterPolicy(DeadLetterPolicy policy) {
        this.deadLetterPolicy = policy;
    }

    protected Filter createFilter(ConsumerInfo info) throws JMSException {
        Filter filter = this.filterFactory.createFilter(info.getDestination(), info.getSelector());
        if (info.isNoLocal()) {
            filter = new AndFilter(filter, new NoLocalFilter(info.getClientId()));
        }
        return filter;
    }

    protected boolean hasConsumerFor(ActiveMQDestination destination) {
        Iterator i = this.containers.values().iterator();
        while (i.hasNext()) {
            TransientTopicBoundedMessageContainer container = (TransientTopicBoundedMessageContainer)i.next();
            if (!container.hasConsumerFor(destination)) continue;
            return true;
        }
        return false;
    }

    public void createMessageContainer(ActiveMQDestination dest) throws JMSException {
    }

    public void destroyMessageContainer(ActiveMQDestination dest) throws JMSException {
    }

    public Map getMessageContainerAdmins() throws JMSException {
        return Collections.EMPTY_MAP;
    }
}

