/*
 * Decompiled with CFR 0.152.
 */
package javax.security.jacc;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.security.jacc.HTTPMethodSpec;
import javax.security.jacc.URLPatternSpec;
import javax.servlet.http.HttpServletRequest;

public final class WebResourcePermission
extends Permission
implements Serializable {
    private transient int cachedHashCode = 0;
    private transient URLPatternSpec urlPatternSpec;
    private transient HTTPMethodSpec httpMethodSpec;

    public WebResourcePermission(HttpServletRequest request) {
        super(request.getServletPath());
        this.urlPatternSpec = new URLPatternSpec(request.getServletPath());
        this.httpMethodSpec = new HTTPMethodSpec(request.getMethod());
    }

    public WebResourcePermission(String name, String actions) {
        super(name);
        this.urlPatternSpec = new URLPatternSpec(name);
        this.httpMethodSpec = new HTTPMethodSpec(actions);
    }

    public WebResourcePermission(String urlPattern, String[] HTTPMethods) {
        super(urlPattern);
        this.urlPatternSpec = new URLPatternSpec(urlPattern);
        this.httpMethodSpec = new HTTPMethodSpec(HTTPMethods);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof WebResourcePermission)) {
            return false;
        }
        WebResourcePermission other = (WebResourcePermission)o;
        return this.urlPatternSpec.equals(other.urlPatternSpec) && this.httpMethodSpec.equals(other.httpMethodSpec);
    }

    public String getActions() {
        return this.httpMethodSpec.getActions();
    }

    public int hashCode() {
        if (this.cachedHashCode == 0) {
            this.cachedHashCode = this.urlPatternSpec.hashCode() ^ this.httpMethodSpec.hashCode();
        }
        return this.cachedHashCode;
    }

    public boolean implies(Permission permission) {
        if (permission == null || !(permission instanceof WebResourcePermission)) {
            return false;
        }
        WebResourcePermission other = (WebResourcePermission)permission;
        return this.urlPatternSpec.implies(other.urlPatternSpec) && this.httpMethodSpec.implies(other.httpMethodSpec);
    }

    public PermissionCollection newPermissionCollection() {
        return new WebResourcePermissionCollection();
    }

    private synchronized void readObject(ObjectInputStream in) throws IOException {
        this.urlPatternSpec = new URLPatternSpec(in.readUTF());
        this.httpMethodSpec = new HTTPMethodSpec(in.readUTF());
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.urlPatternSpec.getPatternSpec());
        out.writeUTF(this.httpMethodSpec.getActions());
    }

    private static final class WebResourcePermissionCollection
    extends PermissionCollection {
        private Hashtable permissions = new Hashtable();

        private WebResourcePermissionCollection() {
        }

        public void add(Permission permission) {
            if (this.isReadOnly()) {
                throw new IllegalArgumentException("Read only collection");
            }
            if (!(permission instanceof WebResourcePermission)) {
                throw new IllegalArgumentException("Wrong permission type");
            }
            WebResourcePermission p = (WebResourcePermission)permission;
            this.permissions.put(p, p);
        }

        public boolean implies(Permission permission) {
            if (!(permission instanceof WebResourcePermission)) {
                return false;
            }
            WebResourcePermission p = (WebResourcePermission)permission;
            Enumeration e = this.permissions.elements();
            while (e.hasMoreElements()) {
                if (!((WebResourcePermission)e.nextElement()).implies(p)) continue;
                return true;
            }
            return false;
        }

        public Enumeration elements() {
            return this.permissions.elements();
        }
    }
}

