/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.messagework.jms.result;

import com.opensymphony.messagework.jms.JmsTemplateAware;
import com.opensymphony.messagework.jms.messagefactory.MessageFactory;
import com.opensymphony.util.TextUtils;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.Result;
import com.opensymphony.xwork.util.OgnlValueStack;
import java.util.Collection;
import java.util.Iterator;
import javax.jms.Destination;
import javax.jms.JMSException;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;

public abstract class AbstractMessageResult
implements Result,
JmsTemplateAware,
ApplicationContextAware {
    protected String property;
    protected String messageFactoryName;
    protected MessageFactory messageFactory;
    protected JmsTemplate jmsTemplate;
    protected ApplicationContext appContext;

    public void execute(ActionInvocation invocation) throws Exception {
        OgnlValueStack valueStack;
        Object value;
        this.initializeMessageFactory();
        Destination destination = this.getDestination();
        if (!TextUtils.stringSet((String)this.property)) {
            this.property = "top";
        }
        if ((value = (valueStack = ActionContext.getContext().getValueStack()).findValue(this.property)) instanceof Collection) {
            Collection collection = (Collection)value;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object obj = iterator.next();
                this.sendMessage(obj, destination);
            }
        } else {
            this.sendMessage(value, destination);
        }
    }

    protected void initializeMessageFactory() {
        this.messageFactory = (MessageFactory)this.appContext.getBean(this.messageFactoryName);
    }

    private void sendMessage(Object value, Destination destination) {
        this.messageFactory.setMessageValue(value);
        this.jmsTemplate.send(destination, (MessageCreator)this.messageFactory);
    }

    public void setMessageFactoryName(String messageFactoryName) {
        this.messageFactoryName = messageFactoryName;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setJmsTemplate(JmsTemplate jmsTemplate) {
        this.jmsTemplate = jmsTemplate;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.appContext = applicationContext;
    }

    protected abstract Destination getDestination() throws JMSException;
}

