/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.journal.impl;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.CRC32;
import org.codehaus.activemq.journal.impl.RecordHeader;

public class RecordFooter {
    public static final int SELECTED_CHECKSUM_ALGORITHIM;
    public static final int NO_CHECKSUM_ALGORITHIM = 0;
    public static final int HASH_CHECKSUM_ALGORITHIM = 1;
    public static final int CRC32_CHECKSUM_ALGORITHIM = 2;
    public static final int RECORD_FOOTER_SIZE = 19;
    public static final byte[] END_OF_RECORD;
    public long checksum;
    public long sequenceId;

    public ByteBuffer toByteBuffer() {
        ByteBuffer buff = ByteBuffer.allocate(19);
        buff.putLong(this.checksum).putLong(this.sequenceId).put(END_OF_RECORD).flip();
        return buff;
    }

    void writeRecordFooter(DataOutput out) throws IOException {
        out.writeLong(this.checksum);
        out.writeLong(this.sequenceId);
        out.write(END_OF_RECORD);
    }

    void readRecordFooter(DataInput in) throws IOException {
        this.checksum = in.readLong();
        this.sequenceId = in.readLong();
        for (int i = 0; i < END_OF_RECORD.length; ++i) {
            byte checkByte = END_OF_RECORD[i];
            if (in.readByte() == checkByte) continue;
            throw new IOException("Not a valid record header.");
        }
    }

    public void invalidate() {
        this.checksum = -1L;
        this.sequenceId = -1L;
    }

    public boolean matches(RecordHeader header) {
        return header.sequenceId == this.sequenceId;
    }

    public static boolean isChecksumingEnabled() {
        return SELECTED_CHECKSUM_ALGORITHIM != 0;
    }

    public boolean matches(byte[] data) {
        return RecordFooter.buildChecksum(data) == this.checksum;
    }

    public static long buildChecksum(byte[] data) {
        if (SELECTED_CHECKSUM_ALGORITHIM == 1) {
            byte[] rc = new byte[8];
            for (int i = 0; i < data.length; ++i) {
                int n = i % 8;
                rc[n] = (byte)(rc[n] ^ data[i]);
            }
            return rc[0] | rc[1] << 1 | rc[2] << 2 | rc[3] << 3 | rc[4] << 4 | rc[5] << 5 | rc[6] << 6 | rc[7] << 7;
        }
        if (SELECTED_CHECKSUM_ALGORITHIM == 2) {
            CRC32 crc32 = new CRC32();
            crc32.update(data);
            return crc32.getValue();
        }
        return 0L;
    }

    public void bulkSet(RecordHeader header, byte[] data) {
        this.sequenceId = header.sequenceId;
        this.checksum = RecordFooter.buildChecksum(data);
    }

    static {
        String type = System.getProperty("org.codehaus.activemq.journal.impl.SELECTED_CHECKSUM_ALGORITHIM", "hash");
        if ("none".equals(type)) {
            SELECTED_CHECKSUM_ALGORITHIM = 0;
        } else if ("crc32".equals(type)) {
            SELECTED_CHECKSUM_ALGORITHIM = 2;
        } else if ("hash".equals(type)) {
            SELECTED_CHECKSUM_ALGORITHIM = 1;
        } else {
            System.err.println("System property 'org.codehaus.activemq.journal.impl.SELECTED_CHECKSUM_ALGORITHIM' not set properly.  Valid values are: 'none', 'hash', or 'crc32'");
            SELECTED_CHECKSUM_ALGORITHIM = 0;
        }
        END_OF_RECORD = new byte[]{69, 111, 82};
    }
}

