/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.transport.http;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.io.TextWireFormat;
import org.codehaus.activemq.transport.TransportChannelSupport;

public abstract class HttpTransportChannelSupport
extends TransportChannelSupport
implements Runnable {
    private static final Log log = LogFactory.getLog((Class)HttpTransportChannelSupport.class);
    private TextWireFormat wireFormat;
    private String remoteUrl;
    private Thread thread;
    private SynchronizedBoolean closed = new SynchronizedBoolean(false);
    private SynchronizedBoolean started = new SynchronizedBoolean(false);

    public HttpTransportChannelSupport(TextWireFormat wireFormat, String remoteUrl) {
        this.wireFormat = wireFormat;
        this.remoteUrl = remoteUrl;
    }

    public boolean isMulticast() {
        return false;
    }

    public void start() throws JMSException {
        if (this.started.commit(false, true) && this.getClientID() != null) {
            this.startThread();
        }
    }

    protected void startThread() {
        this.thread = new Thread((Runnable)this, this.toString());
        this.thread.start();
    }

    public void stop() {
        if (this.closed.commit(false, true)) {
            super.stop();
        }
    }

    public synchronized void setClientID(String clientID) {
        super.setClientID(clientID);
        if (clientID != null && this.thread == null && this.started.get()) {
            this.startThread();
        }
    }

    public String toString() {
        return "HTTP Reader " + this.getRemoteUrl();
    }

    public boolean canProcessWireFormatVersion(int version) {
        return this.wireFormat.canProcessWireFormatVersion(version);
    }

    public int getCurrentWireFormatVersion() {
        return this.wireFormat.getCurrentWireFormatVersion();
    }

    public String getRemoteUrl() {
        return this.remoteUrl;
    }

    public TextWireFormat getWireFormat() {
        return this.wireFormat;
    }

    public void setWireFormat(TextWireFormat wireFormat) {
        this.wireFormat = wireFormat;
    }

    public SynchronizedBoolean getClosed() {
        return this.closed;
    }

    public SynchronizedBoolean getStarted() {
        return this.started;
    }
}

