/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.transport.jabber;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.io.AbstractWireFormat;
import org.codehaus.activemq.io.WireFormat;
import org.codehaus.activemq.message.ActiveMQBytesMessage;
import org.codehaus.activemq.message.ActiveMQMessage;
import org.codehaus.activemq.message.ActiveMQObjectMessage;
import org.codehaus.activemq.message.ActiveMQTextMessage;
import org.codehaus.activemq.message.Packet;

public class JabberWireFormat
extends AbstractWireFormat {
    private static final Log log = LogFactory.getLog((Class)JabberWireFormat.class);

    public WireFormat copy() {
        return new JabberWireFormat();
    }

    public Packet readPacket(DataInput in) throws IOException {
        return null;
    }

    public Packet readPacket(int firstByte, DataInput in) throws IOException {
        return null;
    }

    public void writePacket(Packet packet, DataOutput out) throws IOException, JMSException {
        switch (packet.getPacketType()) {
            case 6: {
                this.writeMessage((ActiveMQMessage)packet, "", out);
                break;
            }
            case 7: {
                this.writeTextMessage((ActiveMQTextMessage)packet, out);
                break;
            }
            case 9: {
                this.writeBytesMessage((ActiveMQBytesMessage)packet, out);
                break;
            }
            case 8: {
                this.writeObjectMessage((ActiveMQObjectMessage)packet, out);
                break;
            }
            default: {
                log.warn((Object)("Ignoring message type: " + packet.getPacketType() + " packet: " + packet));
            }
        }
    }

    public boolean canProcessWireFormatVersion(int version) {
        return true;
    }

    public int getCurrentWireFormatVersion() {
        return 1;
    }

    protected void writeObjectMessage(ActiveMQObjectMessage message, DataOutput out) throws JMSException, IOException {
        Serializable object = message.getObject();
        String text = object != null ? object.toString() : "";
        this.writeMessage(message, text, out);
    }

    protected void writeTextMessage(ActiveMQTextMessage message, DataOutput out) throws JMSException, IOException {
        this.writeMessage(message, message.getText(), out);
    }

    protected void writeBytesMessage(ActiveMQBytesMessage message, DataOutput out) throws IOException {
        byte[] data = message.getBodyAsBytes();
        String text = this.encodeBinary(data);
        this.writeMessage(message, text, out);
    }

    protected void writeMessage(ActiveMQMessage message, String body, DataOutput out) throws IOException {
        HashMap properties;
        String type = this.getXmppType(message);
        StringBuffer buffer = new StringBuffer("<");
        buffer.append(type);
        buffer.append(" to='");
        buffer.append(message.getJMSDestination().toString());
        buffer.append("' from='");
        buffer.append(message.getJMSReplyTo().toString());
        String messageID = message.getJMSMessageID();
        if (messageID != null) {
            buffer.append("' id='");
            buffer.append(messageID);
        }
        if ((properties = message.getProperties()) != null) {
            Iterator iter = properties.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (value == null) continue;
                buffer.append("' ");
                buffer.append(key.toString());
                buffer.append("='");
                buffer.append(value.toString());
            }
        }
        buffer.append("'>");
        String id = message.getJMSCorrelationID();
        if (id != null) {
            buffer.append("<thread>");
            buffer.append(id);
            buffer.append("</thread>");
        }
        buffer.append(body);
        buffer.append("</");
        buffer.append(type);
        buffer.append(">");
        out.write(buffer.toString().getBytes());
    }

    protected String encodeBinary(byte[] data) {
        throw new RuntimeException("Not implemented yet!");
    }

    protected String getXmppType(ActiveMQMessage message) {
        String type = message.getJMSType();
        if (type == null) {
            type = "message";
        }
        return type;
    }
}

