/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Column;
import org.hsqldb.CompiledStatement;
import org.hsqldb.DatabaseManager;
import org.hsqldb.Expression;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlInternalException;
import org.hsqldb.Record;
import org.hsqldb.Result;
import org.hsqldb.Row;
import org.hsqldb.Select;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableFilter;
import org.hsqldb.Trace;
import org.hsqldb.jdbc.jdbcResultSet;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;

final class CompiledStatementExecutor {
    private Session session;
    private Result updateResult;
    private Result emptyResult;

    CompiledStatementExecutor(Session session) {
        this.session = session;
        this.updateResult = new Result(1);
        this.emptyResult = new Result(1);
    }

    Result execute(CompiledStatement compiledStatement) {
        Result result = null;
        DatabaseManager.gc();
        try {
            compiledStatement.materializeSubQueries(this.session);
            result = this.executeImpl(compiledStatement);
        }
        catch (Throwable throwable) {
            result = new Result(throwable, compiledStatement.sql);
        }
        compiledStatement.dematerializeSubQueries();
        if (result == null) {
            result = this.emptyResult;
        }
        return result;
    }

    private Result executeImpl(CompiledStatement compiledStatement) throws HsqlException {
        switch (compiledStatement.type) {
            case 5: {
                return this.executeSelectStatement(compiledStatement);
            }
            case 2: {
                return this.executeInsertSelectStatement(compiledStatement);
            }
            case 1: {
                return this.executeInsertValuesStatement(compiledStatement);
            }
            case 3: {
                return this.executeUpdateStatement(compiledStatement);
            }
            case 4: {
                return this.executeDeleteStatement(compiledStatement);
            }
            case 6: {
                return this.executeCallStatement(compiledStatement);
            }
            case 9: {
                return this.executeDDLStatement(compiledStatement);
            }
        }
        throw Trace.error(201);
    }

    private Result executeCallStatement(CompiledStatement compiledStatement) throws HsqlException {
        Expression expression = compiledStatement.expression;
        Object object = expression.getValue(this.session);
        if (object instanceof Result) {
            return (Result)object;
        }
        if (object instanceof jdbcResultSet) {
            return ((jdbcResultSet)object).rResult;
        }
        Result result = Result.newSingleColumnResult("@p0", expression.getDataType());
        Object[] objectArray = new Object[]{object};
        result.metaData.classNames[0] = expression.getValueClassName();
        result.add(objectArray);
        return result;
    }

    private Result executeDeleteStatement(CompiledStatement compiledStatement) throws HsqlException {
        Table table = compiledStatement.targetTable;
        TableFilter tableFilter = compiledStatement.targetFilter;
        int n = 0;
        if (tableFilter.findFirst()) {
            Expression expression = compiledStatement.condition;
            HsqlArrayList hsqlArrayList = new HsqlArrayList();
            if (expression == null) {
                do {
                    hsqlArrayList.add(tableFilter.currentRow);
                } while (tableFilter.next());
                n = table.delete(this.session, hsqlArrayList);
            } else {
                do {
                    if (!expression.testCondition(this.session)) continue;
                    hsqlArrayList.add(tableFilter.currentRow);
                } while (tableFilter.next());
                n = table.delete(this.session, hsqlArrayList);
            }
        }
        this.updateResult.updateCount = n;
        return this.updateResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result executeInsertSelectStatement(CompiledStatement compiledStatement) throws HsqlException {
        int n;
        Table table = compiledStatement.targetTable;
        Select select = compiledStatement.select;
        int[] nArray = table.getColumnTypes();
        Result result = select.getResult(this.session, Integer.MAX_VALUE);
        Record record = result.rRoot;
        int[] nArray2 = compiledStatement.columnMap;
        boolean[] blArray = compiledStatement.checkColumns;
        int n2 = nArray2.length;
        boolean bl = false;
        this.session.beginNestedTransaction();
        try {
            while (record != null) {
                Object[] objectArray = table.getNewRowData(this.session, blArray);
                for (int i = 0; i < n2; ++i) {
                    int n3 = nArray2[i];
                    objectArray[n3] = nArray[n3] != result.metaData.colTypes[i] ? Column.convertObject(record.data[i], nArray[n3]) : record.data[i];
                }
                record.data = objectArray;
                record = record.next;
            }
            n = table.insert(this.session, result);
            bl = true;
            this.session.endNestedTransaction(!bl);
        }
        catch (Throwable throwable) {
            this.session.endNestedTransaction(!bl);
            throw throwable;
        }
        this.updateResult.updateCount = n;
        return this.updateResult;
    }

    private Result executeInsertValuesStatement(CompiledStatement compiledStatement) throws HsqlException {
        Table table = compiledStatement.targetTable;
        Object[] objectArray = table.getNewRowData(this.session, compiledStatement.checkColumns);
        int[] nArray = compiledStatement.columnMap;
        Expression[] expressionArray = compiledStatement.columnValues;
        int[] nArray2 = table.getColumnTypes();
        int n = expressionArray.length;
        for (int i = 0; i < n; ++i) {
            Expression expression = expressionArray[i];
            int n2 = nArray[i];
            objectArray[n2] = expression.getValue(this.session, nArray2[n2]);
        }
        table.insert(this.session, objectArray);
        this.updateResult.updateCount = 1;
        return this.updateResult;
    }

    private Result executeSelectStatement(CompiledStatement compiledStatement) throws HsqlException {
        Result result;
        Select select = compiledStatement.select;
        if (select.sIntoTable != null) {
            this.session.checkDDLWrite();
            if (this.session.getDatabase().findUserTable(this.session, select.sIntoTable.name) != null || this.session.getDatabase().dInfo.getSystemTable(this.session, select.sIntoTable.name) != null) {
                throw Trace.error(21, select.sIntoTable.name);
            }
            result = select.getResult(this.session, Integer.MAX_VALUE);
            result = this.session.dbCommandInterpreter.processSelectInto(result, select.sIntoTable, select.intoType);
            this.session.getDatabase().setMetaDirty(false);
        } else {
            result = select.getResult(this.session, this.session.getMaxRows());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result executeUpdateStatement(CompiledStatement compiledStatement) throws HsqlException {
        Table table = compiledStatement.targetTable;
        TableFilter tableFilter = compiledStatement.targetFilter;
        int n = 0;
        if (tableFilter.findFirst()) {
            int[] nArray = compiledStatement.columnMap;
            Expression[] expressionArray = compiledStatement.columnValues;
            Expression expression = compiledStatement.condition;
            int n2 = expressionArray.length;
            HashMappedList hashMappedList = new HashMappedList();
            int n3 = table.getColumnCount();
            int[] nArray2 = table.getColumnTypes();
            boolean bl = false;
            do {
                if (expression != null && !expression.testCondition(this.session)) continue;
                try {
                    Row row = tableFilter.currentRow;
                    Object[] objectArray = table.getNewRow();
                    System.arraycopy(row.getData(), 0, objectArray, 0, n3);
                    for (int i = 0; i < n2; ++i) {
                        int n4 = nArray[i];
                        objectArray[n4] = expressionArray[i].getValue(this.session, nArray2[n4]);
                    }
                    hashMappedList.add(row, objectArray);
                }
                catch (HsqlInternalException hsqlInternalException) {
                    // empty catch block
                }
            } while (tableFilter.next());
            this.session.beginNestedTransaction();
            try {
                n = table.update(this.session, hashMappedList, nArray);
                bl = true;
                this.session.endNestedTransaction(!bl);
            }
            catch (Throwable throwable) {
                this.session.endNestedTransaction(!bl);
                throw throwable;
            }
        }
        this.updateResult.updateCount = n;
        return this.updateResult;
    }

    private Result executeDDLStatement(CompiledStatement compiledStatement) throws HsqlException {
        return this.session.sqlExecuteDirectNoPreChecks(compiledStatement.sql);
    }
}

