/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rowio;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsqldb.Column;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.Trace;
import org.hsqldb.lib.BooleanConverter;
import org.hsqldb.rowio.RowInputBase;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.types.Binary;
import org.hsqldb.types.JavaObject;

public class RowInputText
extends RowInputBase
implements RowInputInterface {
    private String fieldSep;
    private String varSep;
    private String longvarSep;
    private int fieldSepLen;
    private int varSepLen;
    private int longvarSepLen;
    private boolean fieldSepEnd;
    private boolean varSepEnd;
    private boolean longvarSepEnd;
    private int textLen;
    protected String text;
    protected int line;
    protected int field;
    protected int next = 0;
    protected boolean allQuoted;

    public RowInputText(String string, String string2, String string3, boolean bl) {
        super(new byte[0]);
        if (string.endsWith("\n")) {
            this.fieldSepEnd = true;
            string = string.substring(0, string.length() - 1);
        }
        if (string2.endsWith("\n")) {
            this.varSepEnd = true;
            string2 = string2.substring(0, string2.length() - 1);
        }
        if (string3.endsWith("\n")) {
            this.longvarSepEnd = true;
            string3 = string3.substring(0, string3.length() - 1);
        }
        this.allQuoted = bl;
        this.fieldSep = string;
        this.varSep = string2;
        this.longvarSep = string3;
        this.fieldSepLen = string.length();
        this.varSepLen = string2.length();
        this.longvarSepLen = string3.length();
    }

    public void setSource(String string, int n) {
        this.text = string.substring(0, string.indexOf(10));
        this.textLen = this.text.length();
        this.filePos = n;
        this.size = string.length();
        this.nextPos = n + this.size;
        this.next = 0;
        ++this.line;
        this.field = 0;
    }

    public void setSource(String string, int n, int n2) {
        this.text = string.substring(0, string.indexOf(10));
        this.textLen = this.text.length();
        this.filePos = n;
        this.size = n2;
        this.nextPos = n + this.size;
        this.next = 0;
        ++this.line;
        this.field = 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getField(String string, int n, boolean bl) throws IOException {
        String string2 = null;
        try {
            int n2 = this.next;
            ++this.field;
            if (bl) {
                if (this.next >= this.textLen && n > 0) {
                    throw Trace.error(182);
                }
                if (!this.text.endsWith(string)) throw Trace.error(183);
                this.next = this.textLen - n;
            } else {
                this.next = this.text.indexOf(string, n2);
                if (this.next == -1) {
                    this.next = this.textLen;
                }
            }
            string2 = this.text.substring(n2, this.next);
            this.next += n;
            if (string2.length() != 0) return string2;
            return null;
        }
        catch (Exception exception) {
            throw new IOException(Trace.getMessage(184, true, new Object[]{new Integer(this.field), exception.getMessage()}));
        }
    }

    public String readString() throws IOException {
        return this.getField(this.fieldSep, this.fieldSepLen, this.fieldSepEnd);
    }

    private String readVarString() throws IOException {
        return this.getField(this.varSep, this.varSepLen, this.varSepEnd);
    }

    private String readLongVarString() throws IOException {
        return this.getField(this.longvarSep, this.longvarSepLen, this.longvarSepEnd);
    }

    public int readIntData() throws IOException {
        String string = this.readString();
        if (string == null) {
            return 0;
        }
        if ((string = string.trim()).length() == 0) {
            return 0;
        }
        return Integer.parseInt(string);
    }

    public long readLongData() throws IOException {
        throw new RuntimeException();
    }

    public int readType() throws IOException {
        return 0;
    }

    protected boolean checkNull() {
        return false;
    }

    protected String readChar(int n) throws IOException {
        switch (n) {
            case 1: {
                return this.readString();
            }
            case 12: 
            case 100: {
                return this.readVarString();
            }
        }
        return this.readLongVarString();
    }

    protected Integer readSmallint() throws IOException, HsqlException {
        String string = this.readString();
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        return Integer.valueOf(string);
    }

    protected Integer readInteger() throws IOException, HsqlException {
        String string = this.readString();
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        return Integer.valueOf(string);
    }

    protected Long readBigint() throws IOException, HsqlException {
        String string = this.readString();
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        return Long.valueOf(string);
    }

    protected Double readReal(int n) throws IOException, HsqlException {
        String string = this.readString();
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        return Double.valueOf(string);
    }

    protected BigDecimal readDecimal() throws IOException, HsqlException {
        String string = this.readString();
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        return new BigDecimal(string);
    }

    protected Time readTime() throws IOException, HsqlException {
        String string = this.readString();
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        return Time.valueOf(string);
    }

    protected Date readDate() throws IOException, HsqlException {
        String string = this.readString();
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        return Date.valueOf(string);
    }

    protected Timestamp readTimestamp() throws IOException, HsqlException {
        String string = this.readString();
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        try {
            return Timestamp.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return HsqlDateTime.timestampValue(string);
        }
    }

    protected Boolean readBit() throws IOException, HsqlException {
        String string = this.readString();
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        return BooleanConverter.getBoolean(string);
    }

    protected Object readOther() throws IOException, HsqlException {
        String string = this.readString();
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        byte[] byArray = Column.hexToByteArray(string);
        return new JavaObject(byArray);
    }

    protected Binary readBinary(int n) throws IOException, HsqlException {
        String string = this.readString();
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        return new Binary(Column.hexToByteArray(string), false);
    }

    public int getLineNumber() {
        return this.line;
    }

    public void setNextPos(int n) {
        this.nextPos = n;
    }

    public void skippedLine() {
        ++this.line;
    }

    public void reset() {
        this.text = "";
        this.textLen = 0;
        this.filePos = 0;
        this.size = 0;
        this.nextPos = 0;
        this.next = 0;
        this.field = 0;
        this.line = 0;
    }
}

