/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.spring;

import com.opensymphony.xwork.ObjectFactory;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;

public class SpringObjectFactory
extends ObjectFactory
implements ApplicationContextAware {
    private static final Log log = LogFactory.getLog((Class)(class$com$opensymphony$xwork$spring$SpringObjectFactory == null ? (class$com$opensymphony$xwork$spring$SpringObjectFactory = SpringObjectFactory.class$("com.opensymphony.xwork.spring.SpringObjectFactory")) : class$com$opensymphony$xwork$spring$SpringObjectFactory));
    private ApplicationContext appContext;
    private AutowireCapableBeanFactory autoWiringFactory;
    private Map classes = new HashMap();
    static /* synthetic */ Class class$com$opensymphony$xwork$spring$SpringObjectFactory;

    public void setApplicationContext(ApplicationContext appContext) throws BeansException {
        this.appContext = appContext;
        this.findAutoWiringBeanFactory(this.appContext);
    }

    private void findAutoWiringBeanFactory(ApplicationContext context) {
        if (context instanceof AutowireCapableBeanFactory) {
            this.autoWiringFactory = (AutowireCapableBeanFactory)context;
        } else if (context instanceof ConfigurableApplicationContext) {
            this.autoWiringFactory = ((ConfigurableApplicationContext)context).getBeanFactory();
        } else if (context.getParent() != null) {
            this.findAutoWiringBeanFactory(context.getParent());
        }
    }

    public Object buildBean(String beanName) throws Exception {
        try {
            return this.appContext.getBean(beanName);
        }
        catch (NoSuchBeanDefinitionException e) {
            return this.autoWireBean(super.buildBean(beanName));
        }
    }

    public Object buildBean(Class arg0) throws Exception {
        return this.autoWireBean(super.buildBean(arg0));
    }

    public Object autoWireBean(Object bean) {
        if (this.autoWiringFactory != null) {
            this.autoWiringFactory.autowireBeanProperties(bean, 1, false);
        }
        if (bean instanceof ApplicationContextAware) {
            ((ApplicationContextAware)bean).setApplicationContext(this.appContext);
        }
        return bean;
    }

    public Class getClassInstance(String className) throws ClassNotFoundException {
        Class<Object> clazz = (Class<?>)this.classes.get(className);
        if (clazz == null) {
            clazz = this.appContext.containsBean(className) ? this.appContext.getBean(className).getClass() : super.getClassInstance(className);
            this.classes.put(className, clazz);
        }
        return clazz;
    }

    public void initObjectFactory() {
        ObjectFactory.setObjectFactory((ObjectFactory)this);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

