/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.type;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.sf.hibernate.AssertionFailure;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.PersistentEnum;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.type.ImmutableType;
import net.sf.hibernate.type.LiteralType;
import net.sf.hibernate.util.ReflectHelper;

public class PersistentEnumType
extends ImmutableType
implements LiteralType {
    private static final Class[] INTEGER_ARG = new Class[]{Integer.TYPE};
    private final Class enumClass;
    private final Method method;

    public PersistentEnumType(Class enumClass) throws MappingException {
        this.enumClass = enumClass;
        try {
            this.method = enumClass.getDeclaredMethod("fromInt", INTEGER_ARG);
            if (!ReflectHelper.isPublic(enumClass, this.method)) {
                this.method.setAccessible(true);
            }
        }
        catch (NoSuchMethodException nme) {
            throw new MappingException("PersistentEnum class did not implement fromInt(int): " + enumClass.getName());
        }
    }

    public Object get(ResultSet rs, String name) throws HibernateException, SQLException {
        int code = rs.getInt(name);
        if (rs.wasNull()) {
            return null;
        }
        return this.getInstance(new Integer(code));
    }

    public Object getInstance(Integer code) throws HibernateException {
        try {
            return this.method.invoke(null, code);
        }
        catch (IllegalArgumentException iae) {
            throw new AssertionFailure("Could not invoke fromInt() from PersistentEnumType", iae);
        }
        catch (InvocationTargetException ite) {
            throw new HibernateException("InvocationTargetException occurred inside fromInt()", ite);
        }
        catch (IllegalAccessException iae) {
            throw new HibernateException("IllegalAccessException occurred calling fromInt()", iae);
        }
    }

    public boolean equals(Object x, Object y) {
        return x == y || x != null && y != null && x.getClass() == y.getClass() && ((PersistentEnum)x).toInt() == ((PersistentEnum)y).toInt();
    }

    public Class getReturnedClass() {
        return this.enumClass;
    }

    public void set(PreparedStatement st, Object value, int index) throws SQLException {
        if (value == null) {
            st.setNull(index, 5);
        } else {
            st.setInt(index, ((PersistentEnum)value).toInt());
        }
    }

    public int sqlType() {
        return 5;
    }

    public String getName() {
        return this.enumClass.getName();
    }

    public String toString(Object value) {
        return Integer.toString(((PersistentEnum)value).toInt());
    }

    public Object fromStringValue(String xml) throws HibernateException {
        return this.getInstance(new Integer(xml));
    }

    public Object assemble(Serializable cached, SessionImplementor session, Object owner) throws HibernateException {
        if (cached == null) {
            return null;
        }
        return this.getInstance((Integer)cached);
    }

    public Serializable disassemble(Object value, SessionImplementor session) throws HibernateException {
        return value == null ? null : new Integer(((PersistentEnum)value).toInt());
    }

    public String objectToSQLString(Object value) throws Exception {
        return Integer.toString(((PersistentEnum)value).toInt());
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        return ((PersistentEnumType)object).enumClass == this.enumClass;
    }

    public int hashCode() {
        return this.enumClass.hashCode();
    }
}

