/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.util.ArrayList;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;

public class NotificationBroadcasterSupport
implements NotificationBroadcaster {
    private ArrayList _listenerList;

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        if (this._listenerList == null) {
            this._listenerList = new ArrayList();
        }
        this._listenerList.add(new Listener(listener, filter, handback));
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        if (this._listenerList == null) {
            return;
        }
        int i = this._listenerList.size() - 1;
        while (i >= 0) {
            Listener callback = (Listener)this._listenerList.get(i);
            if (callback._listener == listener) {
                this._listenerList.remove(i);
            }
            --i;
        }
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[0];
    }

    public void sendNotification(Notification notification) {
        if (this._listenerList == null) {
            return;
        }
        int i = 0;
        while (i < this._listenerList.size()) {
            Listener callback = (Listener)this._listenerList.get(i);
            if (callback._filter == null || callback._filter.isNotificationEnabled(notification)) {
                callback._listener.handleNotification(notification, callback._handback);
            }
            ++i;
        }
    }

    static class Listener {
        NotificationListener _listener;
        NotificationFilter _filter;
        Object _handback;

        Listener(NotificationListener listener, NotificationFilter filter, Object handback) {
            this._listener = listener;
            this._filter = filter;
            this._handback = handback;
        }
    }
}

