/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.InvalidKeyException;
import javax.management.openmbean.InvalidOpenTypeException;
import javax.management.openmbean.KeyAlreadyExistsException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularType;

public class TabularDataSupport
implements TabularData,
Map,
Cloneable,
Serializable {
    static final long serialVersionUID = 5720150593236309827L;
    private Map dataMap;
    private TabularType tabularType;
    private transient String[] indexNamesArray;

    public TabularDataSupport(TabularType tabularType) {
        this(tabularType, 101, 0.75f);
    }

    public TabularDataSupport(TabularType tabularType, int n, float f) {
        if (tabularType == null) {
            throw new IllegalArgumentException("Argument tabularType cannot be null.");
        }
        this.tabularType = tabularType;
        List list = tabularType.getIndexNames();
        this.indexNamesArray = list.toArray(new String[list.size()]);
        this.dataMap = new HashMap(n, f);
    }

    public TabularType getTabularType() {
        return this.tabularType;
    }

    public Object[] calculateIndex(CompositeData compositeData) {
        this.checkValueType(compositeData);
        return this.internalCalculateIndex(compositeData).toArray();
    }

    public boolean containsKey(Object object) {
        Object[] objectArray;
        try {
            objectArray = (Object[])object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return this.containsKey(objectArray);
    }

    public boolean containsKey(Object[] objectArray) {
        return objectArray == null ? false : this.dataMap.containsKey(Arrays.asList(objectArray));
    }

    public boolean containsValue(CompositeData compositeData) {
        return this.dataMap.containsValue(compositeData);
    }

    public boolean containsValue(Object object) {
        return this.dataMap.containsValue(object);
    }

    public Object get(Object object) {
        return this.get((Object[])object);
    }

    public CompositeData get(Object[] objectArray) {
        this.checkKeyType(objectArray);
        return (CompositeData)this.dataMap.get(Arrays.asList(objectArray));
    }

    public Object put(Object object, Object object2) {
        this.put((CompositeData)object2);
        return object2;
    }

    public void put(CompositeData compositeData) {
        List list = this.checkValueAndIndex(compositeData);
        this.dataMap.put(list, compositeData);
    }

    public Object remove(Object object) {
        return this.remove((Object[])object);
    }

    public CompositeData remove(Object[] objectArray) {
        this.checkKeyType(objectArray);
        return (CompositeData)this.dataMap.remove(Arrays.asList(objectArray));
    }

    public void putAll(Map map) {
        CompositeData[] compositeDataArray;
        if (map == null || map.size() == 0) {
            return;
        }
        try {
            compositeDataArray = map.values().toArray(new CompositeData[map.size()]);
        }
        catch (ArrayStoreException arrayStoreException) {
            throw new ClassCastException("Map argument t contains values which are not instances of <tt>CompositeData</tt>");
        }
        this.putAll(compositeDataArray);
    }

    public void putAll(CompositeData[] compositeDataArray) {
        if (compositeDataArray == null || compositeDataArray.length == 0) {
            return;
        }
        ArrayList<List> arrayList = new ArrayList<List>(compositeDataArray.length + 1);
        int n = 0;
        while (n < compositeDataArray.length) {
            List list = this.checkValueAndIndex(compositeDataArray[n]);
            if (arrayList.contains(list)) {
                throw new KeyAlreadyExistsException("Argument elements values[" + n + "] and values[" + arrayList.indexOf(list) + "] have the same indexes, " + "calculated according to this TabularData instance's tabularType.");
            }
            arrayList.add(list);
            ++n;
        }
        int n2 = 0;
        while (n2 < compositeDataArray.length) {
            this.dataMap.put(arrayList.get(n2), compositeDataArray[n2]);
            ++n2;
        }
    }

    public void clear() {
        this.dataMap.clear();
    }

    public int size() {
        return this.dataMap.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set keySet() {
        return this.dataMap.keySet();
    }

    public Collection values() {
        return this.dataMap.values();
    }

    public Set entrySet() {
        return this.dataMap.entrySet();
    }

    public Object clone() {
        try {
            TabularDataSupport tabularDataSupport = (TabularDataSupport)super.clone();
            tabularDataSupport.dataMap = (HashMap)((HashMap)tabularDataSupport.dataMap).clone();
            return tabularDataSupport;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public boolean equals(Object object) {
        TabularData tabularData;
        if (object == null) {
            return false;
        }
        try {
            tabularData = (TabularData)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        if (!this.getTabularType().equals(tabularData.getTabularType())) {
            return false;
        }
        if (this.size() != tabularData.size()) {
            return false;
        }
        Iterator iterator = this.values().iterator();
        while (iterator.hasNext()) {
            CompositeData compositeData = (CompositeData)iterator.next();
            if (tabularData.containsValue(compositeData)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        n += this.tabularType.hashCode();
        Iterator iterator = this.values().iterator();
        while (iterator.hasNext()) {
            n += ((CompositeData)iterator.next()).hashCode();
        }
        return n;
    }

    public String toString() {
        return this.getClass().getName() + "(tabularType=" + this.tabularType.toString() + ",contents=" + this.dataMap.toString() + ")";
    }

    private List internalCalculateIndex(CompositeData compositeData) {
        return Collections.unmodifiableList(Arrays.asList(compositeData.getAll(this.indexNamesArray)));
    }

    private void checkKeyType(Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            throw new NullPointerException("Argument key cannot be null or empty.");
        }
        if (objectArray.length != this.indexNamesArray.length) {
            throw new InvalidKeyException("Argument key's length=" + objectArray.length + " is different from the number of item values, which is " + this.indexNamesArray.length + ", specified for the indexing rows in this TabularData instance.");
        }
        int n = 0;
        while (n < objectArray.length) {
            OpenType openType = this.tabularType.getRowType().getType(this.indexNamesArray[n]);
            if (objectArray[n] != null && !openType.isValue(objectArray[n])) {
                throw new InvalidKeyException("Argument element key[" + n + "] is not a value for the open type expected for " + "this element of the index, whose name is \"" + this.indexNamesArray[n] + "\" and whose open type is " + openType);
            }
            ++n;
        }
    }

    private void checkValueType(CompositeData compositeData) {
        if (compositeData == null) {
            throw new NullPointerException("Argument value cannot be null.");
        }
        if (!compositeData.getCompositeType().equals(this.tabularType.getRowType())) {
            throw new InvalidOpenTypeException("Argument value's composite type [" + compositeData.getCompositeType() + "] is not equal to " + "this TabularData instance's row type [" + this.tabularType.getRowType() + "].");
        }
    }

    private List checkValueAndIndex(CompositeData compositeData) {
        this.checkValueType(compositeData);
        List list = this.internalCalculateIndex(compositeData);
        if (this.dataMap.containsKey(list)) {
            throw new KeyAlreadyExistsException("Argument value's index, calculated according to this TabularData instance's tabularType, already refers to a value in this table.");
        }
        return list;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        List list = this.tabularType.getIndexNames();
        this.indexNamesArray = list.toArray(new String[list.size()]);
    }
}

