/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.validator;

import com.opensymphony.util.ClassLoaderUtil;
import com.opensymphony.xwork.ObjectFactory;
import com.opensymphony.xwork.validator.ShortCircuitableValidator;
import com.opensymphony.xwork.validator.Validator;
import com.opensymphony.xwork.validator.ValidatorConfig;
import com.opensymphony.xwork.validator.ValidatorFileParser;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ValidatorFactory {
    private static Map validators = new HashMap();
    private static Log LOG = LogFactory.getLog((Class)(class$com$opensymphony$xwork$validator$ValidatorFactory == null ? (class$com$opensymphony$xwork$validator$ValidatorFactory = ValidatorFactory.class$("com.opensymphony.xwork.validator.ValidatorFactory")) : class$com$opensymphony$xwork$validator$ValidatorFactory));
    static /* synthetic */ Class class$com$opensymphony$xwork$validator$ValidatorFactory;

    private ValidatorFactory() {
    }

    public static Validator getValidator(ValidatorConfig cfg) {
        Validator validator;
        String className = ValidatorFactory.lookupRegisteredValidatorType(cfg.getType());
        try {
            validator = ObjectFactory.getObjectFactory().buildValidator(className, cfg.getParams());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException("There was a problem creating a Validator of type " + className);
        }
        validator.setMessageKey(cfg.getMessageKey());
        validator.setDefaultMessage(cfg.getDefaultMessage());
        if (validator instanceof ShortCircuitableValidator) {
            ((ShortCircuitableValidator)((Object)validator)).setShortCircuit(cfg.isShortCircuit());
        }
        return validator;
    }

    public static void registerValidator(String name, String className) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Registering validator of class " + className + " with name " + name));
        }
        validators.put(name, className);
    }

    public static String lookupRegisteredValidatorType(String name) {
        String className = (String)validators.get(name);
        if (className == null) {
            throw new IllegalArgumentException("There is no validator class mapped to the name " + name);
        }
        return className;
    }

    private static void parseValidators() {
        InputStream is;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Loading validator definitions.");
        }
        if ((is = ClassLoaderUtil.getResourceAsStream((String)"validators.xml", (Class)(class$com$opensymphony$xwork$validator$ValidatorFactory == null ? (class$com$opensymphony$xwork$validator$ValidatorFactory = ValidatorFactory.class$("com.opensymphony.xwork.validator.ValidatorFactory")) : class$com$opensymphony$xwork$validator$ValidatorFactory))) != null) {
            ValidatorFileParser.parseValidatorDefinitions(is);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ValidatorFactory.parseValidators();
    }
}

