/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.burlap.server;

import com.caucho.burlap.io.BurlapInput;
import com.caucho.burlap.io.BurlapOutput;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;

public class BurlapSkeleton {
    private HashMap _methodMap = new HashMap();
    private Object _service;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$java$rmi$Remote;

    public BurlapSkeleton(Object service) {
        this._service = service;
        Method[] methodList = service.getClass().getMethods();
        for (int i = 0; i < methodList.length; ++i) {
            Method method = methodList[i];
            if (this._methodMap.get(method.getName()) == null) {
                this._methodMap.put(method.getName(), methodList[i]);
            }
            Class<?>[] param = method.getParameterTypes();
            String mangledName = method.getName() + "__" + param.length;
            this._methodMap.put(mangledName, methodList[i]);
            this._methodMap.put(this.mangleName(method, false), methodList[i]);
        }
    }

    protected String mangleName(Method method, boolean isFull) {
        StringBuffer sb = new StringBuffer();
        sb.append(method.getName());
        Class<?>[] params = method.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            sb.append('_');
            this.mangleClass(sb, params[i], isFull);
        }
        return sb.toString();
    }

    private void mangleClass(StringBuffer sb, Class cl, boolean isFull) {
        String name = cl.getName();
        if (name.equals("boolean")) {
            sb.append("boolean");
        } else if (name.equals("int") || name.equals("short") || name.equals("byte")) {
            sb.append("int");
        } else if (name.equals("long")) {
            sb.append("long");
        } else if (name.equals("double") || name.equals("float")) {
            sb.append("double");
        } else if (name.equals("java.lang.String") || name.equals("com.caucho.util.CharBuffer") || name.equals("char") || name.equals("java.io.Reader")) {
            sb.append("string");
        } else if (name.equals("java.util.Date") || name.equals("com.caucho.util.QDate")) {
            sb.append("date");
        } else if ((class$java$io$InputStream == null ? (class$java$io$InputStream = BurlapSkeleton.class$("java.io.InputStream")) : class$java$io$InputStream).isAssignableFrom(cl) || name.equals("[B")) {
            sb.append("binary");
        } else if (cl.isArray()) {
            sb.append("array_");
            this.mangleClass(sb, cl.getComponentType(), isFull);
        } else if (name.equals("org.w3c.dom.Node") || name.equals("org.w3c.dom.Element") || name.equals("org.w3c.dom.Document")) {
            sb.append("xml");
        } else if (isFull) {
            sb.append(name);
        } else {
            int p = name.lastIndexOf(46);
            if (p > 0) {
                sb.append(name.substring(p + 1));
            } else {
                sb.append(name);
            }
        }
    }

    public void invoke(BurlapInput in, BurlapOutput out) throws Throwable {
        in.startCall();
        String methodName = in.getMethod();
        Method method = (Method)this._methodMap.get(methodName);
        if (method == null) {
            if (methodName.equals("_burlap_getAttribute")) {
                this.getBurlapAttribute(in, out);
                return;
            }
            throw new IOException("No server method matching:" + in.getMethod());
        }
        Class<?>[] args = method.getParameterTypes();
        Object[] values = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            values[i] = in.readObject(args[i]);
        }
        in.completeCall();
        Object result = null;
        try {
            result = method.invoke(this._service, values);
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            out.startReply();
            out.writeFault("ServiceException", e.getMessage(), e);
            out.completeReply();
            return;
        }
        out.startReply();
        out.writeObject(result);
        out.completeReply();
    }

    public void getBurlapAttribute(BurlapInput in, BurlapOutput out) throws IOException {
        String name = in.readString();
        in.completeCall();
        out.startReply();
        if (name.equals("home-class") || name.equals("remote-class")) {
            Class<?> cl = this._service.getClass();
            Class<?>[] interfaces = cl.getInterfaces();
            String homeClass = null;
            for (int i = 0; i < interfaces.length; ++i) {
                if (!(class$java$rmi$Remote == null ? BurlapSkeleton.class$("java.rmi.Remote") : class$java$rmi$Remote).isAssignableFrom(interfaces[i]) || (class$java$rmi$Remote == null ? BurlapSkeleton.class$("java.rmi.Remote") : class$java$rmi$Remote) == interfaces[i]) continue;
                homeClass = interfaces[i].getName();
            }
            if (homeClass == null) {
                homeClass = cl.getName();
            }
            out.writeString(homeClass);
        } else {
            out.writeObject(null);
        }
        out.completeReply();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

