/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.el;

import com.caucho.el.ELException;
import com.caucho.el.Expr;
import com.caucho.el.MethodExpr;
import com.caucho.el.StringLiteral;
import com.caucho.el.VariableResolver;
import com.caucho.util.BeanUtil;
import com.caucho.vfs.WriteStream;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;

public class ArrayExpr
extends Expr {
    private Expr _left;
    private Expr _right;
    private Class _lastClass;
    private String _lastField;
    private Method _lastMethod;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    public ArrayExpr(Expr left, Expr right) {
        this._left = left;
        this._right = right;
    }

    public Expr createMethod(Expr[] args) {
        if (!(this._right instanceof StringLiteral)) {
            return null;
        }
        StringLiteral literal = (StringLiteral)this._right;
        return new MethodExpr(this._left, literal.getValue(), args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evalObject(VariableResolver env) throws ELException {
        Object aObj = this._left.evalObject(env);
        if (aObj == null) {
            return null;
        }
        Object fieldObj = this._right.evalObject(env);
        if (fieldObj == null) {
            return null;
        }
        if (aObj instanceof Map) {
            return ((Map)aObj).get(fieldObj);
        }
        if (aObj instanceof List) {
            int ref = (int)ArrayExpr.toLong(fieldObj);
            try {
                return ((List)aObj).get(ref);
            }
            catch (Exception e) {
                dbg.log(e);
                return null;
            }
        }
        Class<?> aClass = aObj.getClass();
        if (aClass.isArray()) {
            int ref = (int)ArrayExpr.toLong(fieldObj);
            try {
                return Array.get(aObj, ref);
            }
            catch (Exception e) {
                dbg.log(e);
                return null;
            }
        }
        String fieldName = ArrayExpr.toString(fieldObj);
        Method getMethod = null;
        try {
            ArrayExpr arrayExpr = this;
            synchronized (arrayExpr) {
                if (this._lastClass == aClass && this._lastField.equals(fieldName)) {
                    getMethod = this._lastMethod;
                } else {
                    BeanInfo info = Introspector.getBeanInfo(aClass);
                    getMethod = BeanUtil.getGetMethod(info, fieldName);
                    this._lastClass = aClass;
                    this._lastField = fieldName;
                    this._lastMethod = getMethod;
                }
            }
            if (getMethod != null) {
                return getMethod.invoke(aObj, null);
            }
        }
        catch (Exception e) {
            dbg.log(e);
            return null;
        }
        try {
            getMethod = aClass.getMethod("get", class$java$lang$String == null ? (class$java$lang$String = ArrayExpr.class$("java.lang.String")) : class$java$lang$String);
            if (getMethod != null) {
                return getMethod.invoke(aObj, fieldName);
            }
        }
        catch (Exception e) {
            dbg.log(e);
            return null;
        }
        try {
            getMethod = aClass.getMethod("get", class$java$lang$Object == null ? (class$java$lang$Object = ArrayExpr.class$("java.lang.Object")) : class$java$lang$Object);
            if (getMethod != null) {
                return getMethod.invoke(aObj, fieldObj);
            }
        }
        catch (Exception e) {
            dbg.log(e);
            return null;
        }
        dbg.log(L.l("no get method {0} for class {1}", (Object)fieldName, aClass.getName()));
        return null;
    }

    public void printCreate(WriteStream os) throws IOException {
        os.print("new com.caucho.el.ArrayExpr(");
        this._left.printCreate(os);
        os.print(", ");
        this._right.printCreate(os);
        os.print(")");
    }

    public boolean equals(Object o) {
        if (!(o instanceof ArrayExpr)) {
            return false;
        }
        ArrayExpr expr = (ArrayExpr)o;
        return this._left.equals(expr._left) && this._right.equals(expr._right);
    }

    public String toString() {
        return this._left + "[" + this._right + "]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

