/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.el;

import com.caucho.el.ELException;
import com.caucho.el.Expr;
import com.caucho.el.VariableResolver;
import com.caucho.vfs.WriteStream;
import java.io.IOException;

public class DoubleLiteral
extends Expr {
    private double _value;
    private Double _objValue;

    public DoubleLiteral(double value) {
        this._value = value;
        this._objValue = new Double(value);
    }

    public boolean isConstant() {
        return true;
    }

    public Object evalObject(VariableResolver env) throws ELException {
        return this._objValue;
    }

    public long evalLong(VariableResolver env) throws ELException {
        return (long)this._value;
    }

    public double evalDouble(VariableResolver env) throws ELException {
        return this._value;
    }

    public void print(WriteStream out, VariableResolver env) throws IOException, ELException {
        out.print(this._value);
    }

    public void printEscaped(WriteStream out, VariableResolver env) throws IOException, ELException {
        out.print(this._value);
    }

    public void printCreate(WriteStream os) throws IOException {
        os.print("new com.caucho.el.DoubleLiteral(");
        os.print(this._value);
        os.print(")");
    }

    public boolean equals(Object o) {
        if (!(o instanceof DoubleLiteral)) {
            return false;
        }
        DoubleLiteral literal = (DoubleLiteral)o;
        return this._value == literal._value;
    }

    public String toString() {
        return String.valueOf(this._value);
    }
}

