/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.el;

import com.caucho.el.ELException;
import com.caucho.el.Expr;
import com.caucho.el.VariableResolver;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.WriteStream;
import java.io.IOException;

public class InterpolateExpr
extends Expr {
    private Expr _left;
    private Expr _right;

    public InterpolateExpr(Expr left, Expr right) {
        this._left = left;
        this._right = right;
    }

    public Object evalObject(VariableResolver env) throws ELException {
        return this.evalString(env);
    }

    public String evalString(VariableResolver env) throws ELException {
        CharBuffer cb = CharBuffer.allocate();
        Expr expr = this;
        while (expr instanceof InterpolateExpr) {
            InterpolateExpr subExpr = expr;
            String value = subExpr._left.evalString(env);
            if (value != null) {
                cb.append(value);
            }
            expr = expr._right;
        }
        String value = ((Expr)expr).evalString(env);
        if (value != null) {
            cb.append(value);
        }
        return cb.close();
    }

    public boolean print(WriteStream out, VariableResolver env, boolean escapeXml) throws IOException, ELException {
        this._left.print(out, env, escapeXml);
        this._right.print(out, env, escapeXml);
        return false;
    }

    public void printCreate(WriteStream os) throws IOException {
        os.print("new com.caucho.el.InterpolateExpr(");
        this._left.printCreate(os);
        os.print(", ");
        this._right.printCreate(os);
        os.print(")");
    }

    public boolean equals(Object o) {
        if (!(o instanceof InterpolateExpr)) {
            return false;
        }
        InterpolateExpr expr = (InterpolateExpr)o;
        return this._left.equals(expr._left) && this._right.equals(expr._right);
    }
}

