/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es;

import com.caucho.es.ESBase;
import com.caucho.es.ESException;
import com.caucho.es.ESId;
import com.caucho.es.ESNumber;
import com.caucho.es.ESObject;
import com.caucho.es.ESString;
import com.caucho.es.ESWrapperException;
import com.caucho.es.Global;
import com.caucho.util.CharBuffer;
import com.caucho.util.IntMap;
import java.util.ArrayList;
import java.util.Iterator;

class ESArray
extends ESObject {
    static ESId LENGTH = ESId.intern("length");

    ESArray() {
        super("Array", null);
        this.put(LENGTH, (ESBase)ESNumber.create(0.0), 6);
    }

    public void setProperty(int i, ESBase value) throws Throwable {
        super.setProperty(ESString.create(i), value);
        int length = this.getProperty(LENGTH).toInt32();
        if (i >= length) {
            super.setProperty(LENGTH, (ESBase)ESNumber.create(i + 1));
        }
    }

    public void setProperty(ESString key, ESBase value) throws Throwable {
        if (key.equals(LENGTH)) {
            int newLength;
            int oldLength;
            try {
                oldLength = this.getProperty(LENGTH).toInt32();
                newLength = value.toInt32();
            }
            catch (ESException e) {
                return;
            }
            for (int i = newLength; i < oldLength; ++i) {
                try {
                    this.delete(ESString.create(i));
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (newLength < 0) {
                newLength = 0;
            }
            super.setProperty(LENGTH, (ESBase)ESNumber.create(newLength));
            return;
        }
        super.setProperty(key, value);
        try {
            int keyValue = Integer.parseInt(key.toString());
            int length = this.getProperty(LENGTH).toInt32();
            if (keyValue >= length) {
                super.setProperty(LENGTH, (ESBase)ESNumber.create(keyValue + 1));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static ESString arrayToSource(ESObject obj, IntMap map, boolean isLoopPass) throws Throwable {
        Global resin = Global.getGlobalProto();
        CharBuffer cb = new CharBuffer();
        int mark = map.get(obj);
        if (mark > 0 && isLoopPass) {
            return null;
        }
        if (mark > 0) {
            cb.append("#" + mark + "=");
            map.put(obj, -mark);
        } else {
            if (mark == 0 && isLoopPass) {
                map.put(obj, resin.addMark());
                return null;
            }
            if (mark < 0 && !isLoopPass) {
                return ESString.create("#" + -mark + "#");
            }
        }
        if (isLoopPass) {
            map.put(obj, 0);
        }
        int len = obj.getProperty(LENGTH).toInt32();
        boolean noValue = true;
        cb.append("[");
        for (int i = 0; i < len; ++i) {
            ESBase value;
            if (i != 0) {
                cb.append(", ");
            }
            if ((value = obj.hasProperty(i)) != null && value != esNull && value != esUndefined && value != esEmpty) {
                if (isLoopPass) {
                    value.toSource(map, isLoopPass);
                    continue;
                }
                cb.append(value.toSource(map, isLoopPass));
                continue;
            }
            if (i + 1 != len) continue;
            cb.append(",");
        }
        cb.append("]");
        return ESString.create(cb.toString());
    }

    public Iterator keys() throws ESException {
        ArrayList<String> values = new ArrayList<String>();
        try {
            int len = this.getProperty(LENGTH).toInt32();
            for (int i = 0; i < len; ++i) {
                ESBase prop = this.getProperty(i);
                values.add(String.valueOf(i));
            }
        }
        catch (Throwable e) {
            throw ESWrapperException.create(e);
        }
        return values.iterator();
    }

    public ESString toSource(IntMap map, boolean isLoopPass) throws Throwable {
        return ESArray.arrayToSource(this, map, isLoopPass);
    }

    public ESObject dup() {
        return new ESArray(false);
    }

    protected ESArray(boolean dummy) {
    }
}

