/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es;

import com.caucho.es.Call;
import com.caucho.es.ESBase;
import com.caucho.es.ESException;
import com.caucho.es.ESId;
import com.caucho.es.ESNumber;
import com.caucho.es.ESObject;
import com.caucho.es.ESString;
import com.caucho.es.ESThunk;
import com.caucho.es.Global;
import com.caucho.es.Native;

class NativeWrapper
extends ESObject {
    static ESId CONSTRUCTOR = ESId.intern("constructor");
    static ESId LENGTH = ESId.intern("length");
    static ESId PROTOTYPE = ESId.intern("prototype");
    Native fun;
    Native constructor;

    NativeWrapper(Global resin, Native fun, ESObject proto, int thunk) {
        super("Function", resin.funProto);
        if (proto == null) {
            throw new RuntimeException();
        }
        this.fun = fun;
        this.className = "Function";
        fun.newN = fun.n;
        this.constructor = fun;
        proto.put(CONSTRUCTOR, (ESBase)new ESThunk(thunk), 4);
        this.put(PROTOTYPE, (ESBase)new ESThunk(thunk - 1), 7);
        this.put(LENGTH, (ESBase)ESNumber.create(fun.length), 7);
    }

    protected NativeWrapper() {
    }

    public ESBase typeof() throws ESException {
        return ESString.create("function");
    }

    public ESBase getProperty(ESString name) throws Throwable {
        ESBase value = this.fun.getProperty(name);
        if (value != esEmpty && value != null) {
            return value;
        }
        value = super.getProperty(name);
        return value;
    }

    public void setProperty(ESString name, ESBase value) throws Throwable {
        this.fun.setProperty(name, value);
        super.setProperty(name, value);
    }

    public ESBase toPrimitive(int hint) throws Throwable {
        return this.fun.toStr();
    }

    public ESBase call(Call eval, int length) throws Throwable {
        return this.fun.call(eval, length);
    }

    public ESBase construct(Call eval, int length) throws Throwable {
        if (this.constructor != null) {
            return this.constructor.construct(eval, length);
        }
        return super.construct(eval, length);
    }

    protected void copy(Object obj) {
        NativeWrapper dup = (NativeWrapper)obj;
        super.copy(dup);
        dup.fun = this.fun;
        dup.constructor = this.constructor;
    }

    ESObject resinCopy() {
        NativeWrapper dup = (NativeWrapper)this.dup();
        this.copy(dup);
        return dup;
    }

    protected ESObject dup() {
        return new NativeWrapper();
    }
}

