/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es.parser;

import com.caucho.es.ESException;
import com.caucho.es.ESId;
import com.caucho.es.parser.Block;
import com.caucho.es.parser.Expr;
import com.caucho.es.parser.Function;
import com.caucho.es.parser.IdExpr;
import com.caucho.es.parser.JavaClassExpr;
import com.caucho.es.parser.JavaMethod;
import com.caucho.es.parser.JavaTypeExpr;
import com.caucho.es.parser.LiteralExpr;
import com.caucho.es.parser.TypeExpr;
import com.caucho.es.wrapper.ESMethodDescriptor;
import java.io.IOException;
import java.util.ArrayList;

class CallExpr
extends Expr {
    protected Expr term;
    private Expr field;
    private boolean isNew;
    protected boolean isTop;
    protected ArrayList args = new ArrayList();
    protected TypeExpr typeExpr;
    protected boolean isCalculated;
    protected ESMethodDescriptor method;
    static /* synthetic */ Class class$java$lang$String;

    CallExpr(Block block, Expr term, Expr field, boolean isNew) throws ESException {
        super(block);
        this.term = term;
        this.field = field;
        this.isNew = isNew;
        if (term != null) {
            term.setUsed();
        }
        if (field != null) {
            field.setUsed();
        }
        if (term == null || !(term.getTypeExpr() instanceof JavaTypeExpr)) {
            block.function.setCall();
        }
    }

    void exprStatement(Function fun) throws ESException {
        this.isTop = true;
        this.noValue = true;
        fun.addExpr(this);
    }

    int getType() {
        this.calculateType();
        return this.type;
    }

    Expr getTypeExpr() {
        this.calculateType();
        return this.typeExpr;
    }

    private void calculateType() {
        boolean isStatic = false;
        if (this.isCalculated) {
            return;
        }
        this.isCalculated = true;
        Class javaClass = this.term.getJavaClass();
        if (this.term instanceof JavaClassExpr) {
            isStatic = true;
            javaClass = ((JavaClassExpr)this.term).getJavaClass();
        }
        if (javaClass == null || this.field == null || !(this.field instanceof LiteralExpr) || this.term.getType() != 6 && !isStatic) {
            return;
        }
        LiteralExpr lit = (LiteralExpr)this.field;
        String name = lit.getLiteral().toString();
        this.method = JavaMethod.bestMethod(javaClass, name, isStatic, this.args);
        if (this.method != null) {
            Class returnType = this.method.getReturnType();
            if (returnType.equals(Void.TYPE)) {
                this.type = 7;
            } else if (returnType.equals(Integer.TYPE)) {
                this.type = 4;
            } else if (returnType.equals(Double.TYPE)) {
                this.type = 3;
            } else if (returnType.equals(Boolean.TYPE)) {
                this.type = 5;
            } else {
                this.type = 6;
                this.javaType = returnType;
            }
            this.typeExpr = new JavaTypeExpr(this.block, returnType);
        }
    }

    void printBooleanImpl() throws IOException {
        this.printJavaImpl();
    }

    void printInt32Impl() throws IOException {
        this.printJavaImpl();
    }

    void printNumImpl() throws IOException {
        this.printJavaImpl();
    }

    void printImpl() throws IOException {
        Expr expr;
        int i;
        if (this.term instanceof IdExpr && this.field == null && !((IdExpr)this.term).isJavaLocal()) {
            ESId id = ((IdExpr)this.term).getId();
            this.field = new LiteralExpr(this.block, id);
            this.term = null;
        }
        if (this.term != null) {
            if (this.isNew) {
                this.cl.print("_call.doNew(");
            } else {
                this.cl.print("_call.call(");
            }
            this.term.print();
            if (this.field != null) {
                this.cl.print(", ");
                this.field.printStr();
            }
        } else if (this.function.isGlobalScope() && this.withDepth == 0) {
            if (this.isNew) {
                this.cl.print("_call.doNew(_env.global, ");
            } else {
                this.cl.print("_call.call(_env.global, ");
            }
            this.field.printStr();
        } else {
            if (this.isNew) {
                this.cl.print("_call.newScope(");
            } else {
                this.cl.print("_call.callScope(");
            }
            this.field.printStr();
        }
        int argCount = this.function.cl.getCallDepth();
        this.cl.print(", " + argCount);
        for (i = 0; i < this.args.size() && i < 3; ++i) {
            expr = (Expr)this.args.get(i);
            this.cl.print(", ");
            this.function.cl.pushCall();
            expr.print();
        }
        if (this.args.size() >= 3) {
            this.cl.print(", 3");
        }
        for (i = 3; i < this.args.size(); ++i) {
            expr = (Expr)this.args.get(i);
            this.cl.print("+ _call.arg(" + (i + argCount) + ", ");
            this.function.cl.pushCall();
            expr.print();
            this.cl.print(")");
        }
        this.function.cl.popCall(this.args.size());
        this.cl.print(")");
        if (this.isTop) {
            this.cl.println(";");
        }
    }

    void printStringImpl() throws IOException {
        if ((class$java$lang$String == null ? (class$java$lang$String = CallExpr.class$("java.lang.String")) : class$java$lang$String).equals(this.getJavaClass())) {
            this.printJavaImpl();
        } else {
            this.cl.print("String.valueOf(");
            this.printJavaImpl();
            this.cl.print(")");
        }
    }

    void printJavaImpl() throws IOException {
        if (this.method.isStaticVirtual()) {
            this.cl.print(this.method.getMethodClassName());
        } else if (this.term instanceof JavaClassExpr) {
            this.cl.print(this.method.getMethodClassName());
        } else {
            this.term.printJava();
        }
        this.cl.print('.');
        this.cl.print(this.method.getName());
        this.cl.print("(");
        boolean isFirst = true;
        if (this.method.isStaticVirtual()) {
            this.cl.print("(");
            this.printJavaClass(this.method.getDeclaringClass());
            this.cl.print(")");
            isFirst = false;
            this.term.printJava();
        }
        Class[] params = null;
        if (this.method != null) {
            params = this.method.getParameterTypes();
        }
        for (int i = 0; i < this.args.size(); ++i) {
            Expr expr = (Expr)this.args.get(i);
            if (!isFirst) {
                this.cl.print(", ");
            }
            isFirst = false;
            if (params == null) {
                expr.printJava();
                continue;
            }
            if (params[i].equals(class$java$lang$String == null ? CallExpr.class$("java.lang.String") : class$java$lang$String)) {
                expr.printJavaString();
                continue;
            }
            if (!params[i].isPrimitive()) {
                this.cl.print("(");
                this.printJavaClass(params[i]);
                this.cl.print(")");
                expr.printJava();
                continue;
            }
            if (params[i].equals(Integer.TYPE)) {
                expr.printInt32();
                continue;
            }
            if (params[i].equals(Long.TYPE)) {
                expr.printInt64();
                continue;
            }
            if (params[i].equals(Boolean.TYPE)) {
                expr.printBoolean();
                continue;
            }
            if (params[i].equals(Double.TYPE)) {
                expr.printNum();
                continue;
            }
            expr.printJava();
        }
        this.cl.print(")");
        if (this.isTop) {
            this.cl.println(";");
        }
    }

    void addCallParam(Expr param) {
        param.setUsed();
        this.args.add(param);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

