/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.http.distribution;

import com.caucho.http.distribution.DistributedObject;
import com.caucho.http.distribution.Store;
import com.caucho.util.Alarm;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.TempStream;
import com.caucho.vfs.WriteStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;

public class JdbcStore
extends Store {
    protected DataSource dataSource;
    private String loadQuery;
    private String updateQuery;
    private String insertQuery;
    private String invalidateQuery;
    private long maxIdleTime;
    private String tableName = "persistent_session";
    private String blobType;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setMaxIdleTime(long maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    public void setBlobType(String blobType) {
        this.blobType = blobType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws Exception {
        if (this.tableName == null) {
            this.tableName = "persistent_session";
        }
        this.loadQuery = "SELECT data FROM " + this.tableName + " WHERE id=?";
        this.insertQuery = "INSERT into " + this.tableName + " (id,data,mod_time) " + "VALUES(?,?,?)";
        this.updateQuery = "UPDATE " + this.tableName + " SET data=?, mod_time=? WHERE id=?";
        this.invalidateQuery = "DELETE FROM " + this.tableName + " WHERE id=?";
        this.createTable();
        Connection conn = null;
        try {
            if (this.maxIdleTime > 0L) {
                long now = Alarm.getCurrentTime();
                long youngestTime = now - this.maxIdleTime;
                int youngestMinute = (int)(youngestTime / 60000L);
                conn = this.dataSource.getConnection();
                Statement stmt = conn.createStatement();
                int count = stmt.executeUpdate("DELETE FROM " + this.tableName + " WHERE mod_time < " + youngestMinute);
                stmt.close();
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTable() throws SQLException {
        Connection conn = null;
        Statement stmt = null;
        try {
            short dataType;
            String typeName;
            ResultSet rs;
            conn = this.dataSource.getConnection();
            stmt = conn.createStatement();
            try {
                ResultSet rs2 = stmt.executeQuery("SELECT count(*) FROM " + this.tableName);
                if (rs2.next()) {
                    rs2.close();
                    stmt.close();
                    return;
                }
            }
            catch (SQLException e) {
                // empty catch block
            }
            String blob = this.blobType;
            DatabaseMetaData md = conn.getMetaData();
            if (blob == null) {
                rs = md.getTypeInfo();
                while (rs.next()) {
                    typeName = rs.getString("TYPE_NAME");
                    dataType = rs.getShort("DATA_TYPE");
                    if (dataType != -4 || blob != null) continue;
                    blob = typeName;
                }
                rs.close();
            }
            if (blob == null) {
                rs = md.getTypeInfo();
                while (rs.next()) {
                    typeName = rs.getString("TYPE_NAME");
                    dataType = rs.getShort("DATA_TYPE");
                    if (dataType != 2004 || blob != null) continue;
                    blob = typeName;
                }
                rs.close();
            }
            if (blob == null) {
                rs = md.getTypeInfo();
                while (rs.next()) {
                    if (rs.getShort("DATA_TYPE") != -3 || blob != null) continue;
                    blob = rs.getString("TYPE_NAME");
                }
                rs.close();
            }
            if (blob == null) {
                blob = "blob";
            }
            CharBuffer cb = CharBuffer.allocate();
            cb.append("CREATE TABLE " + this.tableName + " (");
            cb.append("  id varchar(64) NOT NULL,");
            cb.append("  data " + blob + ",");
            cb.append("  mod_time INTEGER,");
            cb.append("  PRIMARY KEY(id)");
            cb.append(")");
            String sql = cb.close();
            stmt = conn.createStatement();
            try {
                stmt.executeUpdate(sql);
            }
            catch (SQLException e) {
                dbg.log(e);
            }
            if (this.maxIdleTime > 0L) {
                long now = Alarm.getCurrentTime();
                long youngestTime = now - this.maxIdleTime;
                int youngestMinute = (int)(youngestTime / 60000L);
                int count = stmt.executeUpdate("DELETE FROM " + this.tableName + " WHERE mod_time < " + youngestMinute);
            }
            stmt.close();
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(DistributedObject obj) throws Exception {
        Connection conn = null;
        try {
            conn = this.dataSource.getConnection();
            PreparedStatement stmt = conn.prepareStatement(this.loadQuery);
            stmt.setString(1, this.prefix + ';' + obj.getId());
            ResultSet rs = stmt.executeQuery();
            boolean validLoad = false;
            if (rs.next()) {
                InputStream is = rs.getBinaryStream(1);
                if (dbg.canWrite()) {
                    dbg.log("load jdbc: " + obj.getId());
                }
                validLoad = this.load(obj, is, -1);
                is.close();
            } else if (dbg.canWrite()) {
                dbg.log("no session loaded for " + obj.getId());
            }
            rs.close();
            stmt.close();
            boolean bl = validLoad;
            return bl;
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void store(DistributedObject obj) throws Exception {
        TempStream tempStream;
        Connection conn;
        block14: {
            block12: {
                block13: {
                    conn = null;
                    tempStream = new TempStream(null);
                    try {
                        ReadStream is;
                        PreparedStatement stmt;
                        int length;
                        block10: {
                            block11: {
                                WriteStream os = new WriteStream(tempStream);
                                JdbcStore.store(obj, os);
                                os.close();
                                os = null;
                                length = tempStream.getLength();
                                conn = this.dataSource.getConnection();
                                int count = 0;
                                try {
                                    stmt = conn.prepareStatement(this.updateQuery);
                                    is = tempStream.openRead();
                                    stmt.setBinaryStream(1, (InputStream)is, length);
                                    long now = Alarm.getCurrentTime();
                                    int minutes = (int)(now / 60000L);
                                    stmt.setInt(2, minutes);
                                    stmt.setString(3, this.prefix + ';' + obj.getId());
                                    count = stmt.executeUpdate();
                                    ((InputStream)is).close();
                                    stmt.close();
                                    if (count <= 0) break block10;
                                    if (!dbg.canWrite()) break block11;
                                    dbg.log("update jdbc: " + obj.getId() + " length:" + length);
                                }
                                catch (SQLException e) {
                                    dbg.log(e);
                                    break block10;
                                }
                            }
                            Object var13_13 = null;
                            if (conn == null) break block12;
                            break block13;
                        }
                        try {
                            stmt = conn.prepareStatement(this.insertQuery);
                            stmt.setString(1, this.prefix + ';' + obj.getId());
                            is = tempStream.openRead();
                            stmt.setBinaryStream(2, (InputStream)is, length);
                            stmt.setInt(3, (int)(Alarm.getCurrentTime() / 60000L));
                            stmt.executeUpdate();
                            ((InputStream)is).close();
                            stmt.close();
                        }
                        catch (SQLException e) {
                            dbg.log(e);
                        }
                        if (dbg.canWrite()) {
                            dbg.log("insert jdbc: " + obj.getId() + " length:" + length);
                        }
                        break block14;
                    }
                    catch (Throwable throwable) {
                        Object var13_15 = null;
                        if (conn != null) {
                            conn.close();
                        }
                        tempStream.destroy();
                        throw throwable;
                    }
                }
                conn.close();
            }
            tempStream.destroy();
            return;
        }
        Object var13_14 = null;
        if (conn != null) {
            conn.close();
        }
        tempStream.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(DistributedObject obj) throws Exception {
        Connection conn = null;
        try {
            conn = this.dataSource.getConnection();
            PreparedStatement stmt = conn.prepareStatement(this.invalidateQuery);
            stmt.setString(1, this.prefix + ';' + obj.getId());
            stmt.executeUpdate();
            stmt.close();
            if (dbg.canWrite()) {
                dbg.log("invalidate jdbc: " + obj.getId());
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }
}

