/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.http.filter;

import com.caucho.server.http.CauchoResponse;
import com.caucho.server.http.QServletOutputStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.VfsStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class CauchoResponseWrapper
extends HttpServletResponseWrapper
implements CauchoResponse {
    protected HttpServletResponse _response;
    protected VfsStream _vfsStream;
    protected WriteStream _writeStream;
    protected WriteStream _stream;
    private QServletOutputStream _os = new QServletOutputStream();
    private boolean _hasOutputStream;
    private boolean _hasError;

    public CauchoResponseWrapper(HttpServletResponse response) {
        super(response);
        this._os.setCloseChildOnClose(true);
        this.init(response);
    }

    public void init(HttpServletResponse response) {
        this._response = response;
        this._stream = null;
        this._hasError = false;
    }

    public void close() throws IOException {
        if (this._stream == this._writeStream && this._stream != null) {
            this._stream.setDisableClose(false);
            this._stream.close();
        }
    }

    public ServletResponse getResponse() {
        return this._response;
    }

    public void setContentType(String value) {
        this._response.setContentType(value);
        if (this._stream == null) {
            try {
                this.getStream();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this._stream == this._writeStream && this._stream != null) {
            try {
                this._stream.setEncoding(this.getCharacterEncoding());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    public WriteStream getStream() throws IOException {
        if (this._stream != null) {
            return this._stream;
        }
        if (this._response instanceof CauchoResponse) {
            this._stream = ((CauchoResponse)this._response).getStream();
        } else {
            if (this._vfsStream == null) {
                this._vfsStream = new VfsStream();
            }
            this._vfsStream.init(null, (OutputStream)this._response.getOutputStream());
            if (this._writeStream == null) {
                this._writeStream = new WriteStream();
                this._writeStream.setReuseBuffer(true);
            }
            this._stream = this._writeStream;
            this._stream.init(this._vfsStream);
            String charset = this.getCharacterEncoding();
            this._stream.setEncoding(charset);
        }
        return this._stream;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        this._os.init(this.getStream());
        return this._os;
    }

    public PrintWriter getWriter() throws IOException {
        return this.getStream().getPrintWriter();
    }

    public void setStream(WriteStream stream) {
        this._stream = stream;
    }

    public void flushBuffer() throws IOException {
        if (this._stream != null) {
            this._stream.flush();
        }
        this._response.flushBuffer();
    }

    public void resetBuffer() {
        if (this._stream != null) {
            this._stream.clearWrite();
        }
        this._response.resetBuffer();
    }

    public void clearBuffer() {
        this.resetBuffer();
    }

    public void setLocale(Locale locale) {
        this._response.setLocale(locale);
        if (this._stream == this._writeStream && this._stream != null) {
            try {
                this._stream.setLocale(this._response.getLocale());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    public String getChain() {
        return null;
    }

    public String getHeader(String key) {
        return null;
    }

    public StreamImpl startChaining() {
        return null;
    }

    public boolean disableHeaders(boolean disable) {
        return false;
    }

    public int getRemaining() {
        if (this._response instanceof CauchoResponse) {
            return ((CauchoResponse)this._response).getRemaining();
        }
        return 0;
    }

    public void setForbidForward(boolean forbid) {
    }

    public boolean getForbidForward() {
        return false;
    }

    public void setHasError(boolean hasError) {
        this._hasError = hasError;
    }

    public boolean hasError() {
        return this._hasError;
    }

    public void killCache() {
        if (this._response instanceof CauchoResponse) {
            ((CauchoResponse)this._response).killCache();
        }
    }

    public void setSessionId(String id) {
        if (this._response instanceof CauchoResponse) {
            ((CauchoResponse)this._response).setSessionId(id);
        }
    }
}

