/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.http.filter;

import java.io.IOException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.transaction.UserTransaction;

public class TransactionFilter
implements Filter {
    private UserTransaction userTransaction;

    public void init(FilterConfig config) throws ServletException {
        try {
            Context comp = (Context)new InitialContext().lookup("java:comp");
            this.userTransaction = (UserTransaction)comp.lookup("UserTransaction");
        }
        catch (NamingException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain nextFilter) throws ServletException, IOException {
        boolean hasCommit = false;
        try {
            this.userTransaction.begin();
            nextFilter.doFilter(request, response);
            hasCommit = true;
            this.userTransaction.commit();
        }
        catch (ServletException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServletException(e);
        }
        finally {
            if (!hasCommit) {
                this.rollback();
            }
        }
    }

    private void rollback() throws ServletException {
        try {
            this.userTransaction.rollback();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void destroy() {
    }
}

