/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.http.filter;

import com.caucho.http.filter.CauchoResponseWrapper;
import com.caucho.server.http.Application;
import com.caucho.server.http.CauchoRequest;
import com.caucho.server.http.CauchoResponse;
import com.caucho.util.DynamicClassLoader;
import com.caucho.util.L10N;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.MergePath;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TempStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.Xml;
import com.caucho.xml.XmlUtil;
import com.caucho.xpath.XPath;
import com.caucho.xpath.XPathException;
import com.caucho.xsl.AbstractStylesheetFactory;
import com.caucho.xsl.StyleScript;
import com.caucho.xsl.TransformerImpl;
import com.caucho.xsl.Xsl;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Templates;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public class XsltFilter
implements Filter {
    private static final L10N L = new L10N(class$com$caucho$http$filter$XsltFilter == null ? (class$com$caucho$http$filter$XsltFilter = XsltFilter.class$("com.caucho.http.filter.XsltFilter")) : class$com$caucho$http$filter$XsltFilter);
    private static WriteStream dbg = LogStream.open("/caucho.com/filters/xslt");
    private String _mimeType = "x-application/xslt";
    private MergePath _stylePath;
    static /* synthetic */ Class class$com$caucho$http$filter$XsltFilter;

    public void setMimeType(String mimeType) {
        this._mimeType = mimeType;
    }

    public void init(FilterConfig config) throws ServletException {
        this._stylePath = new MergePath();
        this._stylePath.addMergePath(((Application)config.getServletContext()).getAppDir());
        DynamicClassLoader loader = (DynamicClassLoader)Thread.currentThread().getContextClassLoader();
        this._stylePath.addClassPath(loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain nextFilter) throws ServletException, IOException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        XsltResponse xsltResponse = new XsltResponse(res);
        try {
            nextFilter.doFilter((ServletRequest)req, (ServletResponse)xsltResponse);
        }
        finally {
            xsltResponse.finish(req, res);
        }
    }

    public void destroy() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class XsltTempStream
    extends StreamImpl {
        private ServletResponse _response;
        private OutputStream _os;
        private TempStream _tempStream;

        XsltTempStream(ServletResponse response) {
            this._response = response;
        }

        void setChaining() {
            if (this._os != null) {
                throw new IllegalStateException(L.l("setContentType for XSLT chaining must be before any data."));
            }
            this._tempStream = new TempStream(null);
            this._tempStream.openWrite();
            this._os = new WriteStream(this._tempStream);
        }

        TempStream getTempStream() throws IOException {
            if (this._tempStream != null) {
                this._os.close();
                this._os = null;
            }
            return this._tempStream;
        }

        public boolean canWrite() {
            return true;
        }

        public void write(byte[] buffer, int offset, int length, boolean isEnd) throws IOException {
            if (this._os == null) {
                this._os = this._response instanceof CauchoResponse ? ((CauchoResponse)this._response).getStream() : this._response.getOutputStream();
            }
            this._os.write(buffer, offset, length);
        }

        public void flush() throws IOException {
            if (this._os == null) {
                this._os = this._response instanceof CauchoResponse ? ((CauchoResponse)this._response).getStream() : this._response.getOutputStream();
            }
            this._os.flush();
        }
    }

    class XsltResponse
    extends CauchoResponseWrapper {
        private XsltTempStream _xsltStream;
        private String _chainingType;

        XsltResponse(HttpServletResponse response) {
            super(response);
        }

        public void setContentLength(int length) {
        }

        public void setContentType(String contentType) {
            super.setContentType(contentType);
            int p = contentType.indexOf(59);
            if (p > 0) {
                contentType = contentType.substring(0, p);
            }
            if (contentType.equals("x-application/xslt") || contentType.equals("x-application/xsl") || contentType.equals("x-application/stylescript")) {
                this._chainingType = contentType;
                if (this._xsltStream == null) {
                    this._xsltStream = new XsltTempStream((ServletResponse)this._response);
                }
                this._xsltStream.setChaining();
            }
        }

        public WriteStream getStream() throws IOException {
            if (this._stream != null) {
                return this._stream;
            }
            if (this._xsltStream == null) {
                this._xsltStream = new XsltTempStream((ServletResponse)this._response);
            }
            this._stream = this._writeStream = new WriteStream();
            this._stream.init(this._xsltStream);
            String charset = this.getCharacterEncoding();
            this._stream.setEncoding(charset);
            return this._stream;
        }

        public void flushBuffer() throws IOException {
            if (this._stream != null) {
                this._stream.flush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finish(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
            try {
                if (this._stream != null) {
                    this._stream.flush();
                }
                if (this._chainingType == null) {
                    return;
                }
                TempStream ts = this._xsltStream.getTempStream();
                Document doc = null;
                ReadStream is = ts.openRead(true);
                Path userPath = Vfs.lookup();
                if (req instanceof CauchoRequest) {
                    userPath.setUserPath(((CauchoRequest)req).getPageURI());
                } else {
                    userPath.setUserPath(req.getRequestURI());
                }
                is.setPath(userPath);
                try {
                    doc = new Xml().parseDocument(is);
                }
                finally {
                    is.close();
                }
                String href = (String)req.getAttribute("caucho.xsl.stylesheet");
                if (href == null) {
                    href = this.getStylesheetHref(doc);
                }
                if (href == null) {
                    href = "default.xsl";
                }
                if (dbg.canWrite()) {
                    dbg.log("formatting with " + href);
                }
                Templates stylesheet = null;
                AbstractStylesheetFactory factory = this._chainingType.equals("x-application/stylescript") ? new StyleScript() : new Xsl();
                factory.setStylePath(XsltFilter.this._stylePath);
                stylesheet = factory.newTemplates(href);
                TransformerImpl transformer = null;
                transformer = (TransformerImpl)stylesheet.newTransformer();
                String mediaType = transformer.getOutputProperty("media-type");
                String encoding = transformer.getOutputProperty("encoding");
                String method = transformer.getOutputProperty("method");
                if (encoding == null && method != null && method.equals("xml")) {
                    encoding = "UTF-8";
                }
                if (encoding != null) {
                    if (mediaType == null) {
                        mediaType = "text/html";
                    }
                    res.setContentType(mediaType + "; charset=" + encoding);
                } else if (mediaType != null) {
                    res.setContentType(mediaType);
                } else {
                    res.setContentType("text/html");
                }
                if (encoding == null) {
                    encoding = "ISO-8859-1";
                }
                transformer.setOutputProperty("encoding", encoding);
                ArrayList params = (ArrayList)transformer.getProperty("caucho.global.param");
                for (int i = 0; params != null && i < params.size(); ++i) {
                    String param = (String)params.get(i);
                    transformer.setParameter(param, req.getParameter(param));
                }
                transformer.transform((Node)doc, (OutputStream)res.getOutputStream());
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }

        private String getStylesheetHref(Document doc) throws XPathException {
            ProcessingInstruction pi = null;
            pi = (ProcessingInstruction)XPath.find("//processing-instruction('xml-stylesheet')", doc);
            if (pi == null) {
                return null;
            }
            String value = pi.getNodeValue();
            return XmlUtil.getPIAttribute(value, "href");
        }
    }
}

