/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.http.servlet;

import com.caucho.http.distribution.DistributionServer;
import com.caucho.server.http.Application;
import com.caucho.server.http.CauchoResponse;
import com.caucho.server.http.ServletServer;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.util.QDate;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.ReadWritePair;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LoadBalanceServlet
extends GenericServlet {
    protected static WriteStream dbg = LogStream.open("/caucho.com/http/load-balance");
    static L10N L = new L10N(class$com$caucho$http$servlet$LoadBalanceServlet == null ? (class$com$caucho$http$servlet$LoadBalanceServlet = LoadBalanceServlet.class$("com.caucho.http.servlet.LoadBalanceServlet")) : class$com$caucho$http$servlet$LoadBalanceServlet);
    static int[] decode = new int[128];
    private String groupId;
    private DistributionServer[] srunGroup;
    private int roundRobin;
    protected QDate calendar = new QDate();
    private boolean _isEscapedURL;
    private String _sessionPrefix;
    private String _altSessionPrefix;
    static /* synthetic */ Class class$com$caucho$http$servlet$LoadBalanceServlet;

    public void setEscapedURL(boolean isEscapedURL) {
        this._isEscapedURL = isEscapedURL;
    }

    public void init() throws ServletException {
        Application app = (Application)this.getServletContext();
        ServletServer server = app.getServer();
        this.groupId = this.getInitParameter("srun-group");
        if (this.groupId == null) {
            this.groupId = "";
        }
        this.srunGroup = server.getDistributionServerGroup(this.groupId);
        if (this.srunGroup == null) {
            throw new ServletException("LoadBalanceServlet needs valid srun-group");
        }
        this._sessionPrefix = server.getSessionPrefix();
        this._altSessionPrefix = server.getAlternateSessionPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        int index;
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        PrintWriter out = res.getWriter();
        int length = this.srunGroup.length;
        int startIndex = this.roundRobin;
        this.roundRobin = (this.roundRobin + 1) % length;
        for (int i = 0; i < length && (this.srunGroup[index = this.roundRobin].isDead() || this.srunGroup[index].isBackup()); ++i) {
            this.roundRobin = (this.roundRobin + 1) % length;
        }
        String sessionId = req.getRequestedSessionId();
        ReadWritePair pair = null;
        DistributionServer srun = null;
        if (sessionId != null) {
            int secondaryIndex;
            int primaryIndex = LoadBalanceServlet.decode(sessionId.charAt(0));
            srun = this.srunGroup[primaryIndex % length];
            pair = srun.openRecycle();
            if (pair == null) {
                pair = srun.open();
            }
            if (pair == null && length > 1 && (pair = (srun = this.srunGroup[(primaryIndex + (secondaryIndex = LoadBalanceServlet.decode(sessionId.charAt(1)) % (length - 1)) + 1) % length]).openRecycle()) == null) {
                pair = srun.open();
            }
        }
        int bestCost = Integer.MAX_VALUE;
        if (pair == null) {
            int index2;
            int i;
            for (i = 0; i < length; ++i) {
                int cost;
                index2 = (startIndex + i) % length;
                DistributionServer server = this.srunGroup[index2];
                if (server.isBackup() || server.isDead() || (cost = server.getActiveCount()) >= bestCost) continue;
                srun = server;
                bestCost = cost;
            }
            if (srun != null && (pair = srun.openRecycle()) == null) {
                pair = srun.open();
            }
            if (pair == null) {
                for (i = 0; i < length; ++i) {
                    index2 = (startIndex + i) % length;
                    srun = this.srunGroup[index2];
                    if (srun.isBackup() && (sessionId == null || i != 0)) continue;
                    pair = srun.openRecycle();
                    if (pair == null) {
                        pair = srun.open();
                    }
                    if (pair != null) break;
                }
            }
            if (pair == null) {
                for (i = 0; i < length; ++i) {
                    index2 = (startIndex + i) % length;
                    srun = this.srunGroup[index2];
                    pair = srun.openRecycle();
                    if (pair == null) {
                        pair = srun.open();
                    }
                    if (pair != null) break;
                }
            }
            if (pair == null) {
                for (i = 0; i < length; ++i) {
                    index2 = (startIndex + i) % length;
                    srun = this.srunGroup[index2];
                    srun.wake();
                    pair = srun.openRecycle();
                    if (pair == null) {
                        pair = srun.open();
                    }
                    if (pair != null) break;
                }
            }
            if (pair == null) {
                res.sendError(503);
                return;
            }
        }
        ReadStream rs = pair.getReadStream();
        WriteStream ws = pair.getWriteStream();
        boolean keepalive = false;
        try {
            if (this.handleRequest(req, res, rs, ws, srun.getIndex())) {
                keepalive = true;
            }
            Object var17_21 = null;
            if (keepalive) {
                if (dbg.canWrite()) {
                    dbg.log("srun-lb keepalive");
                }
                srun.free(pair);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var17_22 = null;
            if (!keepalive) {
                ws.close();
                rs.close();
                throw throwable;
            }
            if (dbg.canWrite()) {
                dbg.log("srun-lb keepalive");
            }
            srun.free(pair);
            throw throwable;
        }
        ws.close();
        rs.close();
    }

    private DistributionServer getSrun(int roundRobin, HttpServletRequest req) {
        int length = this.srunGroup.length;
        String sessionId = req.getRequestedSessionId();
        if (sessionId != null) {
            roundRobin = sessionId.charAt(0) - 97;
        }
        for (int i = 0; i < length; ++i) {
            int index = (roundRobin + i) % length;
            DistributionServer srun = this.srunGroup[index];
            if (srun.isDead()) continue;
            return srun;
        }
        return null;
    }

    private boolean handleRequest(HttpServletRequest req, HttpServletResponse res, ReadStream rs, WriteStream ws, int index) throws ServletException, IOException {
        int sublen;
        int code;
        boolean hasHeader;
        this.writeRequestString(ws, 117, "Resin");
        CharBuffer cb = CharBuffer.allocate();
        cb.append(req.getServerName());
        cb.append(':');
        cb.append(req.getServerPort());
        this.writeRequestString(ws, 102, cb.close());
        this.writeRequestInt(ws, 103, req.getServerPort());
        this.writeRequestString(ws, 104, req.getRemoteHost());
        this.writeRequestString(ws, 105, req.getRemoteAddr());
        String remoteUser = req.getRemoteUser();
        if (remoteUser != null) {
            this.writeRequestString(ws, 109, remoteUser);
        }
        this.writeRequestString(ws, 100, req.getMethod());
        if (req.isRequestedSessionIdFromUrl()) {
            if (this._altSessionPrefix != null) {
                this.writeRequestString(ws, 111, this._altSessionPrefix + req.getRequestedSessionId() + req.getRequestURI());
            } else {
                this.writeRequestString(ws, 111, req.getRequestURI() + this._sessionPrefix + req.getRequestedSessionId());
            }
        } else if (!this._isEscapedURL) {
            this.writeRequestString(ws, 111, req.getRequestURI());
        } else {
            this.writeRequestString(ws, 111, req.getServletPath());
        }
        this.writeRequestString(ws, 101, req.getQueryString());
        this.writeRequestString(ws, 99, req.getProtocol());
        this.writeRequestInt(ws, 115, index);
        if (req.isSecure()) {
            this.writeRequestString(ws, 114, "");
        }
        Enumeration e = req.getHeaderNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = req.getHeader(name);
            this.writeRequestString(ws, 72, name);
            this.writeRequestString(ws, 86, value);
        }
        ServletInputStream is = req.getInputStream();
        TempBuffer tempBuf = TempBuffer.allocate();
        byte[] buf = tempBuf.getBuffer();
        int len = 0;
        boolean isFirst = true;
        WriteStream os = ((CauchoResponse)res).getStream();
        CharBuffer key = new CharBuffer();
        CharBuffer value = new CharBuffer();
        boolean bl = hasHeader = !req.getProtocol().equals("HTTP/0.9");
        while ((len = is.read(buf, 0, buf.length)) > 0) {
            this.writeRequestData(ws, 68, buf, len);
            if (!isFirst) {
                while (true) {
                    code = rs.read();
                    sublen = (rs.read() << 16) + (rs.read() << 8) + rs.read();
                    if (code == 65) {
                        if (sublen <= 0) break;
                        rs.skip(sublen);
                        break;
                    }
                    if (code == 83 && hasHeader) {
                        value.clear();
                        rs.readAll(value, sublen);
                        continue;
                    }
                    if (code == 72 && hasHeader) {
                        key.clear();
                        rs.readAll(key, sublen);
                        code = rs.read();
                        sublen = (rs.read() << 16) + (rs.read() << 8) + rs.read();
                        value.clear();
                        rs.readAll(value, sublen);
                        res.addHeader(key.toString(), value.toString());
                        continue;
                    }
                    if (code == 68) {
                        rs.writeToStream(os, sublen);
                        continue;
                    }
                    if (code == 90 || code == 88 || code == -1) {
                        TempBuffer.free(tempBuf);
                        return code == 90;
                    }
                    rs.skip(sublen);
                }
            }
            isFirst = false;
        }
        TempBuffer.free(tempBuf);
        this.writeRequestData(ws, 90);
        while (true) {
            code = rs.read();
            sublen = (rs.read() << 16) + (rs.read() << 8) + rs.read();
            if (code == 68) {
                rs.writeToStream(os, sublen);
                continue;
            }
            if (code == 83 && hasHeader) {
                value.clear();
                rs.readAll(value, sublen);
                int status = 0;
                for (int i = 9; i < 12; ++i) {
                    status = 10 * status + value.charAt(i) - 48;
                }
                res.setStatus(status, value.substring(13));
                continue;
            }
            if (code == 72 && hasHeader) {
                key.clear();
                rs.readAll(key, sublen);
                code = rs.read();
                sublen = (rs.read() << 16) + (rs.read() << 8) + rs.read();
                value.clear();
                rs.readAll(value, sublen);
                res.addHeader(key.toString(), value.toString());
                continue;
            }
            if (code == 90 || code == 88 || code < 0) {
                return code == 90;
            }
            rs.skip(sublen);
        }
    }

    private void writeRequestString(WriteStream s, int code, String string) throws IOException {
        if (string == null) {
            string = "";
        }
        int length = string.length();
        s.write(code);
        s.write(length >> 16);
        s.write(length >> 8);
        s.write(length);
        s.print(string);
    }

    private void writeRequestInt(WriteStream s, int code, int value) throws IOException {
        CharBuffer cb = CharBuffer.allocate();
        cb.append(value);
        int length = cb.length();
        s.write(code);
        s.write(length >> 16);
        s.write(length >> 8);
        s.write(length);
        s.print(cb.getBuffer(), 0, cb.getLength());
        cb.free();
    }

    private void writeRequestData(WriteStream s, int code) throws IOException {
        s.write(code);
        s.write(0);
        s.write(0);
        s.write(0);
    }

    private void writeRequestData(WriteStream os, int code, byte[] data, int length) throws IOException {
        os.write(code);
        os.write(length >> 16);
        os.write(length >> 8);
        os.write(length);
        os.write(data, 0, length);
    }

    private static char convert(long code) {
        if ((code &= 0x3FL) < 26L) {
            return (char)(97L + code);
        }
        if (code < 52L) {
            return (char)(65L + code - 26L);
        }
        if (code < 62L) {
            return (char)(48L + code - 52L);
        }
        if (code == 62L) {
            return '_';
        }
        return '-';
    }

    private static int decode(int code) {
        return decode[code & 0x7F];
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        for (int i = 0; i < 64; ++i) {
            LoadBalanceServlet.decode[LoadBalanceServlet.convert((long)((long)i))] = i;
        }
    }
}

