/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jslib;

import com.caucho.sql.DBPool;
import com.caucho.util.Exit;
import com.caucho.util.ExitListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.naming.InitialContext;
import javax.sql.DataSource;

public class Database {
    private DataSource dataSource;
    private Connection conn;
    private Statement stmt;
    private ResultSet rs;
    private static ExitListener exitHandler = new ExitListener(){

        public void handleExit(Object o) {
            Database db = (Database)o;
            try {
                db.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    };

    public Database(String name) throws Exception {
        InitialContext cxt = null;
        try {
            cxt = new InitialContext();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (cxt != null) {
                this.dataSource = (DataSource)cxt.lookup(name);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.dataSource == null && cxt != null) {
                this.dataSource = (DataSource)cxt.lookup("java:comp/env/" + name);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.dataSource != null && cxt != null) {
                this.dataSource = (DataSource)cxt.lookup("java:comp/env/jdbc/" + name);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.dataSource == null) {
            this.dataSource = DBPool.getPool(name);
        }
        if (this.dataSource == null) {
            throw new SQLException("no data source: " + name);
        }
        Exit.addExit(exitHandler, this);
    }

    public ResultSet query(String sql) throws SQLException {
        if (this.rs != null) {
            ResultSet rs = this.rs;
            this.rs = null;
            rs.close();
        }
        Statement stmt = this.getStatement();
        this.rs = stmt.executeQuery(sql);
        return this.rs;
    }

    public int update(String sql) throws SQLException {
        if (this.rs != null) {
            ResultSet rs = this.rs;
            this.rs = null;
            rs.close();
        }
        Statement stmt = this.getStatement();
        int value = stmt.executeUpdate(sql);
        this.close();
        return value;
    }

    public DataSource getDataSource() throws SQLException {
        return this.dataSource;
    }

    public Connection getConnection() throws SQLException {
        if (this.conn == null) {
            this.conn = this.dataSource.getConnection();
        }
        return this.conn;
    }

    public Statement getStatement() throws SQLException {
        if (this.stmt == null) {
            Connection conn = this.getConnection();
            this.stmt = conn.createStatement();
        }
        return this.stmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        block5: {
            Connection conn2;
            try {
                if (this.rs != null) {
                    ResultSet rs = this.rs;
                    this.rs = null;
                    rs.close();
                }
                if (this.stmt != null) {
                    Statement stmt = this.stmt;
                    this.stmt = null;
                    stmt.close();
                }
                Object var3_2 = null;
                if (this.conn == null) break block5;
                conn2 = this.conn;
                this.conn = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (this.conn != null) {
                    Connection conn2 = this.conn;
                    this.conn = null;
                    conn2.close();
                }
                throw throwable;
            }
            conn2.close();
            {
            }
        }
    }
}

