/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp;

import com.caucho.es.ESParseException;
import com.caucho.es.Resin;
import com.caucho.es.Script;
import com.caucho.es.parser.Parser;
import com.caucho.jsp.JavaScriptPage;
import com.caucho.jsp.JspGenerator;
import com.caucho.jsp.JspParseException;
import com.caucho.jsp.JspServletConfig;
import com.caucho.jsp.Page;
import com.caucho.jsp.TagInstance;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.CharScanner;
import com.caucho.util.StringCharCursor;
import com.caucho.vfs.Depend;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.MergePath;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.CauchoElement;
import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.VariableInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class JavaScriptGenerator
extends JspGenerator {
    static WriteStream dbg = LogStream.open("/caucho.com/jsp/js");
    private Path path;
    private Path jsPath;
    private String className;
    HashMap beans;
    ClassLoader loader;
    private ArrayList imports = new ArrayList();
    private ArrayList tagScope = new ArrayList();
    private int tagId;
    private int uniqueId;
    private static CharScanner commaDelimScanner = new CharScanner(" \t\n\r,");

    JavaScriptGenerator() {
    }

    void init(ClassLoader parent, String name) {
        super.init(parent, name);
        this.className = "_jsp." + name;
        this.beans = new HashMap();
        this.loader = parent;
    }

    WriteStream openWriteStream(Path path) throws IOException {
        this.path = path;
        this.jsPath = this.getClassDir();
        this.jsPath = this.jsPath.lookup(this.className.replace('.', '/') + ".js");
        this.jsPath.getParent().mkdirs();
        this.os = this.jsPath.openWrite();
        this.os.setPath(path);
        if (this.charEncoding != null) {
            this.os.setEncoding(this.charEncoding);
        }
        return this.os;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void processPageDirective(String key, String value) throws Exception {
        if (!key.equals("import")) {
            super.processPageDirective(key, value);
            return;
        } else {
            StringCharCursor cursor = new StringCharCursor(value);
            CharBuffer cb = new CharBuffer();
            while (cursor.current() != '\uffff') {
                commaDelimScanner.skip(cursor);
                cb.clear();
                char ch = commaDelimScanner.scan(cursor, cb);
                if (cb.length() != 0) {
                    this.addImport(cb.toString());
                    continue;
                }
                if (ch == '\uffff') continue;
                throw new IOException(L.l("illegal `import' directive"));
            }
        }
    }

    protected void addImport(String name) {
        if (!this.imports.contains(name)) {
            this.imports.add(name);
        }
    }

    protected void generateClassHeader(Document doc) throws IOException {
        for (int i = 0; i < this.imports.size(); ++i) {
            this.println("import " + this.imports.get(i) + ";");
        }
        this.println("var out : Packages.javax.servlet.jsp.JspWriter;");
        this.println("var out = _jsp_out;");
    }

    protected void generatePageHeader(Document doc) throws IOException {
        this.println("function _jspService(request, response) {");
        this.pushDepth();
    }

    protected void printTry(Document doc) throws IOException {
        if (this.hasTags()) {
            this.println("try {");
            this.pushDepth();
        }
    }

    protected void generateText(String text) throws IOException {
        this.print("out.print(\"");
        int length = text.length();
        block6: for (int i = 0; i < length; ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '\"': {
                    this.print("\\\"");
                    continue block6;
                }
                case '\\': {
                    this.print("\\\\");
                    continue block6;
                }
                case '\n': {
                    this.print("\\n");
                    continue block6;
                }
                case '\r': {
                    this.print("\\r");
                    continue block6;
                }
                default: {
                    this.print(ch);
                }
            }
        }
        this.println("\");");
    }

    protected void generateEval(String text) throws Exception {
        int length = text.length();
        this.print("out.print((");
        boolean hasSlashes = false;
        for (int i = 0; i < length; ++i) {
            char ch = text.charAt(i);
            this.os.print(ch);
            if (ch == '/' && i + 1 < length && text.charAt(i + 1) == '/') {
                hasSlashes = true;
            }
            if (ch != '\n') continue;
            ++this.destLine;
            hasSlashes = false;
        }
        if (hasSlashes) {
            this.println();
        }
        this.println(") @ String);");
    }

    protected void generateScriptlet(String text) throws Exception {
        this.generateRawCode(text);
    }

    protected void generateDeclaration(String text) throws Exception {
        this.generateRawCode(text);
    }

    protected void generateRawCode(String text) throws Exception {
        int length = text.length();
        boolean hasSlashes = false;
        boolean needsSemi = false;
        for (int i = 0; i < length; ++i) {
            char ch = text.charAt(i);
            this.os.print(ch);
            if (ch == '/' && i + 1 < length && text.charAt(i + 1) == '/') {
                hasSlashes = true;
            }
            if (ch == '\n') {
                hasSlashes = false;
                needsSemi = false;
                ++this.destLine;
                continue;
            }
            if (ch == ';') {
                needsSemi = false;
                continue;
            }
            if (ch == ' ' || ch == '\t') continue;
            needsSemi = true;
        }
        if (hasSlashes) {
            this.println(";");
        } else if (needsSemi) {
            this.print(";");
        }
    }

    protected void generateInclude(Element elt) throws Exception {
        String page = elt.getAttribute("page");
        if (page.equals("")) {
            throw this.error(L.l("{0} needs a `{1}' attribute.", (Object)"jsp:include", "page"));
        }
        if (this.hasRuntimeAttribute(page)) {
            this.print("pageContext.include(");
            this.print(this.getRuntimeAttribute(page));
            this.println(");");
        } else {
            this.print("pageContext.include(\"");
            this.print(page);
            this.println("\");");
        }
    }

    protected void generateForward(Element elt) throws Exception {
        String page = elt.getAttribute("page");
        if (page.equals("")) {
            throw this.error(L.l("{0} needs a `{1}' attribute.", (Object)"jsp:forward", "page"));
        }
        if (this.hasRuntimeAttribute(page)) {
            this.print("pageContext.forward(");
            this.print(this.getRuntimeAttribute(page));
            this.println(");");
        } else {
            this.print("pageContext.forward(\"");
            this.print(page);
            this.println("\");");
        }
        this.println("if (true) return;");
    }

    protected void generateTag(Element elt) throws Exception {
        if (elt.getNodeName().equals("jsp:useBean")) {
            this.generateUseBean(elt);
        } else if (elt.getNodeName().equals("jsp:getProperty")) {
            this.generateGetProperty(elt);
        } else if (elt.getNodeName().equals("jsp:setProperty")) {
            this.generateSetProperty(elt);
        }
    }

    private void generateUseBean(Element elt) throws Exception {
        String id = elt.getAttribute("id");
        if (id.equals("")) {
            throw this.error(L.l("{0} needs an `{1}' attribute", (Object)"jsp:useBean", "id"));
        }
        if (this.beans.get(id) != null) {
            throw this.error(L.l("duplicate jsp:useBean `{0}'", id));
        }
        this.beans.put(id, id);
        String className = elt.getAttribute("class");
        String beanName = elt.getAttribute("beanName");
        String scope = elt.getAttribute("scope");
        String context = null;
        if (scope.equals("") || scope.equals("page")) {
            context = "pageContext";
        } else if (scope.equals("request")) {
            context = "request";
        } else if (scope.equals("session")) {
            context = "session";
        } else if (scope.equals("application")) {
            context = "application";
        } else {
            throw this.error(L.l("unknown scope `{0}'", scope));
        }
        if (context.equals("application") || context.equals("session")) {
            this.println("synchronized (" + context + ") {");
            this.pushDepth();
        }
        this.print("var " + id + " = " + context);
        if (context.equals("session")) {
            this.println(".getValue(\"" + id + "\");");
        } else {
            this.println(".getAttribute(\"" + id + "\");");
        }
        this.println("if (" + id + " == null) {");
        this.pushDepth();
        if (!className.equals("")) {
            this.println(id + " = new Packages." + className + "();");
        } else if (beanName.equals("")) {
            this.println("if (true) throw new java.lang.InstantiationException();");
        } else if (this.hasRuntimeAttribute(beanName)) {
            beanName = this.getRuntimeAttribute(beanName);
            this.println(id + " = _cauchoCreateBean(" + beanName + ")");
        } else {
            this.println(id + " = _cauchoCreateBean(\"" + beanName + "\");");
        }
        if (context.equals("session")) {
            this.println(context + ".putValue(\"" + id + "\", " + id + ");");
        } else {
            this.println(context + ".setAttribute(\"" + id + "\", " + id + ");");
        }
        this.generateChildren(elt.getFirstChild());
        this.popDepth();
        this.println("}");
        if (context.equals("application") || context.equals("session")) {
            this.popDepth();
            this.println("}");
        }
    }

    protected void printDeclareTag(String className, int id) throws Exception {
        this.println("var _jspTag" + id + ";");
    }

    protected void printTagInstance(CauchoElement elt, TagInstance tag, TagInfo tagInfo, VariableInfo[] varInfo, boolean usesTagBody, String bodyContent, BeanInfo beanInfo) throws Exception {
        int id = tag.getId();
        String name = "_jspTag" + id;
        String className = tagInfo.getTagClassName();
        TagAttributeInfo[] attrs = tagInfo.getAttributes();
        this.println("var " + name + " : Packages." + className + ";");
        this.println("if (! " + name + ") {");
        this.pushDepth();
        this.println(name + " = new Packages." + className + "();");
        this.println(name + ".setPageContext(pageContext);");
        TagInstance parent = tag.getParent();
        if (parent == null || parent.getId() < 0) {
            this.println(name + ".setParent(null);");
        } else {
            this.println(name + ".setParent(_jsp_tag" + parent.getId() + ");");
        }
        this.popDepth();
        this.println("}");
        for (int i = 0; attrs != null && i < attrs.length; ++i) {
            if (!elt.getAttribute(attrs[i].getName()).equals("") || !attrs[i].isRequired()) continue;
            throw this.error(L.l("`{0}' expects attribute `{1}'", (Object)elt.getNodeName(), attrs[i].getName()));
        }
        for (Node attr = elt.getFirstAttribute(); attr != null; attr = attr.getNextSibling()) {
            int i = 0;
            for (i = 0; attrs != null && i < attrs.length && !attrs[i].getName().equals(attr.getNodeName()); ++i) {
            }
            if (attrs != null && i >= attrs.length) {
                throw this.error(L.l("unexpected attribute `{0}' in `{1}'", (Object)attr.getNodeName(), elt.getNodeName()));
            }
            this.generateSetAttribute(beanInfo, name, elt.getNodeName(), attr.getNodeName(), attr.getNodeValue());
        }
        int thisId = this.uniqueId++;
        this.println("var _jspEval" + thisId + " = " + name + ".doStartTag();");
        this.printVarDeclaration(elt, varInfo, VariableInfo.AT_BEGIN);
        if ("empty".equals(bodyContent)) {
            if (elt.getFirstChild() != null) {
                throw this.error(L.l("`{0}' expects an empty body", elt.getNodeName()));
            }
        } else if (usesTagBody) {
            this.println("if (_jspEval" + thisId + " == " + name + ".EVAL_BODY_TAG) {");
            this.pushDepth();
            this.println("out = pageContext.pushBody();");
            this.println(name + ".setBodyContent(out);");
            this.println(name + ".doInitBody();");
            this.println("do {");
            this.pushDepth();
            this.printVarDeclaration(elt, varInfo, VariableInfo.NESTED);
            this.generateChildren(elt.getFirstChild());
            this.popDepth();
            this.println("} while (" + name + ".doAfterBody() == " + name + ".EVAL_BODY_TAG);");
            this.println("out = pageContext.popBody();");
            this.popDepth();
            this.println("}");
        } else {
            this.println("if (_jspEval" + thisId + " == " + name + ".EVAL_BODY_INCLUDE) {");
            this.pushDepth();
            this.printVarDeclaration(elt, varInfo, VariableInfo.NESTED);
            this.generateChildren(elt.getFirstChild());
            this.popDepth();
            this.println("}");
        }
        this.println("if (" + name + ".doEndTag() == " + name + ".SKIP_PAGE)");
        this.println("  return;");
        this.printVarDeclaration(elt, varInfo, VariableInfo.AT_END);
    }

    protected void generateIf(Element elt) throws Exception {
        String test = elt.getAttribute("test");
        this.println();
        this.println("if (" + test + ") {");
        this.pushDepth();
        this.generateChildren(elt.getFirstChild());
        this.popDepth();
        this.println("}");
        for (Node node = elt.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeName().equals("jsp:elseif")) {
                Element subelt = (Element)node;
                this.println("else if (" + subelt.getAttribute("test") + ") {");
                this.pushDepth();
                this.generateChildren(node.getFirstChild());
                this.popDepth();
                this.println("}");
                continue;
            }
            if (!node.getNodeName().equals("jsp:else")) continue;
            this.println("else {");
            this.pushDepth();
            this.generateChildren(node.getFirstChild());
            this.popDepth();
            this.println("}");
            break;
        }
    }

    protected void generateForeach(Element elt) throws Exception {
        String name = elt.getAttribute("name");
        String expr = elt.getAttribute("expr");
        String min = elt.getAttribute("min");
        String max = elt.getAttribute("max");
        if (expr.equals("")) {
            String minVar = "_jsp_min" + this.uniqueId++;
            String maxVar = "_jsp_max" + this.uniqueId++;
            this.println();
            this.println("var " + maxVar + " = " + max + ";");
            this.println("for (var " + name + " = " + min + "; " + name + " < " + maxVar + "; " + name + "++) {");
            this.pushDepth();
            this.generateChildren(elt.getFirstChild());
            this.popDepth();
            this.println("}");
        } else {
            this.println();
            this.println("for (var " + name + " in " + expr + ") {");
            this.pushDepth();
            this.generateChildren(elt.getFirstChild());
            this.popDepth();
            this.println("}");
        }
    }

    private void printVarDeclaration(Element elt, VariableInfo[] varInfo, int scope) throws Exception {
        if (varInfo == null) {
            return;
        }
        for (int i = 0; i < varInfo.length; ++i) {
            VariableInfo var = varInfo[i];
            if (var == null || !var.getDeclare() || var.getScope() != scope) continue;
            String varName = var.getVarName();
            if (varName == null) {
                throw this.error(L.l("tag variable expects a name"));
            }
            if (var.getClassName() == null) {
                throw this.error(L.l("tag variable `{0}' expects a classname", varName));
            }
            this.print("var " + varName + " = ");
            String v = "pageContext.findAttribute(\"" + varName + "\")";
            this.print(v + ";");
        }
    }

    private void generateSetAttribute(BeanInfo info, String name, String tagName, String attrName, String value) throws Exception {
        String pdName;
        PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
        Method method = null;
        for (int i = 0; !(i >= descriptors.length || (pdName = descriptors[i].getName()).equals(attrName) && (method = descriptors[i].getWriteMethod()) != null); ++i) {
        }
        if (method == null) {
            throw this.error(L.l("`{0}' has no attribute `{1}'", (Object)tagName, attrName));
        }
        String setName = method.getName();
        Class<?> type = method.getParameterTypes()[0];
        String typeName = type.getName();
        this.print(name + "." + setName);
        if (this.hasRuntimeAttribute(value)) {
            this.println("(" + this.getRuntimeAttribute(value) + ");");
        } else if (!(!value.equals("") || typeName.equals("java.lang.Object") || typeName.equals("java.lang.String") || typeName.equals("java.lang.Character") || typeName.equals("char"))) {
            this.println("(null);");
        } else {
            this.print("(\"" + value + "\");");
        }
    }

    private VariableInfo findVar(VariableInfo[] info, String name) {
        for (int i = 0; i < info.length; ++i) {
            if (!info[i].getVarName().equals(name)) continue;
            return info[i];
        }
        return null;
    }

    private void generateGetProperty(Element elt) throws Exception {
        String name = elt.getAttribute("name");
        if (name.equals("")) {
            throw this.error(L.l("{0} expects attribute `{1}'", (Object)"jsp:getProperty", "name"));
        }
        String property = elt.getAttribute("property");
        if (property.equals("")) {
            throw this.error(L.l("{0} expects attribute `{1}'", (Object)"jsp:getProperty", "property"));
        }
        this.println("out.write(" + name + "." + property + ");");
    }

    private void generateSetProperty(Element elt) throws Exception {
        String name = elt.getAttribute("name");
        if (name.equals("")) {
            throw this.error(L.l("{0} expects attribute `{1}'", (Object)"jsp:setProperty", "name"));
        }
        String property = elt.getAttribute("property");
        if (property.equals("")) {
            throw this.error(L.l("{0} expects attribute `{1}'", (Object)"jsp:setProperty", "property"));
        }
        String param = elt.getAttribute("param");
        String value = elt.getAttribute("value");
        if (value.equals("")) {
            this.generateSetParamProperty(name, property, param);
            return;
        }
        if (this.hasRuntimeAttribute(value)) {
            value = this.getRuntimeAttribute(value);
            this.println(name + "." + property + "= (" + value + ");");
        } else {
            this.println(name + "." + property + "= (\"" + value + "\");");
        }
    }

    public String getRuntimeAttribute(String value) throws Exception {
        int head;
        if (value.startsWith("<%=") && value.endsWith("%>")) {
            return value.substring(3, value.length() - 2);
        }
        if (value.startsWith("%=") && value.endsWith("%")) {
            return value.substring(2, value.length() - 1);
        }
        CharBuffer cb = CharBuffer.allocate();
        int length = value.length();
        CharBuffer str = CharBuffer.allocate();
        cb.append("(\"\" + ");
        int tail = head = 0;
        while (tail < length) {
            if (value.regionMatches(tail, "<%=", 0, 3)) {
                int end;
                if (head < tail) {
                    cb.append("+\"");
                    cb.append(this.escapeString(value.substring(head, tail)));
                    cb.append("\"");
                }
                if ((end = value.indexOf("%>", tail)) < 0) {
                    throw this.error("expected %>");
                }
                cb.append("+(" + value.substring(tail + 3, end) + ")");
                tail = head = end + 2;
                continue;
            }
            if (!this.isVelocity) {
                ++tail;
                continue;
            }
            if (value.charAt(tail) != '$' || tail + 1 >= length) {
                ++tail;
                continue;
            }
            char ch = value.charAt(tail + 1);
            if (ch == '{') {
                if (head < tail) {
                    cb.append("+(\"");
                    cb.append(this.escapeString(value.substring(head, tail)));
                    cb.append("\")");
                }
                cb.append("+(");
                ++tail;
                while (tail < length && (ch = value.charAt(tail)) != '}') {
                    cb.append(ch);
                    ++tail;
                }
                cb.append(")");
                head = tail;
                continue;
            }
            if (Character.isJavaIdentifierStart(ch) && ch != '$') {
                if (head < tail) {
                    cb.append("+(\"");
                    cb.append(this.escapeString(value.substring(head, tail)));
                    cb.append("\")");
                }
                cb.append("+(");
                ++tail;
                while (tail < length && Character.isJavaIdentifierPart(ch = value.charAt(tail)) && ch != '$') {
                    cb.append(ch);
                    ++tail;
                }
                cb.append(")");
                head = tail;
                continue;
            }
            ++tail;
        }
        if (head < tail) {
            cb.append("+(\"");
            cb.append(this.escapeString(value.substring(head, tail)));
            cb.append("\")");
        }
        cb.append(")");
        return cb.close();
    }

    private void generateSetParamProperty(String name, String property, String param) throws Exception {
        if (property.equals("*")) {
            this.println("for (var _jspName in request.form) {");
            this.println("  var _jspParam = request.form[_jspName];");
            this.println("  if (_jspParam)");
            this.println("    " + name + "[_jspName] = _jspParam;");
            this.println("}");
        } else {
            this.println("var _jspParam = request.form[\"" + param + "\"];");
            this.println("if (_jspParam)");
            this.println("  " + name + "." + property + " = _jspParam;");
        }
    }

    protected void generateFunction(String name, String text) throws IOException {
        this.print("function ");
        this.print(name);
        this.println("(application, session, req, res) {");
        this.print(text);
        this.print("}");
    }

    protected void generatePageFooter(Document doc) throws IOException {
        if (this.hasTags()) {
            this.popDepth();
            this.println("} finally {");
            this.pushDepth();
        }
    }

    protected void printReleaseTag(int id) throws Exception {
        this.println("if (_jspTag" + id + " != null)");
        this.println("  _jspTag" + id + ".release();");
    }

    protected void generateClassFooter(Document doc) throws IOException {
        if (this.hasTags()) {
            this.popDepth();
            this.println("}");
        }
        this.popDepth();
        this.println("}");
        this.println("_jspService(request, response, out);");
    }

    protected Page compile(Path path, long lastModified) throws Exception {
        ReadStream is = this.jsPath.openRead();
        try {
            Depend depend;
            int i;
            if (this.charEncoding != null) {
                is.setEncoding(this.charEncoding);
            }
            MergePath scriptPath = new MergePath();
            scriptPath.addMergePath(this.pwd);
            scriptPath.addMergePath(this.application.getAppDir().lookup("WEB-INF/scripts"));
            scriptPath.addMergePath(CauchoSystem.getResinHome().lookup("scripts"));
            scriptPath.addClassPath(this.loader);
            is.setPath(path);
            Parser parser = Resin.getParser();
            parser.setParentLoader(this.loader);
            parser.setScriptPath(scriptPath);
            parser.setLineMap(this.lineMap);
            parser.setFast(true);
            parser.setClassName(this.className);
            parser.setWorkDir(this.jspManager.getClassDir());
            Script script = parser.parse(is);
            ServletConfig config = (ServletConfig)this.req.getAttribute("caucho.jsp.servlet-config");
            if (config == null) {
                config = new JspServletConfig(this.application, null, "jsp");
            }
            JavaScriptPage page = new JavaScriptPage(this.loader, script, config, this.hasSession, this.bufferSize, this.autoFlush, this.servletInfo, this.errorPage, this.pwd, this.lineMap);
            page._caucho_addDepend(path);
            for (i = 0; i < this.depends.size(); ++i) {
                depend = (Depend)this.depends.get(i);
                page._caucho_addDepend(depend.getPath(), depend.getLastModified(), depend.getLength());
            }
            if (this.isCacheable && !this.isUncacheable) {
                page._caucho_setCacheable();
                for (i = 0; i < this.cacheDepends.size(); ++i) {
                    depend = (Depend)this.cacheDepends.get(i);
                    page._caucho_addCacheDepend(depend.getPath(), depend.getLastModified(), depend.getLength());
                }
            }
            return page;
        }
        catch (ESParseException e) {
            String error = this.lineMap.convertError(this.lineMap.getDestFilename(), e.getLine(), e.getColumn(), e.getText());
            throw new JspParseException(error, this.errorPage);
        }
        catch (Exception e) {
            throw new JspParseException(e, this.errorPage);
        }
    }

    private long getLastModified() {
        long lastModified = this.path.getLastModified();
        for (int i = 0; i < this.depends.size(); ++i) {
            Depend depend = (Depend)this.depends.get(i);
            if (depend.getLastModified() <= lastModified) continue;
            lastModified = depend.getLastModified();
        }
        return lastModified;
    }
}

