/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp;

import com.caucho.java.LineMap;
import com.caucho.jsp.CauchoPage;
import com.caucho.jsp.JspManager;
import com.caucho.server.http.Application;
import com.caucho.server.http.CauchoRequest;
import com.caucho.server.http.CauchoResponse;
import com.caucho.util.Alarm;
import com.caucho.util.Base64;
import com.caucho.util.CharBuffer;
import com.caucho.util.DynamicClassLoader;
import com.caucho.util.QDate;
import com.caucho.util.Registry;
import com.caucho.util.RegistryException;
import com.caucho.util.RegistryNode;
import com.caucho.vfs.Depend;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class Page
implements Servlet,
ServletConfig,
CauchoPage {
    protected static WriteStream dbg = LogStream.open("/caucho.com/jsp/page");
    private ServletConfig config;
    private ServletContext servletContext;
    private ArrayList depends;
    private ArrayList cacheDepends;
    private String media;
    protected String contentType;
    protected boolean alwaysModified;
    protected boolean neverModified;
    private long lastModified;
    private String lastModifiedString;
    private String etag;
    private QDate calendar;
    private long updateInterval;
    private long lastUpdateCheck;
    private JspManager jspManager;
    private boolean isDead;

    public void init(LineMap lineMap, Path path) throws ServletException {
    }

    void _caucho_setContentType(String contentType) {
        this.contentType = contentType;
    }

    void _caucho_setUpdateInterval(long updateInterval) {
        this.updateInterval = updateInterval;
    }

    void _caucho_setJspManager(JspManager manager) {
        this.jspManager = manager;
    }

    void _caucho_unload() {
        if (this.jspManager != null) {
            this.jspManager.unload(this);
        }
    }

    protected void _caucho_setContentType(String contentType, String encoding) {
        if (encoding != null && encoding.equals("ISO-8859-1")) {
            encoding = null;
        }
        this.contentType = contentType;
    }

    void _caucho_setUncacheable() {
        this.cacheDepends = null;
    }

    protected void _caucho_setAlwaysModified() {
        if (this.cacheDepends == null) {
            this.alwaysModified = true;
        }
    }

    protected void _caucho_setModified() {
        this.alwaysModified = true;
    }

    protected void _caucho_setNeverModified(boolean modified) {
        this.neverModified = modified;
    }

    protected void _caucho_clearDepends() {
        if (this.depends != null) {
            this.depends.clear();
        }
    }

    protected void _caucho_addDepend(Path path) {
        if (this.depends == null) {
            this.depends = new ArrayList();
        }
        Depend depend = new Depend(path);
        depend.setRequireSource(this.getRequireSource());
        if (!this.depends.contains(depend)) {
            this.depends.add(depend);
        }
    }

    protected void _caucho_addDepend(Path path, long lastModified, long length) {
        if (this.depends == null) {
            this.depends = new ArrayList();
        }
        Depend depend = new Depend(path, lastModified, length);
        depend.setRequireSource(this.getRequireSource());
        if (!this.depends.contains(depend)) {
            this.depends.add(depend);
        }
    }

    protected void _caucho_setCacheable() {
        this.cacheDepends = new ArrayList();
        this.alwaysModified = false;
    }

    protected void _caucho_addCacheDepend(Path path, long lastModified, long length) {
        Depend depend;
        if (this.cacheDepends == null) {
            this.cacheDepends = new ArrayList();
        }
        if (!this.cacheDepends.contains(depend = new Depend(path, lastModified, length))) {
            this.cacheDepends.add(depend);
        }
    }

    void _caucho_setCacheable(ArrayList depends) {
        this.cacheDepends = new ArrayList();
        for (int i = 0; i < depends.size(); ++i) {
            Path path = (Path)depends.get(i);
            Depend depend = new Depend(path);
            depend.setRequireSource(this.getRequireSource());
            if (this.cacheDepends.contains(depend)) continue;
            this.cacheDepends.add(depend);
        }
    }

    public boolean _caucho_isModified() {
        if (this.alwaysModified) {
            return true;
        }
        if (this.depends == null) {
            return false;
        }
        for (int i = 0; i < this.depends.size(); ++i) {
            Depend depend = (Depend)this.depends.get(i);
            if (!depend.isModified()) continue;
            return true;
        }
        return false;
    }

    public boolean cauchoIsModified() {
        DynamicClassLoader loader;
        long now = Alarm.getCurrentTime();
        if (this.alwaysModified) {
            return true;
        }
        if (now < this.lastUpdateCheck + this.updateInterval) {
            return false;
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader instanceof DynamicClassLoader && (loader = (DynamicClassLoader)classLoader).isModified()) {
            return true;
        }
        if (this.neverModified) {
            this.lastUpdateCheck = now;
            return false;
        }
        boolean isModified = this._caucho_isModified();
        if (!isModified) {
            this.lastUpdateCheck = now;
        }
        return isModified;
    }

    private boolean getRequireSource() {
        try {
            return Registry.getBoolean("/caucho.com/jsp/require-source", false);
        }
        catch (RegistryException e) {
            dbg.log(e);
            return true;
        }
    }

    public void init(ServletConfig config) throws ServletException {
        this.config = config;
        this.servletContext = config.getServletContext();
        if (!this.disableLog()) {
            this.log("init");
        }
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public String getServletName() {
        return this.config.getServletName();
    }

    public String getInitParameter(String name) {
        return this.config.getInitParameter(name);
    }

    public Enumeration getInitParameterNames() {
        return this.config.getInitParameterNames();
    }

    public void log(String msg) {
        this.servletContext.log(this.getClass().getName() + ": " + msg);
    }

    public void log(String msg, Throwable cause) {
        this.servletContext.log(this.getClass().getName() + ": " + msg, cause);
    }

    public String getServletInfo() {
        return "A JSP Page";
    }

    boolean disableLog() {
        try {
            ServletContext cxt = this.servletContext;
            RegistryNode node = null;
            if (cxt instanceof Application) {
                node = ((Application)cxt).getRegistry();
            }
            return node != null && node.getBoolean("/jsp/disable-init-log", false);
        }
        catch (RegistryException e) {
            return false;
        }
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public void _caucho_init(HttpServletRequest req, HttpServletResponse res) {
        if (this.contentType != null) {
            res.setContentType(this.contentType);
        } else {
            res.setContentType("text/html");
        }
    }

    public long getLastModified(HttpServletRequest request) {
        return this._caucho_lastModified();
    }

    public long _caucho_lastModified() {
        if (this.cacheDepends == null) {
            return 0L;
        }
        return Page.calculateLastModified(this.depends, this.cacheDepends);
    }

    public static long calculateLastModified(ArrayList depends, ArrayList cacheDepends) {
        long modified;
        Depend depend;
        int i;
        long lastModified = 0L;
        for (i = 0; i < depends.size(); ++i) {
            depend = (Depend)depends.get(i);
            modified = depend.getLastModified();
            if (modified <= lastModified) continue;
            lastModified = modified;
        }
        for (i = 0; cacheDepends != null && i < cacheDepends.size(); ++i) {
            depend = (Depend)cacheDepends.get(i);
            modified = depend.getLastModified();
            if (modified <= lastModified) continue;
            lastModified = modified;
        }
        return lastModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subservice(CauchoRequest req, CauchoResponse res) throws IOException, ServletException {
        long lastModified = this.getLastModified(req);
        if (lastModified > 0L) {
            String ifMatch;
            if (this.calendar == null) {
                this.calendar = new QDate();
            }
            if (lastModified != this.lastModified) {
                CharBuffer cb = new CharBuffer();
                cb.append('\"');
                Base64.encode(cb, lastModified);
                cb.append('\"');
                this.etag = cb.close();
                QDate qDate = this.calendar;
                synchronized (qDate) {
                    this.calendar.calculate(lastModified, false);
                    this.lastModifiedString = this.calendar.printDate();
                }
            }
            if (this.etag.equals(ifMatch = req.getHeader("If-None-Match"))) {
                res.sendError(304);
                return;
            }
            String ifModifiedSince = req.getHeader("If-Modified-Since");
            if (this.lastModifiedString.equals(ifModifiedSince)) {
                res.sendError(304);
                return;
            }
            res.setHeader("ETag", this.etag);
            res.setHeader("Last-Modified", this.lastModifiedString);
        }
        this.service((ServletRequest)req, (ServletResponse)res);
    }

    void setDead() {
        this.isDead = true;
    }

    public boolean isDead() {
        return this.isDead;
    }

    public LineMap _caucho_getLineMap() {
        return null;
    }

    String getErrorPage() {
        return null;
    }

    public void destroy() {
        if (!this.disableLog()) {
            this.log("destroy");
        }
    }
}

