/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp;

import com.caucho.jsp.QJspFactory;
import com.caucho.jsp.XslManager;
import com.caucho.server.http.CauchoApplication;
import com.caucho.server.http.CauchoRequest;
import com.caucho.server.http.CauchoResponse;
import com.caucho.server.http.Http;
import com.caucho.util.CauchoSystem;
import com.caucho.util.Registry;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.Pwd;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.Html;
import com.caucho.xml.Xml;
import com.caucho.xml.XmlUtil;
import com.caucho.xpath.XPath;
import com.caucho.xpath.XPathException;
import com.caucho.xsl.TransformerImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.servlet.GenericServlet;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.PageContext;
import javax.xml.transform.Templates;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public class XslFilter
extends GenericServlet {
    private static WriteStream dbg = LogStream.open("/caucho.com/xtp/filter");
    static final String COPYRIGHT = "Copyright (c) 1998-2002 Caucho Technology.  All rights reserved.";
    private CauchoApplication application;
    private XslManager xslManager;
    private boolean isStrictXsl = true;
    private boolean isStrictXml = true;

    public void setStrictXsl(boolean isStrictXsl) {
        this.isStrictXsl = isStrictXsl;
    }

    public void init(ServletConfig config) throws ServletException {
        String strictXmlValue;
        ServletContext cxt;
        super.init(config);
        if (Registry.getRegistry() == null) {
            try {
                String resinConf = config.getInitParameter("resin.conf");
                if (resinConf == null) {
                    resinConf = CauchoSystem.getResinConfig();
                }
                Registry node = Registry.parse(Pwd.lookupNative(resinConf));
                Registry.setDefault(node);
                dbg = LogStream.open("/caucho.com/xtp/filter");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.application = (cxt = config.getServletContext()) instanceof CauchoApplication ? (CauchoApplication)cxt : Http.createApplicationAdapter(cxt);
        this.xslManager = new XslManager(this.application);
        String strictXslValue = config.getInitParameter("strict-xsl");
        if (strictXslValue != null) {
            boolean bl = this.isStrictXsl = strictXslValue.equals("true") || strictXslValue.equals("yes");
        }
        if ((strictXmlValue = config.getInitParameter("strict-xml")) != null) {
            this.isStrictXml = strictXmlValue.equals("true") || strictXmlValue.equals("yes");
        }
        this.xslManager.setStrictXsl(this.isStrictXsl);
        if (JspFactory.getDefaultFactory() == null) {
            JspFactory.setDefaultFactory((JspFactory)QJspFactory.create());
        }
    }

    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        CauchoRequest req = (CauchoRequest)request;
        CauchoResponse res = (CauchoResponse)response;
        Document doc = null;
        ReadStream is = req.getStream();
        String href = (String)request.getAttribute("caucho.xsl.stylesheet");
        try {
            if (this.isStrictXml) {
                doc = new Xml().parseDocument(is);
            } else {
                Html parser = new Html();
                parser.setEntitiesAsText(true);
                parser.setAutodetectXml(true);
                doc = parser.parseDocument(is);
            }
            if (href == null) {
                href = this.getStylesheetHref(doc);
            }
            if (href == null) {
                href = "default.xsl";
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        if (dbg.canWrite()) {
            dbg.log("formatting with " + href);
        }
        TransformerImpl transformer = null;
        try {
            Templates stylesheet = this.xslManager.get(href, req);
            transformer = (TransformerImpl)stylesheet.newTransformer();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        JspFactory factory = JspFactory.getDefaultFactory();
        String errorPage = null;
        errorPage = (String)transformer.getProperty("caucho.error.page");
        PageContext pageContext = factory.getPageContext((Servlet)this, (ServletRequest)req, (ServletResponse)res, errorPage, false, 0, false);
        String mediaType = transformer.getOutputProperty("media-type");
        String encoding = transformer.getOutputProperty("encoding");
        String method = transformer.getOutputProperty("method");
        if (encoding == null && method != null && method.equals("xml")) {
            encoding = "UTF-8";
        }
        if (encoding != null && !encoding.equals("ISO-8859-1")) {
            if (mediaType == null) {
                mediaType = "text/html";
            }
            res.setContentType(mediaType + "; charset=" + encoding);
        } else if (mediaType != null) {
            res.setContentType(mediaType);
        } else {
            res.setContentType("text/html");
        }
        if (encoding == null) {
            encoding = "ISO-8859-1";
        }
        transformer.setOutputProperty("encoding", encoding);
        Path path = this.application.getAppDir();
        String realPath = this.application.getRealPath(req.getPageServletPath());
        path = path.lookupNative(realPath);
        ArrayList params = (ArrayList)transformer.getProperty("caucho.global.param");
        for (int i = 0; params != null && i < params.size(); ++i) {
            String param = (String)params.get(i);
            transformer.setParameter(param, req.getParameter(param));
        }
        transformer.setProperty("caucho.page.context", pageContext);
        transformer.setProperty("caucho.pwd", path.getParent());
        try {
            transformer.transform((Node)doc, (OutputStream)res.getOutputStream());
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private String getStylesheetHref(Document doc) throws XPathException {
        ProcessingInstruction pi = null;
        pi = (ProcessingInstruction)XPath.find("//processing-instruction('xml-stylesheet')", doc);
        if (pi == null) {
            return null;
        }
        String value = pi.getNodeValue();
        return XmlUtil.getPIAttribute(value, "href");
    }

    public String getServletInfo() {
        return "XSL Filter";
    }
}

