/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp;

import com.caucho.java.JavaCompiler;
import com.caucho.java.LineMap;
import com.caucho.jsp.JspManager;
import com.caucho.jsp.JspParseException;
import com.caucho.jsp.JspParser;
import com.caucho.jsp.Page;
import com.caucho.jsp.QJspException;
import com.caucho.jsp.XslManager;
import com.caucho.server.http.CauchoApplication;
import com.caucho.server.http.CauchoRequest;
import com.caucho.server.http.CauchoResponse;
import com.caucho.server.http.Http;
import com.caucho.util.Base64;
import com.caucho.util.CharBuffer;
import com.caucho.util.Registry;
import com.caucho.util.RegistryException;
import com.caucho.util.RegistryNode;
import com.caucho.vfs.Depend;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.CauchoDocument;
import com.caucho.xml.Html;
import com.caucho.xml.Xml;
import com.caucho.xml.XmlParser;
import com.caucho.xml.XmlUtil;
import com.caucho.xpath.XPath;
import com.caucho.xpath.XPathException;
import com.caucho.xsl.StylesheetImpl;
import com.caucho.xsl.TransformerImpl;
import com.caucho.xsl.XslParseException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.PageContext;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.ProcessingInstruction;

class XtpPage
extends Page {
    private static WriteStream dbg = LogStream.open("/caucho.com/xtp");
    private boolean strictXml;
    private boolean toLower = true;
    private boolean entitiesAsText = false;
    private Path sourcePath;
    private Path pwd;
    private long lastUpdateCheck;
    private long updateInterval;
    private String uri;
    private String className;
    private String uriPwd;
    private String errorPage;
    private CauchoApplication application;
    private XslManager xslManager;
    private Page page;
    private HashMap varyMap;
    private ArrayList paramNames;
    private JspManager jspManager;

    XtpPage(Path path, String uri, String className, String uriPwd, CauchoRequest req, XslManager xslManager, boolean strictXml) throws ServletException, RegistryException {
        this.sourcePath = path;
        this.sourcePath.setUserPath(uri);
        this.pwd = this.sourcePath.getParent();
        this.className = className;
        this.uriPwd = uriPwd;
        this.application = req.getCauchoApplication();
        this.strictXml = strictXml;
        this.xslManager = xslManager;
        this.uri = uri;
        this.init(Http.createServletConfig(uri, this.application));
        RegistryNode config = this.application.getRegistry();
        if (config != null) {
            this.updateInterval = config.getPeriod("class-update-interval", 15000L);
        }
        if (this.updateInterval < 0L) {
            this.updateInterval = 0L;
        }
    }

    void setManager(JspManager manager) {
        this.jspManager = manager;
    }

    void setHtmlToLower(boolean toLower) {
        this.toLower = toLower;
    }

    void setEntitiesAsText(boolean entitiesAsText) {
        this.entitiesAsText = entitiesAsText;
    }

    public boolean _caucho_isModified() {
        return false;
    }

    public LineMap _caucho_getLineMap() {
        if (this.page != null) {
            return this.page._caucho_getLineMap();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        CauchoRequest req = (CauchoRequest)request;
        CauchoResponse res = (CauchoResponse)response;
        Object ss = null;
        String varyName = null;
        Page page = this.page;
        XtpPage xtpPage = this;
        synchronized (xtpPage) {
            if (page == null && this.varyMap != null && (varyName = this.generateVaryName(req)) != null) {
                page = (Page)this.varyMap.get(varyName);
            }
            if (page != null && page.cauchoIsModified()) {
                page._caucho_unload();
                page.destroy();
                this.page = null;
                page = null;
                if (varyName != null && this.varyMap != null) {
                    this.varyMap.remove(varyName);
                }
            }
            if (page == null) {
                varyName = this.generateVaryName(req);
                page = this.getPrecompiledPage(req, varyName);
                if (page == null) {
                    CauchoDocument doc;
                    try {
                        doc = this.parseXtp();
                    }
                    catch (FileNotFoundException e) {
                        res.sendError(404);
                        throw e;
                    }
                    Templates stylesheet = this.compileStylesheet(req, doc);
                    varyName = this.generateVaryName(req);
                    page = this.compileJspPage(req, res, doc, stylesheet, varyName);
                }
                if (varyName != null && this.varyMap == null) {
                    this.varyMap = new HashMap();
                }
                if (varyName != null) {
                    this.varyMap.put(varyName, page);
                } else {
                    this.page = page;
                }
            }
        }
        if (page != null) {
            page.subservice(req, res);
        }
    }

    private Page getPrecompiledPage(CauchoRequest req, String varyName) throws IOException, ServletException {
        block5: {
            Page page = null;
            String className = this.getClassName(varyName);
            try {
                if (Registry.getBoolean("/caucho.com/jsp/precompile", true)) {
                    if (this.jspManager.preloadIsValid(className, this.application.getClassLoader(), this.application.getAppDir())) {
                        page = this.jspManager.loadClass(className, req, null);
                    }
                    if (page != null) {
                        return page;
                    }
                }
            }
            catch (Throwable e) {
                if (!dbg.canWrite()) break block5;
                dbg.log(e);
            }
        }
        return null;
    }

    private CauchoDocument parseXtp() throws IOException, ServletException {
        ReadStream is = this.sourcePath.openRead();
        try {
            XmlParser parser;
            if (this.strictXml) {
                parser = new Xml();
                parser.setEntitiesAsText(this.entitiesAsText);
            } else {
                parser = new Html();
                parser.setAutodetectXml(true);
                parser.setEntitiesAsText(true);
                parser.setToLower(this.toLower);
            }
            parser.setResinInclude(true);
            parser.setJsp(true);
            CauchoDocument cauchoDocument = (CauchoDocument)parser.parseDocument(is);
            return cauchoDocument;
        }
        catch (Exception e) {
            throw new JspParseException(e, this.errorPage);
        }
        finally {
            is.close();
        }
    }

    private Templates compileStylesheet(CauchoRequest req, CauchoDocument doc) throws IOException, ServletException {
        String ssName = (String)req.getAttribute("caucho.xsl.stylesheet");
        Templates stylesheet = null;
        try {
            if (ssName == null) {
                ssName = this.getStylesheetHref(doc, req.getMedia());
            }
            stylesheet = this.xslManager.get(ssName, req);
        }
        catch (XslParseException e) {
            if (e.getException() != null) {
                throw new JspParseException(e.getException(), this.errorPage);
            }
            throw new JspParseException(e, this.errorPage);
        }
        catch (Exception e) {
            throw new JspParseException(e, this.errorPage);
        }
        ArrayList params = null;
        if (stylesheet instanceof StylesheetImpl) {
            StylesheetImpl ss = (StylesheetImpl)stylesheet;
            params = (ArrayList)ss.getProperty("caucho.global.param");
        }
        for (int i = 0; params != null && i < params.size(); ++i) {
            String param = (String)params.get(i);
            if (this.paramNames == null) {
                this.paramNames = new ArrayList();
            }
            if (this.paramNames.contains(param)) continue;
            this.paramNames.add(param);
        }
        return stylesheet;
    }

    private Page compileJspPage(CauchoRequest req, CauchoResponse res, CauchoDocument doc, Templates stylesheet, String varyName) throws IOException, ServletException {
        varyName = this.generateVaryName(req);
        String className = this.getClassName(varyName);
        try {
            return this.getJspPage(doc, stylesheet, req, res, className);
        }
        catch (TransformerConfigurationException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private String getClassName(String varyName) {
        if (varyName == null) {
            return this.className;
        }
        return this.className + JavaCompiler.mangleName("?" + varyName);
    }

    private String generateVaryName(CauchoRequest req) {
        CharBuffer cb = CharBuffer.allocate();
        String ss = (String)req.getAttribute("caucho.xsl.stylesheet");
        if (ss == null && (this.paramNames == null || this.paramNames.size() == 0)) {
            return null;
        }
        cb.append("ss.");
        if (ss != null) {
            cb.append(ss);
        }
        for (int i = 0; this.paramNames != null && i < this.paramNames.size(); ++i) {
            String name = (String)this.paramNames.get(i);
            cb.append(".");
            cb.append(name);
            String value = name.equals("xtp:path_info") ? req.getPathInfo() : req.getParameter(name);
            if (value == null) continue;
            cb.append(".");
            cb.append(value);
        }
        if (cb.length() < 64) {
            return cb.close();
        }
        long hash = 37L;
        for (int i = 0; i < cb.length(); ++i) {
            hash = 65521L * hash + (long)cb.charAt(i);
        }
        cb.setLength(32);
        Base64.encode(cb, hash);
        return cb.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Page getJspPage(CauchoDocument doc, Templates stylesheet, CauchoRequest req, CauchoResponse res, String className) throws IOException, ServletException, TransformerConfigurationException {
        String pathInfo;
        String servletPath;
        Path workDir = this.jspManager.getClassDir();
        String fullClassName = className;
        Path path = workDir.lookup(fullClassName.replace('.', '/') + ".jsp");
        path.getParent().mkdirs();
        Properties output = stylesheet.getOutputProperties();
        String encoding = (String)output.get("encoding");
        String mimeType = (String)output.get("media-type");
        String method = (String)output.get("method");
        if (encoding == null) {
            encoding = method == null ? "UTF-8" : (method.equals("html") ? "ISO-8859-1" : "UTF-8");
        }
        Transformer transformer = stylesheet.newTransformer();
        for (int i = 0; this.paramNames != null && i < this.paramNames.size(); ++i) {
            String param = (String)this.paramNames.get(i);
            transformer.setParameter(param, req.getParameter(param));
        }
        String contextPath = req.getContextPath();
        if (contextPath != null && !contextPath.equals("")) {
            transformer.setParameter("xtp:context_path", contextPath);
        }
        if ((servletPath = req.getServletPath()) != null && !servletPath.equals("")) {
            transformer.setParameter("xtp:servlet_path", servletPath);
        }
        if ((pathInfo = req.getPathInfo()) != null && !pathInfo.equals("")) {
            transformer.setParameter("xtp:path_info", pathInfo);
        }
        transformer.setOutputProperty("caucho.jsp", "true");
        LineMap lineMap = null;
        WriteStream os = path.openWrite();
        if (encoding == null) {
            transformer.setOutputProperty("encoding", "ISO-8859-1");
        }
        try {
            if (encoding != null) {
                os.setEncoding(encoding);
                if (mimeType == null) {
                    mimeType = "text/html";
                }
                os.print("<%@ page contentType=\"" + mimeType + "; charset=" + encoding + "\" %>");
            } else if (mimeType != null) {
                os.print("<%@ page contentType=\"" + mimeType + "\" %>");
            }
            lineMap = this.writeJspDoc(os, doc, transformer, req, res);
        }
        finally {
            os.close();
        }
        StylesheetImpl ss = null;
        if (stylesheet instanceof StylesheetImpl) {
            ss = (StylesheetImpl)stylesheet;
        }
        ReadStream is = path.openRead();
        try {
            is.setPath(this.sourcePath);
            boolean cacheable = true;
            ArrayList<Depend> depends = new ArrayList<Depend>();
            ArrayList styleDepends = null;
            if (ss != null) {
                styleDepends = (ArrayList)ss.getProperty("caucho.depends");
            }
            for (int i = 0; styleDepends != null && i < styleDepends.size(); ++i) {
                Depend depend = (Depend)styleDepends.get(i);
                Depend jspDepend = new Depend(depend.getPath(), depend.getLastModified(), depend.getLength());
                jspDepend.setRequireSource(true);
                if (depends.contains(jspDepend)) continue;
                depends.add(jspDepend);
            }
            ArrayList docDepends = (ArrayList)doc.getProperty("caucho.depends");
            for (int i = 0; docDepends != null && i < docDepends.size(); ++i) {
                Path depend = (Path)docDepends.get(i);
                Depend jspDepend = new Depend(depend);
                if (depends.contains(jspDepend)) continue;
                depends.add(jspDepend);
            }
            ArrayList cacheDepends = null;
            TransformerImpl xform = null;
            if (transformer instanceof TransformerImpl) {
                xform = (TransformerImpl)transformer;
            }
            if (xform != null) {
                cacheDepends = (ArrayList)xform.getProperty("caucho.cache.depends");
            }
            for (int i = 0; cacheDepends != null && i < cacheDepends.size(); ++i) {
                Path depend = (Path)cacheDepends.get(i);
                Depend jspDepend = new Depend(depend);
                if (depends.contains(jspDepend)) continue;
                depends.add(jspDepend);
            }
            JspParser parser = new JspParser();
            parser.setJspManager(this.jspManager);
            parser.setStaticSessions(false);
            parser.setClassDir(this.jspManager.getClassDir());
            parser.setTldMap(this.jspManager.getTldMap());
            Page page = parser.parse(is, this.pwd, this.uri, className, this.uriPwd, req, this.application, lineMap, !cacheable, depends);
            return page;
        }
        catch (IOException e) {
            throw e;
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QJspException(e);
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LineMap writeJspDoc(WriteStream os, Document doc, Transformer transformer, CauchoRequest req, CauchoResponse res) throws IOException, ServletException {
        JspFactory factory = JspFactory.getDefaultFactory();
        TransformerImpl xform = null;
        if (transformer instanceof TransformerImpl) {
            xform = (TransformerImpl)transformer;
        }
        String errorPage = null;
        if (xform != null) {
            errorPage = (String)xform.getProperty("caucho.error.page");
        }
        PageContext pageContext = factory.getPageContext((Servlet)this, (ServletRequest)req, (ServletResponse)res, errorPage, false, 0, false);
        try {
            if (xform != null) {
                xform.setProperty("caucho.page.context", pageContext);
                xform.setProperty("caucho.pwd", this.pwd);
            }
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(os);
            xform.setFeature("caucho.generate.location", true);
            transformer.transform(source, result);
            if (xform != null) {
                LineMap lineMap = (LineMap)xform.getProperty("caucho.line-map");
                return lineMap;
            }
            LineMap lineMap = null;
            return lineMap;
        }
        catch (Exception e) {
            pageContext.handlePageException(e);
        }
        finally {
            factory.releasePageContext(pageContext);
        }
        return null;
    }

    private String getStylesheetHref(Document doc, String media) throws XPathException {
        Iterator iter = XPath.select("//processing-instruction('xml-stylesheet')", doc);
        while (iter.hasNext()) {
            ProcessingInstruction pi = (ProcessingInstruction)iter.next();
            String value = pi.getNodeValue();
            String piMedia = XmlUtil.getPIAttribute(value, "media");
            if (piMedia != null && !piMedia.equals(media)) continue;
            return XmlUtil.getPIAttribute(value, "href");
        }
        return "default.xsl";
    }

    private boolean varyMedia(Document doc) throws XPathException {
        Iterator iter = XPath.select("//processing-instruction('xml-stylesheet')", doc);
        while (iter.hasNext()) {
            ProcessingInstruction pi = (ProcessingInstruction)iter.next();
            String value = pi.getNodeValue();
            String piMedia = XmlUtil.getPIAttribute(value, "media");
            if (piMedia == null) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "[XtpPage " + this.uri + "]";
    }
}

