/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jstl.el;

import com.caucho.el.Expr;
import com.caucho.jsp.QBodyContent;
import com.caucho.jsp.QPageContext;
import com.caucho.jstl.NameValueTag;
import com.caucho.jstl.el.CoreSetTag;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;

public class ImportTag
extends BodyTagSupport
implements NameValueTag {
    private static L10N L = new L10N(class$com$caucho$jstl$el$ImportTag == null ? (class$com$caucho$jstl$el$ImportTag = ImportTag.class$("com.caucho.jstl.el.ImportTag")) : class$com$caucho$jstl$el$ImportTag);
    private Expr urlExpr;
    private Expr contextExpr;
    private CharBuffer _query = new CharBuffer();
    private Expr charEncodingExpr;
    private String var;
    private String scope;
    private String varReader;
    private Reader reader;
    static /* synthetic */ Class class$com$caucho$jstl$el$ImportTag;

    public void setURL(Expr url) {
        this.urlExpr = url;
    }

    public void setContext(Expr context) {
        this.contextExpr = context;
    }

    public void addParam(String name, String value) {
        if (name == null) {
            return;
        }
        if (value == null) {
            value = "";
        }
        if (this._query.length() != 0) {
            this._query.append('&');
        }
        this._query.append(name);
        this._query.append('=');
        int len = value.length();
        block5: for (int i = 0; i < len; ++i) {
            char ch = value.charAt(i);
            switch (ch) {
                case '&': {
                    this._query.append("%26");
                    continue block5;
                }
                case '+': {
                    this._query.append("%2b");
                    continue block5;
                }
                case '=': {
                    this._query.append("%3d");
                    continue block5;
                }
                default: {
                    this._query.append(ch);
                }
            }
        }
    }

    public void setCharEncoding(Expr charEncoding) {
        this.charEncodingExpr = charEncoding;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setVarReader(String varReader) {
        this.varReader = varReader;
    }

    public int doStartTag() throws JspException {
        BodyContent jspWriter = null;
        this._query.clear();
        QPageContext pageContext = (QPageContext)this.pageContext;
        try {
            if (this.varReader != null) {
                jspWriter = pageContext.pushBody();
                this.handleBody();
                QBodyContent body = (QBodyContent)pageContext.getOut();
                this.reader = body.getReader();
                pageContext.setAttribute(this.varReader, this.reader);
                int n = 1;
                return n;
            }
            int body = 2;
            return body;
        }
        catch (ServletException e) {
            throw new JspException((Throwable)e);
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        finally {
            if (jspWriter != null) {
                pageContext.popBody();
            }
        }
    }

    public int doEndTag() throws JspException {
        if (this.varReader == null) {
            try {
                if (this.var != null) {
                    BodyContent jspWriter = this.pageContext.pushBody();
                    this.handleBody();
                    QBodyContent body = (QBodyContent)this.pageContext.getOut();
                    String value = body.getString();
                    this.pageContext.popBody();
                    CoreSetTag.setValue(this.pageContext, this.var, this.scope, value);
                } else {
                    this.handleBody();
                }
            }
            catch (ServletException e) {
                throw new JspException((Throwable)e);
            }
            catch (IOException e) {
                throw new JspException((Throwable)e);
            }
        }
        return 6;
    }

    private void handleBody() throws JspException, ServletException, IOException {
        QPageContext pageContext = (QPageContext)this.pageContext;
        String url = this.urlExpr.evalString(pageContext);
        if (url == null || url.equals("")) {
            throw new JspTagException(L.l("URL may not be null for `{0}'", this.urlExpr));
        }
        url = url.indexOf(63) > 0 ? url + '&' + this._query : url + '?' + this._query;
        if (this.contextExpr != null) {
            String context = this.contextExpr.evalString(pageContext);
            if (!url.startsWith("/")) {
                throw new JspException(L.l("URL `{0}' must start with `/' with context `{0}'", (Object)url, context));
            }
            if (context != null && context.startsWith("/")) {
                ServletContext app = pageContext.getServletContext().getContext(context);
                RequestDispatcher disp = app.getRequestDispatcher(url);
                disp.include(pageContext.getRequest(), pageContext.getResponse());
            } else {
                this.handleExternalBody(context + url);
            }
            return;
        }
        int colon = url.indexOf(58);
        int slash = url.indexOf(47);
        if (slash == 0 || colon < 0 || slash < 0 || slash < colon) {
            ServletRequest request = pageContext.getRequest();
            RequestDispatcher disp = request.getRequestDispatcher(url);
            if (disp == null) {
                throw new JspException(L.l("URL `{0}' does not map to any servlet", url));
            }
            disp.include(request, pageContext.getResponse());
        } else {
            this.handleExternalBody(url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleExternalBody(String url) throws JspException, ServletException, IOException {
        QPageContext pageContext = (QPageContext)this.pageContext;
        URL netURL = new URL(url);
        URLConnection conn = netURL.openConnection();
        if (conn instanceof HttpURLConnection) {
            HttpURLConnection cfr_ignored_0 = (HttpURLConnection)conn;
            HttpURLConnection.setFollowRedirects(true);
        }
        InputStream is = conn.getInputStream();
        try {
            int ch;
            int p;
            ReadStream in = Vfs.openRead(is);
            String encoding = conn.getContentEncoding();
            String contentType = conn.getContentType();
            if (this.charEncodingExpr != null) {
                encoding = this.charEncodingExpr.evalString(pageContext);
                if (encoding != null && !encoding.equals("")) {
                    in.setEncoding(encoding);
                }
            } else if (encoding != null) {
                in.setEncoding(encoding);
            } else if (contentType != null && (p = contentType.indexOf("charset=")) > 0) {
                CharBuffer cb = new CharBuffer();
                for (int i = p + 8; i < contentType.length(); ++i) {
                    char ch2 = contentType.charAt(i);
                    if (ch2 == '\"' || ch2 == '\'') continue;
                    if (ch2 >= 'a' && ch2 <= 'z') {
                        cb.append(ch2);
                        continue;
                    }
                    if (ch2 >= 'A' && ch2 <= 'Z') {
                        cb.append(ch2);
                        continue;
                    }
                    if (ch2 >= '0' && ch2 <= '9') {
                        cb.append(ch2);
                        continue;
                    }
                    if (ch2 != '-' && ch2 != '_') break;
                    cb.append(ch2);
                }
                encoding = cb.toString();
                in.setEncoding(encoding);
            }
            JspWriter out = pageContext.getOut();
            while ((ch = in.readChar()) >= 0) {
                out.print((char)ch);
            }
        }
        finally {
            is.close();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

