/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.naming;

import com.caucho.naming.AbstractModel;
import com.caucho.naming.NamingExceptionWrapper;
import com.caucho.naming.ObjectProxy;
import com.caucho.naming.QBindingEnumeration;
import com.caucho.naming.QNameClassEnumeration;
import com.caucho.naming.QNameParser;
import com.caucho.util.L10N;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.WriteStream;
import java.util.Hashtable;
import java.util.Iterator;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.Reference;
import javax.naming.spi.NamingManager;

public class ContextImpl
implements Context {
    protected static WriteStream dbg = LogStream.open("/caucho.com/naming");
    protected static L10N L = new L10N(class$com$caucho$naming$ContextImpl == null ? (class$com$caucho$naming$ContextImpl = ContextImpl.class$("com.caucho.naming.ContextImpl")) : class$com$caucho$naming$ContextImpl);
    protected Hashtable _env;
    protected AbstractModel _model;
    protected String _name;
    static /* synthetic */ Class class$com$caucho$naming$ContextImpl;

    public ContextImpl(AbstractModel model, Hashtable env) {
        this._model = model;
        this._env = env;
        this._name = "";
    }

    public ContextImpl(String name, AbstractModel model, Hashtable env) {
        this._model = model;
        this._env = env;
        this._name = name;
    }

    protected ContextImpl create(String name, AbstractModel model, Hashtable env) {
        return new ContextImpl(name, model, env);
    }

    protected final ContextImpl create(AbstractModel model, Hashtable env) {
        return this.create("", model, env);
    }

    public AbstractModel getModel() {
        return this._model;
    }

    public Object lookup(String name) throws NamingException {
        String tail = name;
        AbstractModel model = this._model;
        while (tail != null) {
            String first = this.parseFirst(tail);
            String rest = this.parseRest(tail);
            if (first == null) {
                return this.create(this.getFullPath(name), model, this._env);
            }
            Object value = model.lookup(first);
            if (value instanceof AbstractModel) {
                model = (AbstractModel)value;
                tail = rest;
                continue;
            }
            value = this.dereference(value, null, model);
            if (rest == null) {
                return value;
            }
            if (value instanceof Context) {
                return ((Context)value).lookup(rest);
            }
            if (value != null) {
                throw new NotContextException(L.l("{0}: expected intermediate context at `{1}'", (Object)this.getFullPath(name), value));
            }
            throw new NameNotFoundException(this.getFullPath(name));
        }
        return this.create(this.getFullPath(name), model, this._env);
    }

    public Object lookup(Name name) throws NamingException {
        if (name == null) {
            return this.create(this._model, this._env);
        }
        AbstractModel model = this._model;
        for (int i = 0; i < name.size(); ++i) {
            String first = name.get(i);
            Object value = model.lookup(first);
            if (!(value instanceof AbstractModel)) {
                value = this.dereference(value, null, model);
                if (i + 1 == name.size()) {
                    return value;
                }
                if (value instanceof Context) {
                    return ((Context)value).lookup(name.getSuffix(i + 1));
                }
                if (value != null) {
                    throw new NotContextException(L.l("{0}: expected intermediate context at `{1}'", (Object)this.getFullPath(name), value));
                }
                throw new NameNotFoundException(this.getFullPath(name));
            }
            model = (AbstractModel)value;
        }
        return this.create(this.getFullPath(name), model, this._env);
    }

    public Object lookupLink(String name) throws NamingException {
        String tail = name;
        AbstractModel model = this._model;
        while (tail != null) {
            String first = this.parseFirst(tail);
            String rest = this.parseRest(tail);
            if (first == null) {
                return this.create(this.getFullPath(name), model, this._env);
            }
            Object value = model.lookup(first);
            if (value instanceof AbstractModel) {
                model = (AbstractModel)value;
                tail = rest;
                continue;
            }
            if (rest == null) {
                return value;
            }
            if ((value = this.dereference(value, null, model)) instanceof Context) {
                return ((Context)value).lookupLink(rest);
            }
            if (value != null) {
                throw new NotContextException(L.l("{0}: expected intermediate context at `{1}'", (Object)this.getFullPath(name), value));
            }
            throw new NameNotFoundException(this.getFullPath(name));
        }
        return this.create(this.getFullPath(name), model, this._env);
    }

    public Object lookupLink(Name name) throws NamingException {
        if (name == null) {
            return this.create(this._model, this._env);
        }
        AbstractModel model = this._model;
        for (int i = 0; i < name.size(); ++i) {
            String first = name.get(i);
            Object value = model.lookup(first);
            if (!(value instanceof AbstractModel)) {
                if (i + 1 == name.size()) {
                    return value;
                }
                if ((value = this.dereference(value, null, model)) instanceof Context) {
                    return ((Context)value).lookupLink(name.getSuffix(i + 1));
                }
                if (value != null) {
                    throw new NotContextException(L.l("{0}: expected intermediate context at `{1}'", (Object)this.getFullPath(name), value));
                }
                throw new NameNotFoundException(this.getFullPath(name));
            }
            model = (AbstractModel)value;
        }
        return this.create(this.getFullPath(name), model, this._env);
    }

    public void bind(String name, Object obj) throws NamingException {
        Object value;
        String rest;
        String tail = name;
        AbstractModel model = this._model;
        while (true) {
            String first = this.parseFirst(tail);
            rest = this.parseRest(tail);
            if (first == null) {
                throw new NamingException(L.l("can't bind root"));
            }
            if (rest == null) {
                value = model.lookup(first);
                if (value != null) {
                    throw new NamingException(L.l("`{0}' is already bound to `{1}'", (Object)name, value));
                }
                model.bind(first, this.getReference(model, obj));
                return;
            }
            value = model.lookup(first);
            if (!(value instanceof AbstractModel)) break;
            model = (AbstractModel)value;
            tail = rest;
        }
        if ((value = this.dereference(value, null, model)) instanceof Context) {
            ((Context)value).bind(rest, obj);
            return;
        }
        if (value != null) {
            throw new NotContextException(L.l("{0}: expected intermediate context at `{1}'", (Object)this.getFullPath(name), value));
        }
        throw new NameNotFoundException(this.getFullPath(name));
    }

    public void bind(Name name, Object obj) throws NamingException {
        Object value;
        String first;
        if (name.size() == 0) {
            throw new NamingException(L.l("can't bind root"));
        }
        AbstractModel model = this._model;
        int i = 0;
        while (i + 1 < name.size()) {
            first = name.get(i);
            value = model.lookup(first);
            if (!(value instanceof AbstractModel)) {
                if ((value = this.dereference(value, null, model)) instanceof Context) {
                    ((Context)value).bind(name.getSuffix(i + 1), obj);
                    return;
                }
                if (value != null) {
                    throw new NotContextException(L.l("{0}: expected intermediate context at `{1}'", (Object)this.getFullPath(name), value));
                }
                throw new NameNotFoundException(this.getFullPath(name));
            }
            model = (AbstractModel)value;
            ++i;
        }
        first = name.get(i);
        value = model.lookup(first);
        if (value != null) {
            throw new NamingException(L.l("`{0}' is already bound to `{1}'", (Object)name, value));
        }
        model.bind(first, this.getReference(model, obj));
    }

    public void rebind(String name, Object obj) throws NamingException {
        Object value;
        String rest;
        String tail = name;
        AbstractModel model = this._model;
        while (true) {
            String first = this.parseFirst(tail);
            rest = this.parseRest(tail);
            if (first == null) {
                throw new NamingException(L.l("can't bind root"));
            }
            if (rest == null) {
                model.bind(first, this.getReference(model, obj));
                return;
            }
            value = model.lookup(first);
            if (!(value instanceof AbstractModel)) break;
            model = (AbstractModel)value;
            tail = rest;
        }
        if ((value = this.dereference(value, null, model)) instanceof Context) {
            ((Context)value).rebind(rest, obj);
            return;
        }
        if (value != null) {
            throw new NotContextException(L.l("{0}: expected intermediate context at `{1}'", (Object)this.getFullPath(name), value));
        }
        throw new NameNotFoundException(this.getFullPath(name));
    }

    public void rebind(Name name, Object obj) throws NamingException {
        String first;
        if (name.size() == 0) {
            throw new NamingException(L.l("can't bind root"));
        }
        AbstractModel model = this._model;
        int i = 0;
        while (i + 1 < name.size()) {
            first = name.get(i);
            Object value = model.lookup(first);
            if (!(value instanceof AbstractModel)) {
                if ((value = this.dereference(value, null, model)) instanceof Context) {
                    ((Context)value).bind(name.getSuffix(i + 1), obj);
                    return;
                }
                if (value != null) {
                    throw new NotContextException(L.l("{0}: expected intermediate context at `{1}'", (Object)this.getFullPath(name), value));
                }
                throw new NameNotFoundException(this.getFullPath(name));
            }
            model = (AbstractModel)value;
            ++i;
        }
        first = name.get(i);
        model.bind(first, this.getReference(model, obj));
    }

    private Object getReference(AbstractModel model, Object obj) {
        return obj;
    }

    public void unbind(String name) throws NamingException {
        Object value;
        String rest;
        String tail = name;
        AbstractModel model = this._model;
        while (true) {
            String first = this.parseFirst(tail);
            rest = this.parseRest(tail);
            if (first == null) {
                throw new NamingException(L.l("can't unbind root"));
            }
            if (rest == null) {
                if (model.lookup(name) instanceof AbstractModel) {
                    throw new NamingException(L.l("can't unbind subcontext; use destroySubcontext"));
                }
                model.unbind(first);
                return;
            }
            value = model.lookup(first);
            if (!(value instanceof AbstractModel)) break;
            model = (AbstractModel)value;
            tail = rest;
        }
        if ((value = this.dereference(value, null, model)) instanceof Context) {
            ((Context)value).unbind(rest);
            return;
        }
        if (value != null) {
            throw new NotContextException(L.l("{0}: expected intermediate context at `{1}'", (Object)this.getFullPath(name), value));
        }
        throw new NameNotFoundException(this.getFullPath(name));
    }

    private Object dereference(Object value, Name tail, AbstractModel model) throws NamingException {
        try {
            if (value instanceof ObjectProxy) {
                return ((ObjectProxy)value).createObject(this._env);
            }
            if (value instanceof Reference) {
                ContextImpl context = this.create(model, this._env);
                return NamingManager.getObjectInstance(value, null, context, this._env);
            }
            return value;
        }
        catch (NamingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new NamingExceptionWrapper(e);
        }
    }

    public void unbind(Name name) throws NamingException {
        String first;
        if (name.size() == 0) {
            throw new NamingException(L.l("can't unbind root"));
        }
        AbstractModel model = this._model;
        int i = 0;
        while (i + 1 < name.size()) {
            first = name.get(i);
            Object value = model.lookup(first);
            if (!(value instanceof AbstractModel)) {
                if ((value = this.dereference(value, null, model)) instanceof Context) {
                    ((Context)value).unbind(name.getSuffix(i + 1));
                    return;
                }
                if (value != null) {
                    throw new NotContextException(L.l("{0}: expected intermediate context at `{1}'", (Object)this.getFullPath(name), value));
                }
                throw new NameNotFoundException(this.getFullPath(name));
            }
            model = (AbstractModel)value;
            ++i;
        }
        first = name.get(i);
        model.unbind(first);
    }

    public void rename(String oldName, String newName) throws NamingException {
        Object obj = this.lookup(oldName);
        this.unbind(oldName);
        this.bind(newName, obj);
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        Object obj = this.lookup(oldName);
        this.unbind(oldName);
        this.bind(newName, obj);
    }

    public NamingEnumeration list(String name) throws NamingException {
        Object value;
        String rest;
        String tail = name;
        AbstractModel model = this._model;
        while (true) {
            String first = this.parseFirst(tail);
            rest = this.parseRest(tail);
            if (first == null) {
                return new QNameClassEnumeration(this.create(model, this._env), model.list());
            }
            value = model.lookup(first);
            if (!(value instanceof AbstractModel)) break;
            model = (AbstractModel)value;
            tail = rest;
        }
        if ((value = this.dereference(value, null, model)) instanceof Context) {
            return ((Context)value).list(rest);
        }
        if (value != null) {
            throw new NotContextException(L.l("{0}: expected intermediate context at `{1}'", (Object)this.getFullPath(name), value));
        }
        throw new NameNotFoundException(this.getFullPath(name));
    }

    public NamingEnumeration list(Name name) throws NamingException {
        AbstractModel model = this._model;
        if (name == null) {
            return new QNameClassEnumeration(this.create(model, this._env), model.list());
        }
        for (int i = 0; i < name.size(); ++i) {
            String first = name.get(i);
            Object value = model.lookup(first);
            if (!(value instanceof AbstractModel)) {
                if ((value = this.dereference(value, null, model)) instanceof Context) {
                    return ((Context)value).list(name.getSuffix(i + 1));
                }
                if (value != null) {
                    throw new NotContextException(L.l("{0}: expected intermediate context at `{1}'", (Object)this.getFullPath(name), value));
                }
                throw new NameNotFoundException(this.getFullPath(name));
            }
            model = (AbstractModel)value;
        }
        return new QNameClassEnumeration(this.create(model, this._env), model.list());
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        Object value;
        String rest;
        String tail = name;
        AbstractModel model = this._model;
        while (true) {
            String first = this.parseFirst(tail);
            rest = this.parseRest(tail);
            if (first == null) {
                return new QBindingEnumeration(this.create(model, this._env), model.list());
            }
            value = model.lookup(first);
            if (!(value instanceof AbstractModel)) break;
            model = (AbstractModel)value;
            tail = rest;
        }
        if ((value = this.dereference(value, null, model)) instanceof Context) {
            return ((Context)value).list(rest);
        }
        if (value != null) {
            throw new NotContextException(L.l("{0}: expected intermediate context at `{1}'", (Object)this.getFullPath(name), value));
        }
        throw new NameNotFoundException(this.getFullPath(name));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        AbstractModel model = this._model;
        for (int i = 0; name != null && i < name.size(); ++i) {
            String first = name.get(i);
            Object value = model.lookup(first);
            if (!(value instanceof AbstractModel)) {
                if ((value = this.dereference(value, null, model)) instanceof Context) {
                    return ((Context)value).list(name.getSuffix(i + 1));
                }
                if (value != null) {
                    throw new NotContextException(L.l("{0}: expected intermediate context at `{1}'", (Object)this.getFullPath(name), value));
                }
                throw new NameNotFoundException(this.getFullPath(name));
            }
            model = (AbstractModel)value;
        }
        return new QBindingEnumeration(this.create(model, this._env), model.list());
    }

    public Context createSubcontext(String name) throws NamingException {
        Object value;
        String rest;
        String tail = name;
        AbstractModel model = this._model;
        while (true) {
            String first = this.parseFirst(tail);
            rest = this.parseRest(tail);
            if (first == null) {
                throw new NamingException(L.l("can't create root subcontext"));
            }
            if (rest == null) {
                model = model.createSubcontext(first);
                return this.create(this.getFullPath(name), model, this._env);
            }
            value = model.lookup(first);
            if (!(value instanceof AbstractModel)) break;
            model = (AbstractModel)value;
            tail = rest;
        }
        if ((value = this.dereference(value, null, model)) instanceof Context) {
            return ((Context)value).createSubcontext(rest);
        }
        if (value != null) {
            throw new NotContextException(L.l("{0}: expected intermediate context at `{1}'", (Object)this.getFullPath(name), value));
        }
        throw new NameNotFoundException(this.getFullPath(name));
    }

    public Context createSubcontext(Name name) throws NamingException {
        String first;
        if (name.size() == 0) {
            throw new NamingException(L.l("can't createSubcontext root"));
        }
        AbstractModel model = this._model;
        int i = 0;
        while (i + 1 < name.size()) {
            first = name.get(i);
            Object value = model.lookup(first);
            if (!(value instanceof AbstractModel)) {
                if ((value = this.dereference(value, null, model)) instanceof Context) {
                    return ((Context)value).createSubcontext(name.getSuffix(i + 1));
                }
                if (value != null) {
                    throw new NotContextException(L.l("{0}: expected intermediate context at `{1}'", (Object)this.getFullPath(name), value));
                }
                throw new NameNotFoundException(this.getFullPath(name));
            }
            model = (AbstractModel)value;
            ++i;
        }
        first = name.get(i);
        model = model.createSubcontext(first);
        return this.create(model, this._env);
    }

    public void destroySubcontext(String name) throws NamingException {
        Object value;
        String rest;
        String tail = name;
        AbstractModel model = this._model;
        while (true) {
            String first = this.parseFirst(tail);
            rest = this.parseRest(tail);
            if (first == null) {
                throw new NamingException(L.l("can't create root subcontext"));
            }
            if (rest == null) {
                model.unbind(first);
                return;
            }
            value = model.lookup(first);
            if (!(value instanceof AbstractModel)) break;
            model = (AbstractModel)value;
            tail = rest;
        }
        if ((value = this.dereference(value, null, model)) instanceof Context) {
            ((Context)value).destroySubcontext(rest);
            return;
        }
        if (value != null) {
            throw new NotContextException(L.l("{0}: expected intermediate context at `{1}'", (Object)this.getFullPath(name), value));
        }
        throw new NameNotFoundException(this.getFullPath(name));
    }

    public void destroySubcontext(Name name) throws NamingException {
        String first;
        if (name.size() == 0) {
            throw new NamingException(L.l("can't createSubcontext root"));
        }
        AbstractModel model = this._model;
        int i = 0;
        while (i + 1 < name.size()) {
            first = name.get(i);
            Object value = model.lookup(first);
            if (!(value instanceof AbstractModel)) {
                if ((value = this.dereference(value, null, model)) instanceof Context) {
                    ((Context)value).destroySubcontext(name.getSuffix(i + 1));
                    return;
                }
                if (value != null) {
                    throw new NotContextException(L.l("{0}: expected intermediate context at `{1}'", (Object)this.getFullPath(name), value));
                }
                throw new NameNotFoundException(this.getFullPath(name));
            }
            model = (AbstractModel)value;
            ++i;
        }
        first = name.get(i);
        model.unbind(first);
    }

    public NameParser getNameParser(String name) throws NamingException {
        String first = this.parseFirst(name);
        String rest = this.parseRest(name);
        if (first == null) {
            return new QNameParser(this);
        }
        Object obj = this.lookupSingleObject(first);
        if (obj instanceof Context) {
            return ((Context)obj).getNameParser(rest == null ? "" : rest);
        }
        return new QNameParser(this);
    }

    public NameParser getNameParser(Name name) throws NamingException {
        if (name.size() == 0) {
            return new QNameParser(this);
        }
        Object obj = this.lookupSingleObject(name.get(0));
        if (obj instanceof Context) {
            return ((Context)obj).getNameParser(name.getSuffix(1));
        }
        return new QNameParser(this);
    }

    public String composeName(String prefix, String suffix) throws NamingException {
        return prefix + "/" + suffix;
    }

    public Name composeName(Name prefix, Name suffix) throws NamingException {
        return prefix.addAll(suffix);
    }

    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException();
    }

    private Object lookupSingleObject(String name) throws NamingException {
        Object obj = this.lookupSingle(name);
        if (obj instanceof ObjectProxy) {
            return ((ObjectProxy)obj).createObject(this._env);
        }
        return obj;
    }

    protected Object lookupSingle(String name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    protected void rebindSingle(String name, Object obj) throws NamingException {
        throw new UnsupportedOperationException();
    }

    protected void unbindSingle(String name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    protected Context createSingleSubcontext(String name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    protected void destroySingleSubcontext(String name) throws NamingException {
        this.unbindSingle(name);
    }

    protected Iterator listSingle() {
        throw new UnsupportedOperationException();
    }

    protected String parseFirst(String name) throws NamingException {
        if (name == null || name.equals("")) {
            return null;
        }
        int p = name.indexOf(this.getSeparator());
        if (p == 0) {
            return this.parseFirst(name.substring(1));
        }
        if (p > 0) {
            return name.substring(0, p);
        }
        return name;
    }

    protected String parseRest(String name) throws NamingException {
        if (name == null || name.equals("")) {
            return null;
        }
        int p = name.indexOf(this.getSeparator());
        if (p == 0) {
            return this.parseRest(name.substring(1));
        }
        if (p > 0) {
            return name.substring(p + 1);
        }
        return null;
    }

    protected char getSeparator() {
        return '/';
    }

    protected String getSeparatorString() {
        return "/";
    }

    protected String getFullPath(String name) {
        if (this._name == null || this._name.equals("")) {
            return name;
        }
        if (name == null) {
            return this._name;
        }
        String sep = this.getSeparatorString();
        while (name.endsWith(sep)) {
            name = name.substring(0, name.length() - sep.length());
        }
        if (name.equals("")) {
            return this._name;
        }
        if (name.startsWith(sep)) {
            return this._name + name;
        }
        return this._name + sep + name;
    }

    protected String getFullPath(Name name) {
        if (this._name == null || this._name.equals("")) {
            return name.toString();
        }
        if (name == null || name.size() == 0) {
            return this._name;
        }
        String sep = this.getSeparatorString();
        return this._name + sep + name;
    }

    public Object addToEnvironment(String prop, Object value) throws NamingException {
        Object old = this._env.get(prop);
        this._env.put(prop, value);
        return old;
    }

    public Object removeFromEnvironment(String prop) throws NamingException {
        Object old = this._env.get(prop);
        this._env.remove(prop);
        return old;
    }

    public Hashtable getEnvironment() throws NamingException {
        return this._env;
    }

    public void close() throws NamingException {
    }

    public String toString() {
        return "[ContextImpl " + this._name + "]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

