/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.http.Application;
import com.caucho.server.http.CauchoRequest;
import com.caucho.util.CharBuffer;
import com.caucho.util.URLUtil;
import com.caucho.vfs.Path;
import com.caucho.vfs.Pwd;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.util.Iterator;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DirectoryServlet
extends HttpServlet {
    Application app;
    Path context;

    public void init() {
        this.app = (Application)this.getServletContext();
        this.context = this.app.getAppDir();
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String pathInfo;
        String uri;
        String encoding;
        CauchoRequest cauchoReq = null;
        if (req instanceof CauchoRequest) {
            cauchoReq = (CauchoRequest)req;
        }
        if ((encoding = this.app.getCharEncoding()) == null) {
            res.setContentType("text/html");
        } else {
            res.setContentType("text/html; charset=" + encoding);
        }
        boolean isInclude = false;
        if (cauchoReq != null) {
            uri = cauchoReq.getPageURI();
            isInclude = !uri.equals(cauchoReq.getRequestURI());
        } else {
            uri = (String)req.getAttribute("javax.servlet.include.request_uri");
            if (uri != null) {
                isInclude = true;
            } else {
                uri = req.getRequestURI();
            }
        }
        CharBuffer cb = CharBuffer.allocate();
        String servletPath = cauchoReq != null ? cauchoReq.getPageServletPath() : (isInclude ? (String)req.getAttribute("javax.servlet.include.servlet_path") : req.getServletPath());
        if (servletPath != null) {
            cb.append(servletPath);
        }
        if ((pathInfo = cauchoReq != null ? cauchoReq.getPagePathInfo() : (isInclude ? (String)req.getAttribute("javax.servlet.include.path_info") : req.getPathInfo())) != null) {
            cb.append(pathInfo);
        }
        String relPath = cb.close();
        String filename = this.getServletContext().getRealPath(relPath);
        Path path = this.context.lookupNative(filename);
        String rawpath = URLDecoder.decode(uri);
        PrintWriter pw = res.getWriter();
        if (rawpath.length() == 0 || rawpath.charAt(0) != '/') {
            rawpath = "/" + rawpath;
        }
        boolean endsSlash = rawpath.charAt(rawpath.length() - 1) == '/';
        String tail = "";
        if (!endsSlash) {
            int p = rawpath.lastIndexOf(47);
            tail = rawpath.substring(p + 1) + "/";
            rawpath = rawpath + "/";
        }
        pw.println("<html>");
        pw.println("<head>");
        pw.println("<title>Directory of " + rawpath + "</title>");
        pw.println("</head>");
        pw.println("<body>");
        pw.println("<h1>Directory of " + rawpath + "</h1>");
        pw.println("<ul>");
        Iterator i = path.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            if (name.equalsIgnoreCase("web-inf") || name.equalsIgnoreCase("meta-inf")) continue;
            String enc = URLUtil.encodeURL(tail + name);
            pw.println("<li><a href='" + enc + "'>" + name + "</a>");
        }
        pw.println("</ul>");
        pw.println("</body>");
        pw.println("</html>");
        pw.close();
    }

    public DirectoryServlet(Path context) {
        this.context = context;
    }

    public DirectoryServlet() {
        this(Pwd.lookup());
    }
}

