/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.naming.LinkProxy;
import com.caucho.server.http.Application;
import com.caucho.server.http.ClassLoaderContext;
import com.caucho.server.http.JndiFactory;
import com.caucho.server.http.QServletConfig;
import com.caucho.util.IntMap;
import com.caucho.util.L10N;
import com.caucho.util.Registry;
import com.caucho.util.RegistryNode;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.WriteStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import javax.servlet.ServletException;

public class EarContext
extends ClassLoaderContext {
    static WriteStream dbg = LogStream.open("/caucho.com/http/ear");
    static L10N L = new L10N(class$com$caucho$server$http$EarContext == null ? (class$com$caucho$server$http$EarContext = EarContext.class$("com.caucho.server.http.EarContext")) : class$com$caucho$server$http$EarContext);
    private static IntMap applicationElements = new IntMap();
    private static IntMap moduleElements;
    private static IntMap webElements;
    private ArrayList webList = new ArrayList();
    private HashMap webToContextPathMap = new HashMap();
    private Application earApplication;
    static /* synthetic */ Class class$com$caucho$server$http$EarContext;

    EarContext(ClassLoaderContext parent) {
        super(parent);
    }

    void init(RegistryNode registry) throws Exception {
        String pathName = "_" + this.getName();
        registry = registry.lookup("application");
        EarContext.verifyElements(registry, applicationElements);
        Path resinXml = this.getWebInfPath().lookup("WEB-INF/resin-web.xml");
        this.addDepend(resinXml);
        if (resinXml.canRead()) {
            RegistryNode webResin;
            if (dbg.canWrite()) {
                dbg.log("using: " + resinXml);
            }
            resinXml.setUserPath(resinXml.getNativePath());
            Registry root = Registry.parse(resinXml);
            RegistryNode top = root.getTop();
            if (registry != null) {
                registry = (RegistryNode)registry.clone();
            }
            if ((webResin = top.lookup("web-app")) == null) {
                throw EarContext.error(top, L.l("resin.xml is missing top-level <web-app>"));
            }
            EarContext.verifyElements(webResin, _webAppElements);
            if (registry == null) {
                registry = webResin;
            } else {
                EarContext.mergeRegistry(registry, webResin);
            }
        }
        this.setPathVariableMap((HashMap)this.getParent().getPathVariableMap().clone());
        this.setRegistry(registry);
        this.init();
        if (registry == null) {
            return;
        }
        Iterator iter = registry.select("module");
        while (iter.hasNext()) {
            RegistryNode module = (RegistryNode)iter.next();
            EarContext.verifyElements(module, moduleElements);
            Iterator subIter = module.iterator();
            while (subIter.hasNext()) {
                RegistryNode subnode = (RegistryNode)subIter.next();
                if (!subnode.getName().equals("web")) continue;
                EarContext.verifyElements(subnode, webElements);
                String uri = subnode.getString("web-uri", null);
                String contextRoot = EarContext.getRequiredString(subnode, "context-root");
                if (!contextRoot.startsWith("/")) {
                    contextRoot = "/" + contextRoot;
                }
                if (uri != null) {
                    if (!uri.startsWith("/")) {
                        uri = "/" + uri;
                    }
                    if (uri.endsWith(".war")) {
                        uri = uri.substring(0, uri.length() - 4);
                    } else if (uri.endsWith(".jar")) {
                        uri = uri.substring(0, uri.length() - 4);
                    }
                    this.webToContextPathMap.put(uri, contextRoot);
                } else {
                    this.webToContextPathMap.put(contextRoot, contextRoot);
                }
                this.webList.add(contextRoot);
            }
        }
    }

    public boolean isEarApplication(String name) {
        return name.equals("/_" + this.getName());
    }

    void initEarApplication(Application app) {
        this.earApplication = app;
        app.setEarApplication(true);
        try {
            QServletConfig burlapServlet = app.addServlet("burlap", "com.caucho.burlap.EJBServlet");
            burlapServlet.setInitParameter("url-prefix", app.getURL() + "/burlap");
            burlapServlet.setInitParameter("local-id", app.getContextPath());
            app.addDispatchMap("/burlap/*", burlapServlet);
        }
        catch (Exception e) {
            dbg.log(e);
            return;
        }
    }

    boolean configure() throws Exception {
        Path appXml = this.getRootPath().lookup("sun-j2ee-ri.xml");
        if (!appXml.canRead()) {
            return false;
        }
        Registry registry = null;
        Context env = null;
        try {
            env = (Context)new InitialContext().lookup("java:comp/env");
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        try {
            registry = Registry.parse(appXml);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        RegistryNode top = registry.getTop();
        top = top.lookup("j2ee-ri-specific-information");
        if (top == null) {
            return false;
        }
        HashMap<String, String> ejbNames = new HashMap<String, String>();
        Iterator beanIter = top.select("enterprise-beans");
        while (beanIter.hasNext()) {
            RegistryNode beans = (RegistryNode)beanIter.next();
            Iterator iter = beans.select("ejb");
            while (iter.hasNext()) {
                RegistryNode ejb = (RegistryNode)iter.next();
                String ejbName = ejb.getString("ejb-name", null);
                String jndiName = ejb.getString("jndi-name", null);
                if (ejbName == null || jndiName == null) continue;
                ejbNames.put(jndiName, ejbName);
            }
        }
        String appName = "/_" + this.getName();
        RegistryNode appWeb = null;
        Iterator iter = top.select("web");
        while (iter.hasNext()) {
            RegistryNode web = (RegistryNode)iter.next();
            String contextRoot = web.getString("context-root", null);
            if (contextRoot == null) continue;
            if (!contextRoot.startsWith("/")) {
                contextRoot = "/" + contextRoot;
            }
            if (!contextRoot.equals(appName)) continue;
            appWeb = web;
            break;
        }
        if (appWeb == null && !appName.equals("/_ejb")) {
            return false;
        }
        Context ejbContext = null;
        try {
            Class<?> cl = Class.forName("com.caucho.burlap.BurlapContextFactory");
            InitialContextFactory factory = (InitialContextFactory)cl.newInstance();
            Hashtable props = new Hashtable();
            ejbContext = factory.getInitialContext(props);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServletException("Burlap must be supported");
        }
        if (appName.equals("/_ejb")) {
            beanIter = top.select("enterprise-beans");
            while (beanIter.hasNext()) {
                RegistryNode beans = (RegistryNode)beanIter.next();
                Iterator subIter = beans.select("ejb");
                while (subIter.hasNext()) {
                    RegistryNode ejb = (RegistryNode)subIter.next();
                    Iterator ejbRefIter = ejb.select("ejb-ref");
                    while (ejbRefIter.hasNext()) {
                        RegistryNode ejbRef = (RegistryNode)ejbRefIter.next();
                        this.initEjbRef(env, ejbRef, ejbNames, ejbContext);
                    }
                }
            }
        } else {
            iter = appWeb.select("ejb-ref");
            while (iter.hasNext()) {
                RegistryNode ejbRef = (RegistryNode)iter.next();
                this.initEjbRef(env, ejbRef, ejbNames, ejbContext);
            }
        }
        return true;
    }

    void initEjbRef(Context env, RegistryNode ejbRef, HashMap ejbNames, Context ejbContext) throws NamingException, ServletException {
        String refName = ejbRef.getString("ejb-ref-name", null);
        String jndiName = ejbRef.getString("jndi-name", null);
        if (refName == null || jndiName == null) {
            return;
        }
        String ejbName = (String)ejbNames.get(jndiName);
        if (ejbName == null) {
            return;
        }
        LinkProxy proxy = new LinkProxy(null, null, ejbName);
        JndiFactory.deepBind(env, refName, proxy, ejbRef);
    }

    public String mapContextPath(String name) {
        return (String)this.webToContextPathMap.get(name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        applicationElements.put("icon", 1);
        applicationElements.put("display-name", 1);
        applicationElements.put("description", 1);
        applicationElements.put("module", 2);
        applicationElements.put("security-role", 2);
        moduleElements = new IntMap();
        moduleElements.put("connector", 1);
        moduleElements.put("ejb", 1);
        moduleElements.put("java", 1);
        moduleElements.put("web", 1);
        moduleElements.put("alt-dd", 1);
        webElements = new IntMap();
        webElements.put("web-uri", 1);
        webElements.put("context-root", 1);
    }
}

