/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.util.CharCursor;
import com.caucho.util.StringCharCursor;
import com.caucho.vfs.ByteToChar;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;

class Form {
    static WriteStream dbg = LogStream.open("/caucho.com/http/form");
    private ByteToChar _converter = ByteToChar.create();

    Form() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void parseQueryString(HashMap table, String query, String javaEncoding) throws IOException {
        StringCharCursor is = new StringCharCursor(query);
        ByteToChar converter = this._converter;
        try {
            converter.setEncoding(javaEncoding);
        }
        catch (UnsupportedEncodingException e) {
            dbg.log(e);
        }
        char ch = ((CharCursor)is).current();
        while (ch != '\uffff') {
            while (Character.isWhitespace(ch) || ch == '&') {
                ch = ((CharCursor)is).next();
            }
            converter.clear();
            while (ch != '\uffff' && ch != '=' && ch != '&') {
                Form.readChar(converter, is, (int)ch);
                ch = ((CharCursor)is).next();
            }
            String key = converter.getConvertedString();
            converter.clear();
            if (ch == '=') {
                ch = ((CharCursor)is).next();
            }
            while (ch != '\uffff' && ch != '&') {
                Form.readChar(converter, is, (int)ch);
                ch = ((CharCursor)is).next();
            }
            String value = converter.getConvertedString();
            if (dbg.canWrite()) {
                dbg.log("query: " + key + "=" + value);
            }
            String[] oldValue = (String[])table.get(key);
            if (key == null || key.equals("")) continue;
            if (oldValue == null) {
                table.put(key, new String[]{value});
                continue;
            }
            String[] newValue = new String[oldValue.length + 1];
            System.arraycopy(oldValue, 0, newValue, 0, oldValue.length);
            newValue[oldValue.length] = value;
            table.put(key, newValue);
        }
        return;
    }

    private static void readChar(ByteToChar converter, CharCursor is, int ch) throws IOException {
        if (ch == 43) {
            converter.addByte(32);
        } else if (ch == 37) {
            char ch1 = is.next();
            if (ch1 == 'u') {
                ch1 = is.next();
                char ch2 = is.next();
                char ch3 = is.next();
                char ch4 = is.next();
                converter.addChar((char)((Form.toHex(ch1) << 12) + (Form.toHex(ch2) << 8) + (Form.toHex(ch3) << 4) + Form.toHex(ch4)));
            } else {
                char ch2 = is.next();
                converter.addByte((Form.toHex(ch1) << 4) + Form.toHex(ch2));
            }
        } else {
            converter.addByte(ch);
        }
    }

    void parsePostData(HashMap table, InputStream is, String javaEncoding) throws IOException {
        ByteToChar converter = this._converter;
        converter.clear();
        try {
            converter.setEncoding(javaEncoding);
        }
        catch (UnsupportedEncodingException e) {
            dbg.log(e);
        }
        int ch = is.read();
        while (ch >= 0) {
            while (Character.isWhitespace((char)ch) || ch == 38) {
                ch = is.read();
            }
            converter.clear();
            while (ch >= 0 && ch != 61 && ch != 38 && !Character.isWhitespace((char)ch)) {
                Form.readChar(converter, is, ch);
                ch = is.read();
            }
            String key = converter.getConvertedString();
            converter.clear();
            if (ch == 61) {
                ch = is.read();
            }
            while (ch >= 0 && ch != 38) {
                Form.readChar(converter, is, ch);
                ch = is.read();
            }
            String value = converter.getConvertedString();
            String[] oldValue = (String[])table.get(key);
            if (key == null || key.equals("")) continue;
            if (oldValue == null) {
                table.put(key, new String[]{value});
                continue;
            }
            String[] newValue = new String[oldValue.length + 1];
            System.arraycopy(oldValue, 0, newValue, 0, oldValue.length);
            newValue[oldValue.length] = value;
            table.put(key, newValue);
        }
    }

    private static void readChar(ByteToChar converter, InputStream is, int ch) throws IOException {
        if (ch == 43) {
            converter.addByte(32);
        } else if (ch == 37) {
            int ch1 = is.read();
            if (ch1 == 117) {
                ch1 = is.read();
                int ch2 = is.read();
                int ch3 = is.read();
                int ch4 = is.read();
                converter.addChar((char)((Form.toHex(ch1) << 12) + (Form.toHex(ch2) << 8) + (Form.toHex(ch3) << 4) + Form.toHex(ch4)));
            } else {
                int ch2 = is.read();
                converter.addByte((Form.toHex(ch1) << 4) + Form.toHex(ch2));
            }
        } else {
            converter.addByte(ch);
        }
    }

    private static int toHex(int ch) {
        if (ch >= 48 && ch <= 57) {
            return ch - 48;
        }
        if (ch >= 97 && ch <= 102) {
            return ch - 97 + 10;
        }
        if (ch >= 65 && ch <= 70) {
            return ch - 65 + 10;
        }
        return -1;
    }
}

