/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.Connection;
import com.caucho.server.http.JniResponse;
import com.caucho.server.http.JniStream;
import com.caucho.server.http.QServletInputStream;
import com.caucho.server.http.Request;
import com.caucho.server.http.ServletServer;
import com.caucho.util.CharBuffer;
import com.caucho.util.CharSegment;
import com.caucho.vfs.ClientDisconnectException;
import com.caucho.vfs.Encoding;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.servlet.ServletInputStream;

class JniRequest
extends Request {
    static WriteStream dbg = LogStream.open("/caucho.com/http/connection");
    static char[] hostCb = "Host".toCharArray();
    static char[] userAgentCb = "User-Agent".toCharArray();
    static CharBuffer http11Cb = new CharBuffer("HTTP/1.1");
    static CharBuffer http10Cb = new CharBuffer("HTTP/1.0");
    static final int HEADER_SIZE = 256;
    static final int HEADER_START = 4;
    private static int idCount;
    private int id;
    private int serverIP;
    private int serverPort;
    private String serverName;
    private InetAddress serverAddr;
    private int remoteIP;
    private int remotePort;
    private String remoteIPName;
    private InetAddress remoteAddr;
    private int sslBits;
    private CharBuffer virtualHost;
    private String scheme;
    private CharSegment method;
    private CharSegment host;
    private CharSegment cipher;
    private byte[] uri;
    private int uriLength;
    private CharSegment protocol;
    private char[] headerBuffer = new char[16384];
    private int[] headerOffsets = new int[512];
    private int headerSize;
    private CharSegment[] headerKeys;
    private CharSegment[] headerValues;
    private CharBuffer cb;
    private JniStream jniStream;
    private ReadStream is;
    private QServletInputStream sis;
    private WriteStream os;
    private boolean isFirst = true;

    JniRequest(ServletServer server) {
        super(server);
        this.id = idCount++;
        this.jniStream = new JniStream();
        this.is = new ReadStream();
        this.sis = new QServletInputStream();
        this.sis.init(this.is);
        this.os = new WriteStream();
        this.response = new JniResponse(this);
        this.uri = new byte[4096];
        this.cb = new CharBuffer();
        this.host = new CharSegment();
        this.method = new CharSegment();
        this.protocol = new CharSegment();
        this.cipher = new CharSegment();
        this.headerSize = 0;
        this.headerKeys = new CharSegment[256];
        this.headerValues = new CharSegment[256];
        for (int i = 0; i < 256; ++i) {
            this.headerKeys[i] = new CharSegment();
            this.headerValues[i] = new CharSegment();
        }
    }

    public void handleConnection(Connection conn) {
        throw new IllegalStateException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatch(int fd, int serverIP, int serverPort, int remoteIP, int remotePort, int sslBits) {
        if (this.isFirst) {
            this.isFirst = false;
        }
        this.serverName = null;
        this.serverAddr = null;
        this.serverIP = serverIP;
        this.serverPort = serverPort;
        this.serverAddr = null;
        this.remoteIP = remoteIP;
        this.remotePort = remotePort;
        this.remoteIPName = null;
        this.remoteAddr = null;
        this.sslBits = sslBits;
        try {
            this.setStartDate();
            this.jniStream.init(fd);
            this.os.init(this.jniStream);
            this.is.init(this.jniStream, this.os);
            this.response.init(this.os);
            try {
                this.start(this.is);
                if (sslBits > 0) {
                    this.setAttribute("javax.servlet.request.key_size", new Integer(sslBits));
                    this.setAttribute("javax.servlet.request.cipher_suite", this.cipher.toString());
                }
                if (this.host.length() > 0) {
                    this.invocationKey.init(this.host, 80, this.uri, this.uriLength, false);
                } else {
                    this.invocationKey.init(null, 80, this.uri, this.uriLength, false);
                }
                this.server.serviceTop(this.invocationKey, this, this.response);
            }
            catch (ClientDisconnectException e) {
                dbg.log("[" + this.getId() + "] " + e);
            }
            catch (OutOfMemoryError e) {
                throw e;
            }
            catch (Throwable e) {
                try {
                    this.sendServletError(e);
                }
                catch (Exception e1) {
                    dbg.log(e1);
                }
            }
            finally {
                this.response.finish(true);
            }
        }
        catch (ClientDisconnectException e) {
            dbg.log("[" + this.getId() + "] " + e);
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
            return false;
        }
        catch (Throwable e) {
            dbg.log("[" + this.getId() + "] " + e);
        }
        return true;
    }

    int getId() {
        return this.id;
    }

    protected boolean isTop() {
        return true;
    }

    protected boolean checkLogin() {
        return true;
    }

    protected void start(ReadStream s) throws IOException {
        super.start(s);
        this.method.init(this.headerBuffer, this.headerOffsets[0], this.headerOffsets[1] - this.headerOffsets[0]);
        this.protocol.init(this.headerBuffer, this.headerOffsets[1], this.headerOffsets[2] - this.headerOffsets[1]);
        this.host.init(this.headerBuffer, this.headerOffsets[2], this.headerOffsets[3] - this.headerOffsets[2]);
        this.cipher.init(this.headerBuffer, this.headerOffsets[3], this.headerOffsets[4] - this.headerOffsets[3]);
        int j = 4;
        for (int i = 0; i < this.headerSize; ++i) {
            int key = this.headerOffsets[j];
            int value = this.headerOffsets[j + 1];
            int next = this.headerOffsets[j + 2];
            this.headerKeys[i].init(this.headerBuffer, key, value - key - 1);
            this.headerValues[i].init(this.headerBuffer, value, next - value - 1);
            j += 2;
        }
    }

    public String getScheme() {
        return this.isSecure() ? "https" : "http";
    }

    public CharSegment getMethodBuffer() {
        return this.method;
    }

    CharSegment getHost() {
        if (this.host.length() > 0) {
            return this.host;
        }
        return null;
    }

    public byte[] getUriBuffer() {
        return this.uri;
    }

    public int getUriLength() {
        return this.uriLength;
    }

    public boolean isSecure() {
        return this.sslBits > 0;
    }

    public CharSegment getProtocolBuffer() {
        return this.protocol;
    }

    public void setHeader(String key, String value) {
    }

    public CharSegment getHeaderBuffer(char[] testBuf, int length) {
        for (int i = this.headerSize - 1; i >= 0; --i) {
            int j;
            CharSegment key = this.headerKeys[i];
            if (key.length() != length) continue;
            char[] keyBuf = key.getBuffer();
            int offset = key.getOffset();
            for (j = length - 1; j >= 0; --j) {
                char a = testBuf[j];
                char b = keyBuf[offset + j];
                if (a == b) continue;
                if (a >= 'A' && a <= 'Z') {
                    a = (char)(a + 32);
                }
                if (b >= 'A' && b <= 'Z') {
                    b = (char)(b + 32);
                }
                if (a != b) break;
            }
            if (j >= 0) continue;
            return this.headerValues[i];
        }
        return null;
    }

    public CharSegment getHeaderBuffer(String key) {
        int i = this.matchNextHeader(0, key);
        if (i >= 0) {
            return this.headerValues[i];
        }
        return null;
    }

    public void getHeaderBuffers(ArrayList values, String key) {
        int i = -1;
        while ((i = this.matchNextHeader(i + 1, key)) >= 0) {
            values.add(this.headerValues[i]);
        }
    }

    public Enumeration getHeaders(String key) {
        ArrayList<String> values = new ArrayList<String>();
        int i = -1;
        while ((i = this.matchNextHeader(i + 1, key)) >= 0) {
            values.add(this.headerValues[i].toString());
        }
        return Collections.enumeration(values);
    }

    private int matchNextHeader(int i, String key) {
        int size = this.headerSize;
        int length = key.length();
        while (i < size) {
            CharSegment header = this.headerKeys[i];
            if (header.length() == length) {
                int j;
                char[] keyBuf = header.getBuffer();
                int offset = header.getOffset();
                for (j = 0; j < length; ++j) {
                    char b;
                    char a = key.charAt(j);
                    if (a == (b = keyBuf[j + offset])) continue;
                    if (a >= 'A' && a <= 'Z') {
                        a = (char)(a + 32);
                    }
                    if (b >= 'A' && b <= 'Z') {
                        b = (char)(b + 32);
                    }
                    if (a != b) break;
                }
                if (j == length) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    public Enumeration getHeaderNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < this.headerSize; ++i) {
            String oldName;
            int j;
            CharSegment name = this.headerKeys[i];
            for (j = 0; j < names.size() && !name.matches(oldName = (String)names.get(j)); ++j) {
            }
            if (j != names.size()) continue;
            names.add(j, name.toString());
        }
        return Collections.enumeration(names);
    }

    public String getServerName() {
        CharSegment host = this.getHost();
        if (host != null) {
            int p = host.indexOf(':');
            if (p >= 0) {
                return host.substring(0, p);
            }
            return host.toString();
        }
        if (this.serverAddr == null) {
            CharBuffer cb = CharBuffer.allocate();
            cb.append(this.serverIP >> 24 & 0xFF);
            cb.append('.');
            cb.append(this.serverIP >> 16 & 0xFF);
            cb.append('.');
            cb.append(this.serverIP >> 8 & 0xFF);
            cb.append('.');
            cb.append(this.serverIP & 0xFF);
            String name = cb.close();
            try {
                this.serverAddr = InetAddress.getByName(name);
            }
            catch (Exception e) {
                return name;
            }
            return this.serverAddr.getHostName();
        }
        return this.serverAddr.getHostName();
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public String getRemoteAddr() {
        if (this.remoteIPName == null) {
            CharBuffer cb = CharBuffer.allocate();
            cb.append(this.remoteIP >> 24 & 0xFF);
            cb.append('.');
            cb.append(this.remoteIP >> 16 & 0xFF);
            cb.append('.');
            cb.append(this.remoteIP >> 8 & 0xFF);
            cb.append('.');
            cb.append(this.remoteIP & 0xFF);
            this.remoteIPName = cb.close();
        }
        return this.remoteIPName;
    }

    public String getRemoteHost() {
        if (this.remoteAddr == null) {
            try {
                this.remoteAddr = InetAddress.getByName(this.getRemoteAddr());
            }
            catch (Exception e) {
                return this.getRemoteAddr();
            }
        }
        return this.remoteAddr.getHostName();
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.hasInputStream) {
            return this.sis;
        }
        this.hasInputStream = true;
        String charEncoding = this.getCharacterEncoding();
        String javaEncoding = Encoding.getJavaName(charEncoding);
        this.is.setEncoding(javaEncoding);
        return this.sis;
    }

    public ReadStream getStream() throws IOException {
        return this.is;
    }

    public int printRemoteAddr(byte[] buffer, int offset) throws IOException {
        int shift = 24;
        for (int i = 0; i < 4; ++i) {
            int value;
            if (i != 0) {
                buffer[offset++] = 46;
            }
            if ((value = this.remoteIP >> shift & 0xFF) < 10) {
                buffer[offset++] = (byte)(value + 48);
            } else if (value < 100) {
                buffer[offset++] = (byte)(value / 10 + 48);
                buffer[offset++] = (byte)(value % 10 + 48);
            } else {
                buffer[offset++] = (byte)(value / 100 + 48);
                buffer[offset++] = (byte)(value / 10 % 10 + 48);
                buffer[offset++] = (byte)(value % 10 + 48);
            }
            shift -= 8;
        }
        return offset;
    }

    void setSecure(boolean secure) {
        this.bogusSecure = secure;
    }
}

